/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Date;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetQuery {
    private Long user = null;
    private LatLon min = null;
    private LatLon max = null;
    private Date closedAfter = null;
    private Date createdBefore = null;
    private Boolean open = null;
    private Boolean closed = null;

    public ChangesetQuery forUser(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", l));
        }
        this.user = l;
        return this;
    }

    public ChangesetQuery inBbox(double d, double d2, double d3, double d4) {
        return this.inBbox(new LatLon(d, d2), new LatLon(d3, d4));
    }

    public ChangesetQuery inBbox(LatLon latLon, LatLon latLon2) {
        this.min = latLon;
        this.max = latLon2;
        return this;
    }

    public ChangesetQuery closedAfter(Date date) {
        this.closedAfter = date;
        return this;
    }

    public ChangesetQuery between(Date date, Date date2) {
        this.closedAfter = date;
        this.createdBefore = date2;
        return this;
    }

    public ChangesetQuery beingOpen() {
        this.open = true;
        this.closed = null;
        return this;
    }

    public ChangesetQuery beingClosed() {
        this.open = null;
        this.closed = true;
        return this;
    }

    public String getQueryString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.user != null) {
            stringBuffer.append("user").append("=").append(this.user);
        }
        if (this.min != null && this.max != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("min_lon").append("=").append(this.min.lonToString(CoordinateFormat.DECIMAL_DEGREES));
            stringBuffer.append("&");
            stringBuffer.append("min_lat").append("=").append(this.min.latToString(CoordinateFormat.DECIMAL_DEGREES));
            stringBuffer.append("&");
            stringBuffer.append("max_lon").append("=").append(this.max.lonToString(CoordinateFormat.DECIMAL_DEGREES));
            stringBuffer.append("&");
            stringBuffer.append("max_lat").append("=").append(this.max.latToString(CoordinateFormat.DECIMAL_DEGREES));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("time").append("=").append(DateUtils.fromDate(this.closedAfter)).append(",").append(DateUtils.fromDate(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("time").append("=").append(DateUtils.fromDate(this.closedAfter));
        }
        if (this.open != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("open=true");
        } else if (this.closed != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("closed=true");
        }
        return stringBuffer.toString();
    }
}

