/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files") + " (*.osm *.xml)"));
    }

    public OsmExporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    public void exportData(File file, Layer layer) throws IOException {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(I18n.tr("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        this.save(file, (OsmDataLayer)layer);
    }

    protected OutputStream getOutputStream(File file) throws FileNotFoundException, IOException {
        return new FileOutputStream(file);
    }

    private void save(File file, OsmDataLayer osmDataLayer) {
        File file2 = null;
        try {
            if (file.exists()) {
                file2 = new File(file.getPath() + "~");
                this.copy(file, file2);
            }
            OutputStream outputStream = this.getOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            OsmWriter osmWriter = new OsmWriter(new PrintWriter(outputStreamWriter), false, osmDataLayer.data.version);
            osmWriter.header();
            osmWriter.writeDataSources(osmDataLayer.data);
            osmWriter.writeContent(osmDataLayer.data);
            osmWriter.footer();
            osmWriter.close();
            if (!Main.pref.getBoolean("save.keepbackup") && file2 != null) {
                file2.delete();
            }
            osmDataLayer.onPostSaveToFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", iOException.getMessage()), I18n.tr("Error"), 0);
            try {
                if (file2 != null && file2.exists()) {
                    this.copy(file2, file);
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", iOException2.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }

    private void copy(File file, File file2) throws IOException {
        int n;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not back up file. Exception is: {0}", fileNotFoundException.getMessage()), I18n.tr("Error"), 0);
            return;
        }
        byte[] byArray = new byte[65536];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }
}

