/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward"), new PrefixSuffixSwitcher("forwards", "backwards")};
    private static ArrayList<String> reversibleTags = new ArrayList<String>(Arrays.asList("oneway", "incline"));

    public static boolean isReversible(Way way) {
        for (String string : way.keySet()) {
            if (reversibleTags.contains(string)) {
                return false;
            }
            for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                if (string.equals(prefixSuffixSwitcher.apply(string))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>(list);
        for (Way way : list) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            arrayList.remove(way);
        }
        return arrayList;
    }

    public String invertNumber(String string) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        string2 = string2.equals("-") ? "" : "-";
        return string2 + string3;
    }

    @Override
    public Collection<Command> execute(Way way, Way way2) throws UserCancelException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<TagCorrection> arrayList = new ArrayList<TagCorrection>();
        Object object6 = way2.keySet().iterator();
        while (object6.hasNext()) {
            block14: {
                block12: {
                    block13: {
                        object4 = object5 = object6.next();
                        object2 = object3 = way2.get((String)object5);
                        if (!((String)object5).equals("oneway")) break block12;
                        if (!OsmUtils.isReversed((String)object3)) break block13;
                        object2 = "yes";
                        break block14;
                    }
                    if (!OsmUtils.isTrue((String)object3)) break block14;
                    object2 = "-1";
                    break block14;
                }
                if (((String)object5).equals("incline")) {
                    object = new PrefixSuffixSwitcher("up", "down");
                    object2 = ((PrefixSuffixSwitcher)object).apply((String)object3);
                    if (((String)object2).equals(object3)) {
                        object2 = this.invertNumber((String)object3);
                    }
                } else {
                    Object object7;
                    object = prefixSuffixSwitchers;
                    n = ((PrefixSuffixSwitcher[])object).length;
                    for (int i = 0; i < n && ((String)object5).equals(object4 = ((PrefixSuffixSwitcher)(object7 = object[i])).apply((String)object5)); ++i) {
                    }
                }
            }
            if (((String)object5).equals(object4) && ((String)object3).equals(object2)) continue;
            arrayList.add(new TagCorrection((String)object5, (String)object3, (String)object4, (String)object2));
        }
        if (!arrayList.isEmpty()) {
            hashMap.put(way2, arrayList);
        }
        object6 = new HashMap();
        object5 = new ArrayList();
        object4 = way.getReferrers();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (OsmPrimitive)object3.next();
            if (!(object2 instanceof Relation)) continue;
            object = (Relation)object2;
            n = 0;
            for (RelationMember relationMember : ((Relation)object).getMembers()) {
                if (!relationMember.getMember().hasEqualSemanticAttributes(way) || !relationMember.hasRole()) {
                    ++n;
                    continue;
                }
                boolean bl = false;
                String string = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    string = prefixSuffixSwitcher.apply(relationMember.getRole());
                    if (string.equals(relationMember.getRole())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ((ArrayList)object5).add(new RoleCorrection((Relation)object, n, relationMember, string));
                }
                ++n;
            }
        }
        if (!((ArrayList)object5).isEmpty()) {
            object6.put(way2, object5);
        }
        return this.applyCorrections(hashMap, (Map<OsmPrimitive, List<RoleCorrection>>)object6, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private static final String SEPARATOR = "[:_]?";
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;

        public PrefixSuffixSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.startPattern = Pattern.compile("^(" + string + "|" + string2 + ")(" + SEPARATOR + "|$)", 2);
            this.endPattern = Pattern.compile("^.*[:_]?(" + string + "|" + string2 + ")$", 2);
        }

        public String apply(String string) {
            Matcher matcher = this.startPattern.matcher(string);
            if (!matcher.lookingAt()) {
                matcher = this.endPattern.matcher(string);
            }
            if (matcher.lookingAt()) {
                String string2 = matcher.group(1).toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(1)));
                stringBuilder.append(string2.equals(this.a) ? this.b : this.a);
                stringBuilder.append(string.substring(matcher.end(1)));
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

