/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;

    public final void setCoor(LatLon latLon) {
        if (latLon != null) {
            if (this.coor == null) {
                this.coor = new CachedLatLon(latLon);
            } else {
                this.coor.setCoor(latLon);
            }
            if (this.getDataSet() != null) {
                this.getDataSet().fireNodeMoved(this);
            }
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.coor != null) {
                this.coor.setEastNorth(eastNorth);
            } else {
                this.coor = new CachedLatLon(eastNorth);
            }
            if (this.getDataSet() != null) {
                this.getDataSet().fireNodeMoved(this);
            }
        }
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    protected Node(long l, boolean bl) {
        super(l, bl);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long l) {
        super(l, false);
    }

    public Node(long l, int n) {
        super(l, n, false);
    }

    public Node(Node node, boolean bl) {
        super(node.getUniqueId(), true);
        this.cloneFrom(node);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Node(Node node) {
        this(node, false);
    }

    public Node(LatLon latLon) {
        super(0L, false);
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.setCoor(((Node)osmPrimitive).coor);
    }

    public void mergeFrom(OsmPrimitive osmPrimitive) {
        super.mergeFrom(osmPrimitive);
        if (!osmPrimitive.isIncomplete()) {
            this.setCoor(new LatLon(((Node)osmPrimitive).coor));
        }
    }

    public void load(PrimitiveData primitiveData) {
        super.load(primitiveData);
        this.setCoor(((NodeData)primitiveData).getCoor());
    }

    public NodeData save() {
        NodeData nodeData = new NodeData();
        this.saveCommonAttributes(nodeData);
        if (!this.isIncomplete()) {
            nodeData.setCoor(this.getCoor());
        }
        return nodeData;
    }

    public String toString() {
        String string = this.coor == null ? "" : "lat=" + this.coor.lat() + ",lon=" + this.coor.lon();
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        if (this.coor == null && node.coor == null) {
            return true;
        }
        if (this.coor != null && node.coor != null) {
            return this.coor.equalsEpsilon(node.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : 1;
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public BBox getBBox() {
        if (this.coor == null) {
            return new BBox(0.0, 0.0, 0.0, 0.0);
        }
        return new BBox(this.coor, this.coor);
    }

    public void updatePosition() {
    }
}

