/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive>,
Tagged,
PrimitiveId {
    private static final AtomicLong idCounter;
    private static final int FLAG_MODIFIED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_DISABLED = 4;
    private static final int FLAG_DELETED = 8;
    private static final int FLAG_FILTERED = 16;
    private static final int FLAG_HAS_DIRECTIONS = 32;
    private static final int FLAG_TAGGED = 64;
    private static final int FLAG_DIRECTION_REVERSED = 128;
    public ElemStyle mappaintStyle = null;
    public Integer mappaintDrawnCode = 0;
    private long id = 0L;
    private DataSet dataSet;
    private volatile byte flags = (byte)2;
    private User user = null;
    private boolean incomplete = false;
    private int version = 0;
    private int changesetId;
    public volatile boolean highlighted = false;
    private int timestamp;
    private static volatile Collection<String> uninteresting;
    private static volatile SearchCompiler.Match directionKeys;
    private static volatile SearchCompiler.Match reversedDirectionKeys;
    private String[] keys;
    private Object referrers;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> collection, Class<T> clazz) {
        if (collection == null) {
            return Collections.emptyList();
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!clazz.isInstance(osmPrimitive)) continue;
            linkedList.add(clazz.cast(osmPrimitive));
        }
        return linkedList;
    }

    public static <T extends OsmPrimitive> LinkedHashSet<T> getFilteredSet(Collection<OsmPrimitive> collection, Class<T> clazz) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (collection != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!clazz.isInstance(osmPrimitive)) continue;
                linkedHashSet.add(clazz.cast(osmPrimitive));
            }
        }
        return linkedHashSet;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null || collection.isEmpty()) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(osmPrimitive.getReferrers());
        }
        return hashSet;
    }

    protected void clearCached() {
        this.mappaintDrawnCode = 0;
        this.mappaintStyle = null;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive  must be part of the dataset: " + this.toString());
        }
    }

    protected OsmPrimitive(long l, boolean bl) throws IllegalArgumentException {
        if (bl) {
            this.id = l;
        } else {
            if (l < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", l));
            }
            this.id = l == 0L ? OsmPrimitive.generateUniqueId() : l;
        }
        this.version = 0;
        this.setIncomplete(l > 0L);
    }

    protected OsmPrimitive(long l, int n, boolean bl) throws IllegalArgumentException {
        this(l, bl);
        this.version = l > 0L ? n : 0;
        this.setIncomplete(l > 0L && n == 0);
    }

    public void setDisabled(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public boolean isDisabled() {
        return (this.flags & 4) != 0;
    }

    public void setFiltered(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isFiltered() {
        return (this.flags & 0x10) != 0;
    }

    public void setModified(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isDeleted() {
        return (this.flags & 8) != 0;
    }

    public boolean isUsable() {
        return !this.isDeleted() && !this.isIncomplete() && !this.isDisabled();
    }

    public boolean isDrawable() {
        return !this.isDeleted() && !this.isIncomplete() && !this.isFiltered();
    }

    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    public void setVisible(boolean bl) throws IllegalStateException {
        if (this.isNew() && !bl) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible."));
        }
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public long getVersion() {
        return this.version;
    }

    public long getId() {
        return this.id >= 0L ? this.id : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public void setOsmId(long l, int n) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
        }
        if (this.dataSet != null && l != this.id) {
            DataSet dataSet = this.dataSet;
            dataSet.removePrimitive(this);
            this.id = l;
            dataSet.addPrimitive(this);
        }
        this.id = l;
        this.version = n;
        this.setIncomplete(false);
    }

    public void clearOsmId() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        this.id = OsmPrimitive.generateUniqueId();
        this.version = 0;
        this.changesetId = 0;
        this.setIncomplete(false);
    }

    public void setTimestamp(Date date) {
        this.timestamp = (int)(date.getTime() / 1000L);
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "source_ref", "source:", "note", "comment", "converted_by", "created_by", "watch", "watch:"));
        }
        return uninteresting;
    }

    public static boolean isUninterestingKey(String string) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(string)) {
            return true;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            return uninteresting.contains(string.substring(0, n + 1));
        }
        return false;
    }

    @Deprecated
    public static Collection<String> getDirectionKeys() {
        return Main.pref.getCollection("tags.direction", Arrays.asList("oneway", "incline", "incline_steep", "aerialway"));
    }

    public abstract void visit(Visitor var1);

    public void setDeleted(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
        this.setModified(bl);
        if (this.dataSet != null) {
            if (bl) {
                this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
            } else {
                this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
            }
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(int n) throws IllegalStateException, IllegalArgumentException {
        if (this.changesetId == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", n));
        }
        if (this.isNew() && n > 0) {
            throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", n));
        }
        int n2 = this.changesetId;
        this.changesetId = n;
        if (this.dataSet != null) {
            this.dataSet.fireChangesetIdChanged(this, n2, n);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OsmPrimitive) {
            return ((OsmPrimitive)object).id == this.id && object.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; i += 2) {
                hashMap.put(this.keys[i], this.keys[i + 1]);
            }
        }
        return hashMap;
    }

    @Override
    public void setKeys(Map<String, String> map) {
        Map<String, String> map2 = this.getKeys();
        if (map == null) {
            this.keys = null;
            this.keysChangedImpl(map2);
            return;
        }
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue();
        }
        this.keys = stringArray;
        this.keysChangedImpl(map2);
    }

    @Override
    public final void put(String string, String string2) {
        Map<String, String> map = this.getKeys();
        if (string == null) {
            return;
        }
        if (string2 == null) {
            this.remove(string);
        } else if (this.keys == null || this.keys.length == 0) {
            this.keys = new String[]{string, string2};
            this.keysChangedImpl(map);
        } else {
            for (int i = 0; i < this.keys.length; i += 2) {
                if (!this.keys[i].equals(string)) continue;
                this.keys[i + 1] = string2;
                this.keysChangedImpl(map);
                return;
            }
            String[] stringArray = new String[this.keys.length + 2];
            for (int i = 0; i < this.keys.length; i += 2) {
                stringArray[i] = this.keys[i];
                stringArray[i + 1] = this.keys[i + 1];
            }
            stringArray[this.keys.length] = string;
            stringArray[this.keys.length + 1] = string2;
            this.keys = stringArray;
            this.keysChangedImpl(map);
        }
    }

    @Override
    public final void remove(String string) {
        if (string == null || this.keys == null || this.keys.length == 0) {
            return;
        }
        if (!this.hasKey(string)) {
            return;
        }
        Map<String, String> map = this.getKeys();
        if (this.keys.length == 2) {
            this.keys = null;
            this.keysChangedImpl(map);
            return;
        }
        String[] stringArray = new String[this.keys.length - 2];
        int n = 0;
        for (int i = 0; i < this.keys.length; i += 2) {
            if (this.keys[i].equals(string)) continue;
            stringArray[n++] = this.keys[i];
            stringArray[n++] = this.keys[i + 1];
        }
        this.keys = stringArray;
        this.keysChangedImpl(map);
    }

    @Override
    public final void removeAll() {
        if (this.keys != null) {
            Map<String, String> map = this.getKeys();
            this.keys = null;
            this.keysChangedImpl(map);
        }
    }

    @Override
    public final String get(String string) {
        if (string == null) {
            return null;
        }
        if (this.keys == null || this.keys.length == 0) {
            return null;
        }
        for (int i = 0; i < this.keys.length; i += 2) {
            if (!this.keys[i].equals(string)) continue;
            return this.keys[i + 1];
        }
        return null;
    }

    @Override
    public final Collection<String> keySet() {
        if (this.keys == null || this.keys.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>(this.keys.length / 2);
        for (int i = 0; i < this.keys.length; i += 2) {
            hashSet.add(this.keys[i]);
        }
        return hashSet;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null && this.keys.length != 0;
    }

    private void keysChangedImpl(Map<String, String> map) {
        this.clearCached();
        this.updateDirectionFlags();
        this.updateTagged();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, map);
        }
    }

    public boolean hasKey(String string) {
        if (string == null) {
            return false;
        }
        if (this.keys == null) {
            return false;
        }
        for (int i = 0; i < this.keys.length; i += 2) {
            if (!this.keys[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameTags(OsmPrimitive osmPrimitive) {
        return ((Object)this.getKeys()).equals(osmPrimitive.getKeys());
    }

    protected void addReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers == null) {
            this.referrers = osmPrimitive;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != osmPrimitive) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, osmPrimitive};
            }
        } else {
            for (OsmPrimitive osmPrimitive2 : (OsmPrimitive[])this.referrers) {
                if (osmPrimitive2 != osmPrimitive) continue;
                return;
            }
            OsmPrimitive[] osmPrimitiveArray = (OsmPrimitive[])this.referrers;
            OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[osmPrimitiveArray.length + 1];
            System.arraycopy(osmPrimitiveArray, 0, osmPrimitiveArray2, 0, osmPrimitiveArray.length);
            osmPrimitiveArray2[osmPrimitiveArray.length] = osmPrimitive;
            this.referrers = osmPrimitiveArray2;
        }
    }

    protected void removeReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == osmPrimitive) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] osmPrimitiveArray = (OsmPrimitive[])this.referrers;
            int n = -1;
            for (int i = 0; i < osmPrimitiveArray.length; ++i) {
                if (osmPrimitiveArray[i] != osmPrimitive) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            if (osmPrimitiveArray.length == 2) {
                this.referrers = osmPrimitiveArray[1 - n];
            } else {
                OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[osmPrimitiveArray.length - 1];
                System.arraycopy(osmPrimitiveArray, 0, osmPrimitiveArray2, 0, n);
                System.arraycopy(osmPrimitiveArray, n + 1, osmPrimitiveArray2, n, osmPrimitiveArray2.length - n);
                this.referrers = osmPrimitiveArray2;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers() {
        this.checkDataset();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        if (this.referrers != null) {
            if (this.referrers instanceof OsmPrimitive) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)this.referrers;
                if (osmPrimitive.dataSet == this.dataSet) {
                    arrayList.add(osmPrimitive);
                }
            } else {
                for (OsmPrimitive osmPrimitive : (OsmPrimitive[])this.referrers) {
                    if (this.dataSet != osmPrimitive.dataSet) continue;
                    arrayList.add(osmPrimitive);
                }
            }
        }
        return arrayList;
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        if (this.id != osmPrimitive.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        this.setKeys(osmPrimitive.getKeys());
        this.id = osmPrimitive.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = osmPrimitive.timestamp;
        if (this.id > 0L) {
            this.version = osmPrimitive.version;
        }
        this.setIncomplete(osmPrimitive.isIncomplete());
        this.flags = osmPrimitive.flags;
        this.user = osmPrimitive.user;
        if (this.id > 0L && osmPrimitive.changesetId > 0) {
            this.setChangesetId(osmPrimitive.changesetId);
        }
        this.clearCached();
    }

    public void mergeFrom(OsmPrimitive osmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "other");
        if (osmPrimitive.isNew() ^ this.isNew()) {
            throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not"));
        }
        if (!osmPrimitive.isNew() && osmPrimitive.getId() != this.id) {
            throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, osmPrimitive.getId()));
        }
        this.setKeys(osmPrimitive.getKeys());
        this.timestamp = osmPrimitive.timestamp;
        this.version = osmPrimitive.version;
        this.setIncomplete(osmPrimitive.isIncomplete());
        this.flags = osmPrimitive.flags;
        this.user = osmPrimitive.user;
        this.changesetId = osmPrimitive.changesetId;
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (!this.isNew() && this.id != osmPrimitive.id) {
            return false;
        }
        if (this.isIncomplete() && !osmPrimitive.isIncomplete() || !this.isIncomplete() && osmPrimitive.isIncomplete()) {
            return false;
        }
        return this.hasSameTags(osmPrimitive);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return this.isDeleted() == osmPrimitive.isDeleted() && this.isModified() == osmPrimitive.isModified() && this.timestamp == osmPrimitive.timestamp && this.version == osmPrimitive.version && this.isVisible() == osmPrimitive.isVisible() && (this.user == null ? osmPrimitive.user == null : this.user == osmPrimitive.user) && this.changesetId == osmPrimitive.changesetId;
    }

    private void updateTagged() {
        if (this.keys != null) {
            for (String string : this.keySet()) {
                if (OsmPrimitive.isUninterestingKey(string)) continue;
                this.flags = (byte)(this.flags | 0x40);
                return;
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFFBF);
    }

    public boolean isTagged() {
        return (this.flags & 0x40) != 0;
    }

    private void updateDirectionFlags() {
        boolean bl = false;
        boolean bl2 = false;
        if (reversedDirectionKeys.match(this)) {
            bl = true;
            bl2 = true;
        }
        if (directionKeys.match(this)) {
            bl = true;
        }
        this.flags = bl2 ? (byte)(this.flags | 0x80) : (byte)(this.flags & 0xFFFFFF7F);
        this.flags = bl ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x20) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x80) != 0;
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public String getLocalName() {
        String string = "name:" + Locale.getDefault().toString();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage();
        if (this.get(string) != null) {
            return this.get(string);
        }
        return this.getName();
    }

    public abstract String getDisplayName(NameFormatter var1);

    public void load(PrimitiveData primitiveData) {
        this.setKeys(primitiveData.getKeys());
        this.setTimestamp(primitiveData.getTimestamp());
        this.user = primitiveData.getUser();
        this.setChangesetId(primitiveData.getChangesetId());
        this.setDeleted(primitiveData.isDeleted());
        this.setModified(primitiveData.isModified());
        this.setVisible(primitiveData.isVisible());
        this.setIncomplete(primitiveData.isIncomplete());
        this.version = primitiveData.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData primitiveData) {
        primitiveData.setId(this.id);
        primitiveData.getKeys().clear();
        primitiveData.getKeys().putAll(this.getKeys());
        primitiveData.setTimestamp(this.getTimestamp());
        primitiveData.setUser(this.user);
        primitiveData.setDeleted(this.isDeleted());
        primitiveData.setModified(this.isModified());
        primitiveData.setVisible(this.isVisible());
        primitiveData.setIncomplete(this.isIncomplete());
        primitiveData.setChangesetId(this.changesetId);
        primitiveData.setVersion(this.version);
    }

    protected String getFlagsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isIncomplete()) {
            stringBuilder.append("I");
        }
        if (this.isModified()) {
            stringBuilder.append("M");
        }
        if (this.isVisible()) {
            stringBuilder.append("V");
        }
        if (this.isDeleted()) {
            stringBuilder.append("D");
        }
        if (this.isFiltered()) {
            stringBuilder.append("f");
        }
        if (this.isDisabled()) {
            stringBuilder.append("d");
        }
        if (this.isTagged()) {
            stringBuilder.append("T");
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                stringBuilder.append("<");
            } else {
                stringBuilder.append(">");
            }
        }
        return stringBuilder.toString();
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    private void setIncomplete(boolean bl) {
        if (this.dataSet != null && bl != this.incomplete) {
            if (bl) {
                this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
            } else {
                this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
            }
        }
        this.incomplete = bl;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    static {
        CharSequence charSequence;
        Object object;
        idCounter = new AtomicLong(0L);
        uninteresting = null;
        directionKeys = null;
        reversedDirectionKeys = null;
        if (Main.pref.isCollection("tags.direction", false)) {
            System.out.println("Collection of keys in tags.direction is no longer supported, value will converted to search pattern");
            object = Main.pref.getCollection("tags.direction", null);
            charSequence = new StringBuilder();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ((StringBuilder)charSequence).append(string);
                ((StringBuilder)charSequence).append("=* | ");
            }
            ((StringBuilder)charSequence).delete(((StringBuilder)charSequence).length() - 3, ((StringBuilder)charSequence).length());
            Main.pref.put("tags.direction", ((StringBuilder)charSequence).toString());
        }
        object = "oneway=\"-1\" | incline=down | incline=\"-*\"";
        charSequence = "oneway? | incline=* | aerialway=* | waterway=stream | waterway=river | waterway=canal | waterway=drain | waterway=rapids | \"piste:type\"=downhill | \"piste:type\"=sled | man_made=\"piste:halfpipe\" | junction=roundabout";
        try {
            reversedDirectionKeys = SearchCompiler.compile(Main.pref.get("tags.reversed_direction", (String)object), false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            System.err.println("Unable to compile pattern for tags.reversed_direction, trying default pattern: " + parseError.getMessage());
            try {
                reversedDirectionKeys = SearchCompiler.compile((String)object, false, false);
            }
            catch (SearchCompiler.ParseError parseError2) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + parseError2.getMessage()));
            }
        }
        try {
            directionKeys = SearchCompiler.compile(Main.pref.get("tags.direction", (String)charSequence), false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            System.err.println("Unable to compile pattern for tags.direction, trying default pattern: " + parseError.getMessage());
            try {
                directionKeys = SearchCompiler.compile((String)charSequence, false, false);
            }
            catch (SearchCompiler.ParseError parseError3) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + parseError3.getMessage()));
            }
        }
    }
}

