/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    private static boolean debug = false;
    private static final boolean consistency_testing = false;
    private final Object split_lock = new Object();
    long last_out = -1L;
    public static int NR_LEVELS = 24;
    public static double WORLD_PARTS = 1 << NR_LEVELS;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    private QBLevel root;
    private QBLevel search_cache;

    static void abort(String string) {
        throw new AssertionError((Object)string);
    }

    static void out(String string) {
        System.out.println(string);
    }

    void pout(String string) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L) {
            return;
        }
        this.last_out = l;
        System.out.print(string + "\r");
    }

    void pout(String string, int n, int n2) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L && n + 1 < n2) {
            return;
        }
        this.last_out = l;
        System.out.print(string + " " + (float)((double)(n + 1) * 100.0 / (double)n2) + "% done    \r");
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public void clear() {
        this.root = new QBLevel(null);
        this.search_cache = null;
        if (debug) {
            QuadBuckets.out("QuadBuckets() cleared: " + this);
            QuadBuckets.out("root: " + this.root + " level: " + this.root.level + " bbox: " + this.root.bbox());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        boolean bl;
        if (debug) {
            QuadBuckets.out("QuadBuckets() add: " + t + " size now: " + this.size());
        }
        int n = -1;
        if (!((OsmPrimitive)t).isUsable()) {
            Object object = this.split_lock;
            synchronized (object) {
                bl = this.root.__add_content(t);
            }
        } else {
            bl = this.root.add(t);
        }
        if (debug) {
            QuadBuckets.out("QuadBuckets() add: " + t + " size after: " + this.size());
        }
        return bl;
    }

    public void reindex() {
        QBLevel qBLevel = new QBLevel(null);
        for (OsmPrimitive osmPrimitive : this) {
            qBLevel.add(osmPrimitive);
        }
        this.root = qBLevel;
    }

    public void unsupported() {
        QuadBuckets.out("unsupported operation");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (OsmPrimitive osmPrimitive : this) {
            if (collection.contains(osmPrimitive) || this.remove((T)osmPrimitive)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            bl |= this.add(this.convert(osmPrimitive));
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    private T convert(Object object) {
        return (T)((OsmPrimitive)object);
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(this.convert(object));
    }

    private boolean remove_slow(T t) {
        boolean bl = false;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
            if (osmPrimitive != t) continue;
            iterator.remove();
            bl = true;
            break;
        }
        if (debug) {
            QuadBuckets.out("qb slow remove result: " + bl);
        }
        return bl;
    }

    @Override
    public boolean remove(T t) {
        QBLevel qBLevel = this.root.find_exact(t);
        if (qBLevel == null) {
            return this.remove_slow(t);
        }
        boolean bl = qBLevel.remove_content(t);
        if (debug) {
            QuadBuckets.out("qb remove result: " + bl);
        }
        this.search_cache = null;
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        QBLevel qBLevel = this.root.find_exact(this.convert(object));
        return qBLevel != null;
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this) {
            arrayList.add(osmPrimitive);
        }
        if (debug) {
            QuadBuckets.out("returning array list with size: " + arrayList.size());
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] AArray) {
        return this.toArrayList().toArray(AArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        int n = this.root.size();
        if (debug) {
            QuadBuckets.out(this + " QuadBuckets size: " + n);
        }
        return n;
    }

    public int size_iter() {
        int n = 0;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static BBox search_to_bbox(LatLon latLon, double d) {
        BBox bBox = new BBox(latLon.lon() - d, latLon.lat() - d, latLon.lon() + d, latLon.lat() + d);
        if (debug) {
            QuadBuckets.out("search bbox before sanity: " + bBox);
        }
        if (debug) {
            QuadBuckets.out("search bbox after sanity: " + bBox);
        }
        return bBox;
    }

    List<T> search(Way way) {
        BBox bBox = new BBox(way);
        return this.search(bBox);
    }

    public List<T> search(Node node, double d) {
        return this.search(node.getCoor(), d);
    }

    public List<T> search(LatLon latLon, double d) {
        if (latLon == null) {
            return Collections.emptyList();
        }
        return this.search(QuadBuckets.search_to_bbox(latLon, d));
    }

    public List<T> search(LatLon latLon, LatLon latLon2) {
        BBox bBox = new BBox(latLon.lon(), latLon.lat(), latLon2.lon(), latLon2.lat());
        return this.search(bBox);
    }

    List<T> search(BBox bBox) {
        boolean bl;
        if (debug) {
            QuadBuckets.out("qb root search at " + bBox);
            QuadBuckets.out("root bbox: " + this.root.bbox());
        }
        if (bl = true) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (!this.search_cache.bbox().bounds(bBox)) {
                if (debug) {
                    QuadBuckets.out("bbox: " + bBox);
                }
                if (debug) {
                    QuadBuckets.out("search_cache: " + this.search_cache + " level: " + this.search_cache.level);
                    QuadBuckets.out("search_cache.bbox(): " + this.search_cache.bbox());
                }
                this.search_cache = this.search_cache.parent;
                if (!debug) continue;
                QuadBuckets.out("new search_cache: " + this.search_cache);
            }
        } else {
            this.search_cache = this.root;
        }
        QBLevel qBLevel = this.search_cache.parent;
        ArrayList arrayList = this.search_cache.search(bBox);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        while (qBLevel != null) {
            List list = qBLevel.search_contents(bBox);
            if (list != null) {
                arrayList.addAll(list);
            }
            qBLevel = qBLevel.parent;
        }
        if (debug) {
            QuadBuckets.out("search of QuadBuckets for " + bBox + " ret len: " + arrayList.size());
        }
        return arrayList;
    }

    public void printTree() {
        this.printTreeRecursive(this.root, 0);
    }

    private void printTreeRecursive(QBLevel qBLevel, int n) {
        if (qBLevel == null) {
            this.printIndented(n, "<empty child>");
            return;
        }
        this.printIndented(n, qBLevel);
        if (qBLevel.hasContent()) {
            for (OsmPrimitive osmPrimitive : qBLevel.content) {
                this.printIndented(n, osmPrimitive);
            }
        }
        if (qBLevel.children != null) {
            for (QBLevel qBLevel2 : qBLevel.children) {
                this.printTreeRecursive(qBLevel2, n + 2);
            }
        }
    }

    private void printIndented(int n, Object object) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.println(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel current_node;
        int content_index;
        int iterated_over;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QBLevel next_content_node(QBLevel qBLevel) {
            QBLevel qBLevel2;
            if (qBLevel == null) {
                return null;
            }
            QBLevel qBLevel3 = qBLevel;
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                qBLevel2 = qBLevel.nextContentNode();
            }
            if (qBLevel3 == qBLevel2) {
                QuadBuckets.abort("got same leaf back leaf: " + qBLevel.isLeaf());
            }
            return qBLevel2;
        }

        public QuadBucketIterator(QuadBuckets<T> quadBuckets2) {
            if (debug) {
                QuadBuckets.out(this + " is a new iterator qb: " + quadBuckets2 + " size: " + quadBuckets2.size());
            }
            this.current_node = quadBuckets2.root.isLeaf() || quadBuckets2.root.hasContent() ? quadBuckets2.root : this.next_content_node(quadBuckets2.root);
            if (debug) {
                QuadBuckets.out("\titerator first leaf: " + this.current_node);
            }
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                if (debug) {
                    QuadBuckets.out(this + " no hasNext(), but iterated over so far: " + this.iterated_over);
                }
                return false;
            }
            return true;
        }

        T peek() {
            if (this.current_node == null) {
                if (debug) {
                    QuadBuckets.out("null current leaf, nowhere to go");
                }
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                if (debug) {
                    QuadBuckets.out("moving to next leaf");
                }
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                if (debug) {
                    QuadBuckets.out("late nowhere to go " + this.current_node);
                }
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object t = this.peek();
            ++this.content_index;
            if (debug) {
                QuadBuckets.out("iteration[" + this.iterated_over + "] " + this.content_index + " leaf: " + this.current_node);
            }
            ++this.iterated_over;
            if (t == null && debug) {
                QuadBuckets.out(this + " no next node, but iterated over so far: " + this.iterated_over);
            }
            return t;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object t = this.peek();
            this.current_node.remove_content(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QBLevel {
        int level;
        long quad;
        QBLevel parent;
        public List<T> content;
        public QBLevel[] children;
        double width = Double.NEGATIVE_INFINITY;
        private BBox bbox = null;

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox();
        }

        public QBLevel(QBLevel qBLevel) {
            this.init(qBLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove_content(T t) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                boolean bl = this.content.remove(t);
                if (this.content.size() == 0) {
                    this.content = null;
                }
                if (this.canRemove()) {
                    this.remove_from_parent();
                }
                return bl;
            }
        }

        QBLevel[] newChildren() {
            return (QBLevel[])Array.newInstance(this.getClass(), QuadTiling.TILES_PER_LEVEL);
        }

        int get_index(T t, int n) {
            if (debug) {
                QuadBuckets.out("getting index for " + t + " at level: " + n);
            }
            int n2 = -1;
            for (LatLon latLon : ((OsmPrimitive)t).getBBox().points()) {
                if (debug) {
                    QuadBuckets.out("getting index for point: " + latLon);
                }
                if (n2 == -1) {
                    n2 = QuadTiling.index(latLon, n);
                    if (!debug) continue;
                    QuadBuckets.out("set initial index to: " + n2);
                    continue;
                }
                int n3 = QuadTiling.index(latLon, n);
                if (debug) {
                    QuadBuckets.out("other point index: " + n3);
                }
                if (n3 == n2) continue;
                if (debug) {
                    QuadBuckets.out("primitive (" + ((OsmPrimitive)t).getId() + ") would have gone across two quads " + n3 + "/" + n2 + " at level: " + n + "    ");
                }
                return -1;
            }
            return n2;
        }

        void __split() {
            if (debug) {
                QuadBuckets.out("splitting " + this.bbox() + " level " + this.level + " with " + this.content.size() + " entries (my dimensions: " + this.bbox().width() + ", " + this.bbox().height() + ")");
            }
            List list = this.content;
            this.content = null;
            for (OsmPrimitive osmPrimitive : list) {
                int n = this.get_index(osmPrimitive, this.level);
                if (n == -1) {
                    this.__add_content(osmPrimitive);
                    continue;
                }
                if (this.children == null) {
                    this.children = this.newChildren();
                }
                if (this.children[n] == null) {
                    this.children[n] = new QBLevel(this, n);
                }
                QBLevel qBLevel = this.children[n];
                if (debug) {
                    QuadBuckets.out("putting " + osmPrimitive + "(q:" + Long.toHexString(QuadTiling.quadTile(osmPrimitive.getBBox().points().get(0))) + ") into [" + n + "] " + qBLevel.bbox());
                }
                qBLevel.add(osmPrimitive);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void split() {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                this.__split();
            }
        }

        boolean __add_content(T t) {
            boolean bl = false;
            if (this.content == null) {
                this.content = new ArrayList();
            }
            bl = this.content.add(t);
            if (debug && !this.isLeaf()) {
                QuadBuckets.this.pout("added " + t.getClass().getName() + " to non-leaf with size: " + this.content.size());
            }
            return bl;
        }

        void __add_to_leaf(T t) {
            this.__add_content(t);
            if (this.content.size() > MAX_OBJECTS_PER_LEVEL) {
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] deciding to split");
                }
                if (this.level >= NR_LEVELS - 1) {
                    if (debug) {
                        QuadBuckets.out("can not split, but too deep: " + this.level + " size: " + this.content.size());
                    }
                    return;
                }
                int n = -1;
                this.split();
                return;
            }
        }

        boolean matches(T t, BBox bBox) {
            return ((OsmPrimitive)t).getBBox().intersects(bBox);
        }

        private List<T> search_contents(BBox bBox) {
            if (debug) {
                QuadBuckets.out("searching contents (size: " + this.content == null ? "<null>" : this.content.size() + ") for " + bBox);
            }
            if (this.content == null) {
                return null;
            }
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : this.content) {
                if (!this.matches(osmPrimitive, bBox)) continue;
                linkedList.add(osmPrimitive);
            }
            if (debug) {
                QuadBuckets.out("done searching quad " + Long.toHexString(this.quad));
            }
            return linkedList;
        }

        boolean isLeaf() {
            return this.children == null;
        }

        QBLevel next_sibling() {
            boolean bl = false;
            if (this.parent == null) {
                return null;
            }
            if (this.parent.children == null) {
                return null;
            }
            int n = 0;
            for (QBLevel qBLevel : this.parent.children) {
                int n2 = ++n - 1;
                if (qBLevel == null) {
                    if (!debug) continue;
                    QuadBuckets.out("[" + this.level + "] null child nr: " + n2);
                    continue;
                }
                if (qBLevel == this) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] I was child nr: " + n2);
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] next sibling was child nr: " + n2);
                    }
                    return qBLevel;
                }
                if (!debug) continue;
                QuadBuckets.out("[" + this.level + "] nr: " + n2 + " is before me, ignoring...");
            }
            return null;
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel nextSibling() {
            QBLevel qBLevel = this;
            QBLevel qBLevel2 = qBLevel.next_sibling();
            while (qBLevel2 == null) {
                if (debug) {
                    QuadBuckets.out("no siblings at level[" + qBLevel.level + "], moving to parent");
                }
                if ((qBLevel = qBLevel.parent) == null) break;
                qBLevel2 = qBLevel.next_sibling();
            }
            qBLevel = qBLevel2;
            return qBLevel;
        }

        QBLevel firstChild() {
            QBLevel qBLevel = null;
            for (QBLevel qBLevel2 : this.children) {
                if (qBLevel2 == null) continue;
                qBLevel = qBLevel2;
                break;
            }
            return qBLevel;
        }

        QBLevel nextNode() {
            if (this.isLeaf()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel nextContentNode() {
            QBLevel qBLevel = this.nextNode();
            if (qBLevel == null) {
                return qBLevel;
            }
            if (qBLevel.hasContent()) {
                return qBLevel;
            }
            return qBLevel.nextContentNode();
        }

        int size() {
            if (this.isLeaf()) {
                return this.size_leaf();
            }
            return this.size_branch();
        }

        private int size_leaf() {
            if (this.content == null) {
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] leaf size: null content, children? " + Arrays.toString(this.children));
                }
                return 0;
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] leaf size: " + this.content.size());
            }
            return this.content.size();
        }

        private int size_branch() {
            int n = 0;
            for (QBLevel qBLevel : this.children) {
                if (qBLevel == null) continue;
                n += qBLevel.size();
            }
            if (this.content != null) {
                n += this.content.size();
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] branch size: " + n);
            }
            return n;
        }

        boolean contains(T t) {
            QBLevel qBLevel = this.find_exact(t);
            return qBLevel != null;
        }

        QBLevel find_exact(T t) {
            if (this.content != null && this.content.contains(t)) {
                return this;
            }
            return this.find_exact_child(t);
        }

        private QBLevel find_exact_child(T t) {
            QBLevel qBLevel = null;
            if (this.children == null) {
                return qBLevel;
            }
            for (QBLevel qBLevel2 : this.children) {
                if (qBLevel2 != null && (qBLevel = qBLevel2.find_exact(t)) != null) break;
            }
            return qBLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(T t) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                if (this.isLeaf()) {
                    this.__add_to_leaf(t);
                } else {
                    this.__add_to_branch(t);
                }
            }
            return true;
        }

        QBLevel __add_to_branch(T t) {
            int n = this.get_index(t, this.level);
            if (n == -1) {
                if (debug) {
                    QuadBuckets.out("unable to get index for " + t + "at level: " + this.level + ", adding content to branch: " + this);
                }
                this.__add_content(t);
                return this;
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "]: " + t + " index " + n + " levelquad:" + this.quads() + " level bbox:" + this.bbox());
                QuadBuckets.out("   put in child[" + n + "]");
            }
            if (this.children[n] == null) {
                this.children[n] = new QBLevel(this, n);
            }
            this.children[n].add(t);
            return this;
        }

        private List<T> search(BBox bBox) {
            List list = null;
            if (debug) {
                System.out.print("[" + this.level + "] qb bbox: " + this.bbox() + " ");
            }
            if (!this.bbox().intersects(bBox)) {
                if (debug) {
                    QuadBuckets.out("miss " + Long.toHexString(this.quad));
                }
                return list;
            }
            if (this.hasContent()) {
                list = this.search_contents(bBox);
            }
            if (this.isLeaf()) {
                return list;
            }
            if (debug) {
                QuadBuckets.out("hit " + this.quads());
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] not leaf, moving down");
            }
            for (int i = 0; i < this.children.length; ++i) {
                List list2;
                QBLevel qBLevel = this.children[i];
                if (debug) {
                    QuadBuckets.out("child[" + i + "]: " + qBLevel);
                }
                if (qBLevel == null) continue;
                if (debug) {
                    System.out.print(i + ": ");
                }
                if ((list2 = qBLevel.search(bBox)) == null) continue;
                if (list == null) {
                    list = list2;
                } else {
                    list.addAll(list2);
                }
                if (!qBLevel.bbox().bounds(bBox)) continue;
                QuadBuckets.this.search_cache = qBLevel;
                if (list2.size() <= 0) continue;
                if (!debug) break;
                QuadBuckets.out("break early");
                break;
            }
            return list;
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        public void init(QBLevel qBLevel) {
            this.parent = qBLevel;
            this.level = qBLevel == null ? 0 : qBLevel.level + 1;
            this.quad = 0L;
        }

        int index_of(QBLevel qBLevel) {
            if (this.isLeaf()) {
                return -1;
            }
            for (int i = 0; i < QuadTiling.TILES_PER_LEVEL; ++i) {
                if (this.children[i] != qBLevel) continue;
                return i;
            }
            return -1;
        }

        public QBLevel(QBLevel qBLevel, int n) {
            this.init(qBLevel);
            int n2 = (NR_LEVELS - this.level) * 2;
            long l = 1L;
            if (n2 >= 30) {
                n2 -= 30;
                l = 0x40000000L;
            }
            long l2 = l * (long)(n << n2);
            this.quad = qBLevel.quad | l2;
            if (debug) {
                QuadBuckets.out("new level[" + this.level + "] bbox[" + n + "]: " + this.bbox() + " coor: " + this.coor() + " quadpart: " + Long.toHexString(l2) + " quad: " + Long.toHexString(this.quad));
            }
        }

        double width() {
            if (this.width != Double.NEGATIVE_INFINITY) {
                return this.width;
            }
            this.width = this.level == 0 ? this.bbox().width() : this.parent.width() / 2.0;
            return this.width;
        }

        double height() {
            return this.width() / 2.0;
        }

        public BBox bbox() {
            if (this.bbox != null) {
                return this.bbox;
            }
            if (this.level == 0) {
                this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
            } else {
                LatLon latLon = this.coor();
                double d = latLon.lat() + this.height();
                double d2 = latLon.lon() + this.width();
                LatLon latLon2 = new LatLon(d, d2);
                this.bbox = new BBox(latLon, latLon2);
            }
            return this.bbox;
        }

        LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }

        boolean hasChildren() {
            if (this.children == null) {
                return false;
            }
            for (QBLevel qBLevel : this.children) {
                if (qBLevel == null) continue;
                return true;
            }
            return false;
        }

        void remove_from_parent() {
            if (this.parent == null) {
                return;
            }
            int n = 0;
            for (int i = 0; i < this.parent.children.length; ++i) {
                QBLevel qBLevel = this.parent.children[i];
                if (qBLevel != null) {
                    ++n;
                }
                if (qBLevel != this) continue;
                if (!this.canRemove()) {
                    QuadBuckets.abort("attempt to remove non-empty child: " + this.content + " " + Arrays.toString(this.children));
                }
                this.parent.children[i] = null;
                --n;
            }
            if (n == 0) {
                this.parent.children = null;
            }
            if (this.parent.canRemove()) {
                this.parent.remove_from_parent();
            }
        }

        boolean canRemove() {
            if (this.content != null && this.content.size() > 0) {
                return false;
            }
            return !this.hasChildren();
        }
    }
}

