/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetInSelectionListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListCellRenderer;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetsInActiveDataLayerListModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ChangesetDialog
extends ToggleDialog {
    private ChangesetInSelectionListModel inSelectionModel;
    private ChangesetsInActiveDataLayerListModel inActiveDataLayerModel;
    private JList lstInSelection;
    private JList lstInActiveDataLayer;
    private JCheckBox cbInSelectionOnly;
    private JPanel pnlList;
    private SelectObjectsAction selectObjectsAction;
    private ReadChangesetsAction readChangesetAction;
    private ShowChangesetInfoAction showChangesetInfoAction;
    private CloseOpenChangesetsAction closeChangesetAction;
    private LaunchChangesetManagerAction launchChangesetManagerAction;

    protected void buildChangesetsLists() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.inSelectionModel = new ChangesetInSelectionListModel(defaultListSelectionModel);
        this.lstInSelection = new JList(this.inSelectionModel);
        this.lstInSelection.setSelectionModel(defaultListSelectionModel);
        this.lstInSelection.setSelectionMode(2);
        this.lstInSelection.setCellRenderer(new ChangesetListCellRenderer());
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.inActiveDataLayerModel = new ChangesetsInActiveDataLayerListModel(defaultListSelectionModel);
        this.lstInActiveDataLayer = new JList(this.inActiveDataLayerModel);
        this.lstInActiveDataLayer.setSelectionModel(defaultListSelectionModel);
        this.lstInActiveDataLayer.setSelectionMode(2);
        this.lstInActiveDataLayer.setCellRenderer(new ChangesetListCellRenderer());
        DblClickHandler dblClickHandler = new DblClickHandler();
        this.lstInSelection.addMouseListener(dblClickHandler);
        this.lstInActiveDataLayer.addMouseListener(dblClickHandler);
        ChangesetPopupMenuLauncher changesetPopupMenuLauncher = new ChangesetPopupMenuLauncher();
        this.lstInSelection.addMouseListener(changesetPopupMenuLauncher);
        this.lstInActiveDataLayer.addMouseListener(changesetPopupMenuLauncher);
    }

    protected void registerAsListener() {
        ChangesetCache.getInstance().addChangesetCacheListener(this.inSelectionModel);
        MapView.addEditLayerChangeListener(this.inSelectionModel);
        DataSet.selListeners.add(this.inSelectionModel);
        ChangesetCache.getInstance().addChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.addEditLayerChangeListener(this.inActiveDataLayerModel);
        if (Main.main.getEditLayer() != null) {
            Main.main.getEditLayer().data.addDataSetListener(this.inActiveDataLayerModel);
            this.inActiveDataLayerModel.initFromDataSet(Main.main.getEditLayer().data);
            this.inSelectionModel.initFromPrimitives(Main.main.getEditLayer().data.getSelected());
        }
    }

    protected void unregisterAsListener() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.removeEditLayerChangeListener(this.inActiveDataLayerModel);
        if (Main.main.getEditLayer() != null) {
            Main.main.getEditLayer().data.removeDataSetListener(this.inActiveDataLayerModel);
        }
        MapView.removeEditLayerChangeListener(this.inSelectionModel);
        DataSet.selListeners.remove(this.inSelectionModel);
    }

    public void showNotify() {
        this.registerAsListener();
        DatasetEventManager.getInstance().addDatasetListener(this.inActiveDataLayerModel, DatasetEventManager.FireMode.IN_EDT);
    }

    public void hideNotify() {
        this.unregisterAsListener();
        DatasetEventManager.getInstance().removeDatasetListener(this.inActiveDataLayerModel);
    }

    protected JPanel buildFilterPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(null);
        this.cbInSelectionOnly = new JCheckBox(I18n.tr("For selected objects only"));
        jPanel.add(this.cbInSelectionOnly);
        this.cbInSelectionOnly.setToolTipText(I18n.tr("<html>Select to show changesets for the currently selected objects only.<br>Unselect to show all changesets for objects in the current data layer.</html>"));
        this.cbInSelectionOnly.setSelected(Main.pref.getBoolean("changeset-dialog.for-selected-objects-only", false));
        return jPanel;
    }

    protected JPanel buildListPanel() {
        this.buildChangesetsLists();
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.cbInSelectionOnly.isSelected()) {
            jPanel.add(new JScrollPane(this.lstInSelection));
        } else {
            jPanel.add(new JScrollPane(this.lstInActiveDataLayer));
        }
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = this.getButtonPanel(5);
        this.selectObjectsAction = new SelectObjectsAction();
        jPanel.add(new SideButton((Action)this.selectObjectsAction, false));
        this.cbInSelectionOnly.addItemListener(this.selectObjectsAction);
        this.lstInActiveDataLayer.getSelectionModel().addListSelectionListener(this.selectObjectsAction);
        this.lstInSelection.getSelectionModel().addListSelectionListener(this.selectObjectsAction);
        this.readChangesetAction = new ReadChangesetsAction();
        jPanel.add(new SideButton((Action)this.readChangesetAction, false));
        this.cbInSelectionOnly.addItemListener(this.readChangesetAction);
        this.lstInActiveDataLayer.getSelectionModel().addListSelectionListener(this.readChangesetAction);
        this.lstInSelection.getSelectionModel().addListSelectionListener(this.readChangesetAction);
        this.closeChangesetAction = new CloseOpenChangesetsAction();
        jPanel.add(new SideButton((Action)this.closeChangesetAction, false));
        this.cbInSelectionOnly.addItemListener(this.closeChangesetAction);
        this.lstInActiveDataLayer.getSelectionModel().addListSelectionListener(this.closeChangesetAction);
        this.lstInSelection.getSelectionModel().addListSelectionListener(this.closeChangesetAction);
        this.showChangesetInfoAction = new ShowChangesetInfoAction();
        jPanel.add(new SideButton((Action)this.showChangesetInfoAction, false));
        this.cbInSelectionOnly.addItemListener(this.showChangesetInfoAction);
        this.lstInActiveDataLayer.getSelectionModel().addListSelectionListener(this.showChangesetInfoAction);
        this.lstInSelection.getSelectionModel().addListSelectionListener(this.showChangesetInfoAction);
        this.launchChangesetManagerAction = new LaunchChangesetManagerAction();
        jPanel.add(new SideButton((Action)this.launchChangesetManagerAction, false));
        this.cbInSelectionOnly.addItemListener(this.launchChangesetManagerAction);
        this.lstInActiveDataLayer.getSelectionModel().addListSelectionListener(this.launchChangesetManagerAction);
        this.lstInSelection.getSelectionModel().addListSelectionListener(this.launchChangesetManagerAction);
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildFilterPanel(), "North");
        this.pnlList = this.buildListPanel();
        jPanel.add((Component)this.pnlList, "Center");
        jPanel.add((Component)this.buildButtonPanel(), "South");
        this.add((Component)jPanel, "Center");
        this.cbInSelectionOnly.addItemListener(new FilterChangeHandler());
        HelpUtil.setHelpContext(jPanel, HelpUtil.ht("/Dialog/ChangesetListDialog"));
    }

    protected JList getCurrentChangesetList() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.lstInSelection;
        }
        return this.lstInActiveDataLayer;
    }

    protected ChangesetListModel getCurrentChangesetListModel() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.inSelectionModel;
        }
        return this.inActiveDataLayerModel;
    }

    protected void initWithCurrentData() {
        if (Main.main.getEditLayer() != null) {
            this.inSelectionModel.initFromPrimitives(Main.main.getEditLayer().data.getSelected());
            this.inActiveDataLayerModel.initFromDataSet(Main.main.getEditLayer().data);
        }
    }

    public ChangesetDialog(MapFrame mapFrame) {
        super(I18n.tr("Changesets"), "changesetdialog", I18n.tr("Open the list of changesets in the current layer."), null, 200, false);
        this.build();
        this.initWithCurrentData();
    }

    class ChangesetDialogPopup
    extends JPopupMenu {
        public ChangesetDialogPopup() {
            this.add(ChangesetDialog.this.selectObjectsAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.readChangesetAction);
            this.add(ChangesetDialog.this.closeChangesetAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.showChangesetInfoAction);
        }
    }

    class ChangesetPopupMenuLauncher
    extends PopupMenuLauncher {
        ChangesetPopupMenuLauncher() {
        }

        public void launch(MouseEvent mouseEvent) {
            int n;
            JList jList = ChangesetDialog.this.getCurrentChangesetList();
            if (jList.getSelectedIndices().length == 0 && (n = jList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                jList.getSelectionModel().addSelectionInterval(n, n);
            }
            ChangesetDialogPopup changesetDialogPopup = new ChangesetDialogPopup();
            changesetDialogPopup.show(jList, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LaunchChangesetManagerAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public LaunchChangesetManagerAction() {
            this.putValue("Name", I18n.tr("Details"));
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "changesetmanager"));
            this.updateEnabledState();
        }

        protected void launchChangesetManager(Collection<Integer> collection) {
            ChangesetCacheManager changesetCacheManager = ChangesetCacheManager.getInstance();
            if (changesetCacheManager.isVisible()) {
                changesetCacheManager.setExtendedState(0);
                changesetCacheManager.toFront();
                changesetCacheManager.requestFocus();
            } else {
                changesetCacheManager.setVisible(true);
                changesetCacheManager.toFront();
                changesetCacheManager.requestFocus();
            }
            changesetCacheManager.setSelectedChangesetsById(collection);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Future<?> future;
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            ChangesetCache changesetCache = ChangesetCache.getInstance();
            Object object = set.iterator();
            while (object.hasNext()) {
                int n = object.next();
                if (changesetCache.contains(n)) continue;
                hashSet.add(n);
            }
            if (hashSet.isEmpty()) {
                object = null;
                future = null;
            } else {
                object = new ChangesetHeaderDownloadTask(hashSet);
                future = Main.worker.submit((Runnable)object);
            }
            Runnable runnable = new Runnable((ChangesetHeaderDownloadTask)object, hashSet){
                final /* synthetic */ ChangesetHeaderDownloadTask val$task;
                final /* synthetic */ Set val$toDownload;
                {
                    this.val$task = changesetHeaderDownloadTask;
                    this.val$toDownload = set;
                }

                public void run() {
                    if (future != null) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (ExecutionException executionException) {
                            executionException.printStackTrace();
                            BugReportExceptionHandler.handleException(executionException.getCause());
                            return;
                        }
                    }
                    if (this.val$task != null) {
                        if (this.val$task.isCanceled()) {
                            return;
                        }
                        if (this.val$task.isFailed()) {
                            this.val$toDownload.clear();
                        }
                    }
                    LaunchChangesetManagerAction.this.launchChangesetManager(this.val$toDownload);
                }
            };
            Main.worker.submit(runnable);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ShowChangesetInfoAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public ShowChangesetInfoAction() {
            this.putValue("Name", I18n.tr("Show info"));
            this.putValue("ShortDescription", I18n.tr("Open a web page for each selected changeset"));
            this.putValue("SmallIcon", ImageProvider.get("about"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set<Changeset> set = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesets();
            if (set.isEmpty()) {
                return;
            }
            if (set.size() > 10 && !AbstractInfoAction.confirmLaunchMultiple(set.size())) {
                return;
            }
            String string = AbstractInfoAction.getBaseBrowseUrl();
            for (Changeset changeset : set) {
                String string2 = string + "/changeset/" + changeset.getId();
                OpenBrowser.displayUrl(string2);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class CloseOpenChangesetsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public CloseOpenChangesetsAction() {
            this.putValue("Name", I18n.tr("Close open changesets"));
            this.putValue("ShortDescription", I18n.tr("Closes the selected open changesets"));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<Changeset> list = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedOpenChangesets();
            if (list.isEmpty()) {
                return;
            }
            Main.worker.submit(new CloseChangesetTask(list));
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetListModel().hasSelectedOpenChangesets());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ReadChangesetsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public ReadChangesetsAction() {
            this.putValue("Name", I18n.tr("Download"));
            this.putValue("ShortDescription", I18n.tr("Download information about the selected changesets from the OSM server"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = new ChangesetHeaderDownloadTask(set);
            Main.worker.submit(changesetHeaderDownloadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectObjectsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public SelectObjectsAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Select all objects assigned to the currently selected changesets"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void selectObjectsByChangesetIds(DataSet dataSet, Set<Integer> set) {
            if (dataSet == null || set == null) {
                return;
            }
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (Node osmPrimitive : dataSet.getNodes()) {
                if (!set.contains(osmPrimitive.getChangesetId())) continue;
                hashSet.add(osmPrimitive);
            }
            for (Way way : dataSet.getWays()) {
                if (!set.contains(way.getChangesetId())) continue;
                hashSet.add(way);
            }
            for (Relation relation : dataSet.getRelations()) {
                if (!set.contains(relation.getChangesetId())) continue;
                hashSet.add(relation);
            }
            dataSet.setSelected(hashSet);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            DataSet dataSet = Main.main.getEditLayer().data;
            this.selectObjectsByChangesetIds(dataSet, set);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class FilterChangeHandler
    implements ItemListener {
        FilterChangeHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Main.pref.put("changeset-dialog.for-selected-objects-only", ChangesetDialog.this.cbInSelectionOnly.isSelected());
            ChangesetDialog.this.pnlList.removeAll();
            if (ChangesetDialog.this.cbInSelectionOnly.isSelected()) {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInSelection), "Center");
            } else {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInActiveDataLayer), "Center");
            }
            ChangesetDialog.this.validate();
            ChangesetDialog.this.repaint();
        }
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() < 2) {
                return;
            }
            Set<Integer> set = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            new SelectObjectsAction().selectObjectsByChangesetIds(Main.main.getCurrentDataSet(), set);
        }
    }
}

