/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

class SaveLayerInfoCellRenderer
implements TableCellRenderer {
    private JLabel lblRenderer = new JLabel();
    private JCheckBox cbRenderer = new JCheckBox();

    protected Component prepareLayerNameRenderer(SaveLayerInfo saveLayerInfo) {
        this.lblRenderer.setIcon(saveLayerInfo.getLayer().getIcon());
        this.lblRenderer.setText(saveLayerInfo.getName());
        this.lblRenderer.setToolTipText(saveLayerInfo.getLayer().getToolTipText());
        return this.lblRenderer;
    }

    protected Component prepareUploadRequiredRenderer(SaveLayerInfo saveLayerInfo) {
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setHorizontalAlignment(0);
        String string = saveLayerInfo.getLayer().requiresUploadToServer() ? I18n.tr("Yes") : I18n.tr("No");
        this.lblRenderer.setText(string);
        if (saveLayerInfo.getLayer().requiresUploadToServer()) {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has modifications which should be uploaded to the server.", saveLayerInfo.getName()));
        } else {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has no modifications to be uploaded.", saveLayerInfo.getName()));
        }
        return this.lblRenderer;
    }

    protected Component prepareSaveToFileRequired(SaveLayerInfo saveLayerInfo) {
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setHorizontalAlignment(0);
        String string = saveLayerInfo.getLayer().requiresSaveToFile() ? I18n.tr("Yes") : I18n.tr("No");
        this.lblRenderer.setText(string);
        if (saveLayerInfo.getLayer().requiresSaveToFile()) {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has modifications which should be saved to its associated file ''{1}''.", saveLayerInfo.getName(), saveLayerInfo.getFile().toString()));
        } else {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has no modifications to be saved.", saveLayerInfo.getName()));
        }
        return this.lblRenderer;
    }

    protected boolean canWrite(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file.exists() && file.canWrite()) {
            return true;
        }
        return !file.exists() && file.getParentFile() != null && file.getParentFile().canWrite();
    }

    protected Component prepareFileNameRenderer(SaveLayerInfo saveLayerInfo) {
        this.lblRenderer.setIcon(null);
        if (saveLayerInfo.getFile() == null) {
            if (!saveLayerInfo.isDoSaveToFile()) {
                this.lblRenderer.setText(I18n.tr("No file associated with this layer"));
            } else {
                this.lblRenderer.setBackground(new Color(255, 197, 197));
                this.lblRenderer.setText(I18n.tr("Please select a file"));
            }
            this.lblRenderer.setFont(this.lblRenderer.getFont().deriveFont(2));
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' is not backed by a file", saveLayerInfo.getName()));
        } else {
            String string = saveLayerInfo.getFile().getName();
            String string2 = saveLayerInfo.getFile().getParent();
            if (string2 != null) {
                string = string2.length() <= 10 ? saveLayerInfo.getFile().getPath() : string2.substring(0, 10) + "..." + File.separator + string;
            }
            this.lblRenderer.setText(string);
            this.lblRenderer.setToolTipText(saveLayerInfo.getFile().getAbsolutePath());
            if (saveLayerInfo.isDoSaveToFile() && !this.canWrite(saveLayerInfo.getFile())) {
                this.lblRenderer.setBackground(new Color(255, 197, 197));
                this.lblRenderer.setToolTipText(I18n.tr("File ''{0}'' is not writable. Please enter another file name.", saveLayerInfo.getFile().getPath()));
            }
        }
        return this.lblRenderer;
    }

    protected Component prepareUploadRenderer(SaveLayerInfo saveLayerInfo) {
        this.cbRenderer.setSelected(saveLayerInfo.isDoUploadToServer());
        this.lblRenderer.setToolTipText(I18n.tr("Select to upload layer ''{0}'' to the server ''{1}''", saveLayerInfo.getName(), OsmApi.getOsmApi().getBaseUrl()));
        return this.cbRenderer;
    }

    protected Component prepareSaveToFileRenderer(SaveLayerInfo saveLayerInfo) {
        this.cbRenderer.setSelected(saveLayerInfo.isDoSaveToFile());
        this.lblRenderer.setToolTipText(I18n.tr("Select to upload layer ''{0}'' to the server ''{1}''", saveLayerInfo.getName(), OsmApi.getOsmApi().getBaseUrl()));
        return this.cbRenderer;
    }

    protected void resetRenderers() {
        this.lblRenderer.setOpaque(true);
        this.lblRenderer.setBackground(UIManager.getColor("Table.background"));
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setText("");
        this.lblRenderer.setFont(UIManager.getFont("Table.font"));
        this.lblRenderer.setHorizontalAlignment(2);
        this.cbRenderer.setSelected(false);
        this.cbRenderer.setOpaque(true);
        this.cbRenderer.setBackground(UIManager.getColor("Table.background"));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.resetRenderers();
        SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
        switch (n2) {
            case 0: {
                return this.prepareLayerNameRenderer(saveLayerInfo);
            }
            case 1: {
                return this.prepareUploadRequiredRenderer(saveLayerInfo);
            }
            case 2: {
                return this.prepareSaveToFileRequired(saveLayerInfo);
            }
            case 3: {
                return this.prepareFileNameRenderer(saveLayerInfo);
            }
            case 4: {
                return this.prepareUploadRenderer(saveLayerInfo);
            }
            case 5: {
                return this.prepareSaveToFileRenderer(saveLayerInfo);
            }
        }
        return null;
    }
}

