/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagTable
extends JTable {
    private static final Logger logger = Logger.getLogger(TagTable.class.getName());
    private TagCellEditor editor = null;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private CellEditorRemover editorRemover;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    protected void init() {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.setTagCellEditor(new TagCellEditor());
    }

    public TagTable(TableModel tableModel, DefaultListSelectionModel defaultListSelectionModel, DefaultListSelectionModel defaultListSelectionModel2) {
        super(tableModel, new TagTableColumnModel(defaultListSelectionModel2), defaultListSelectionModel);
        this.init();
    }

    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionCache(AutoCompletionCache autoCompletionCache) {
        if (autoCompletionCache == null) {
            logger.warning("argument acCache should not be null. Aborting.");
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionCache(autoCompletionCache);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener keyListener) {
        this.addKeyListener(keyListener);
        if (this.editor == null) {
            logger.warning("editor is null. cannot register OK accelator listener.");
        } else {
            this.editor.getEditor().addKeyListener(keyListener);
        }
    }

    public void setTagCellEditor(TagCellEditor tagCellEditor) {
        if (this.isEditing()) {
            this.editor.cancelCellEditing();
        }
        this.editor = tagCellEditor;
        this.getColumnModel().getColumn(0).setCellEditor(tagCellEditor);
        this.getColumnModel().getColumn(1).setCellEditor(tagCellEditor);
    }

    public void requestFocusInCell(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        SwingUtilities.convertPointToScreen(point, this);
        Point point2 = MouseInfo.getPointerInfo().getLocation();
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.x, point.y);
            robot.mousePress(16);
            robot.mouseRelease(16);
            robot.mouseMove(point2.x, point2.y);
        }
        catch (AWTException aWTException) {
            logger.log(Level.SEVERE, "failed to simulate mouse click event at (" + rectangle.x + "," + rectangle.y + "). Exception: " + aWTException.toString());
            return;
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(n, n2, eventObject);
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(component)) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class AddAction
    extends RunnableAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag"));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        public void run() {
            TableCellEditor tableCellEditor = TagTable.this.getCellEditor();
            if (tableCellEditor != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            ((TagEditorModel)TagTable.this.getModel()).appendNewTag();
            int n = TagTable.this.getModel().getRowCount() - 1;
            TagTable.this.requestFocusInCell(n, 0);
        }

        protected void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table"));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTagNames(nArray);
        }

        protected void deleteTagValues() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTagValues(nArray);
        }

        protected void deleteTags() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTags(nArray);
        }

        public void run() {
            Object object;
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                }
            }
            if (TagTable.this.isEditing() && (object = TagTable.this.getCellEditor()) != null) {
                object.cancelCellEditing();
            }
            if (((TagEditorModel)(object = (TagEditorModel)TagTable.this.getModel())).getRowCount() == 0) {
                ((TagEditorModel)object).ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n > 0 || n2 > 0) {
                if (n == 1) {
                    --n;
                } else {
                    n = 1;
                    --n2;
                }
            }
            TagTable.this.changeSelection(n2, n, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 0) {
                ++n;
            } else if (n == 1 && n2 < TagTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            } else if (n == 1 && n2 == TagTable.this.getRowCount() - 1) {
                TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
                tagEditorModel.appendNewTag();
                n = 0;
                ++n2;
            }
            TagTable.this.changeSelection(n2, n, false, false);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.setSelectionModel(defaultListSelectionModel);
            TableColumn tableColumn = null;
            TagCellRenderer tagCellRenderer = new TagCellRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Key"));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("Value"));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
        }
    }
}

