/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public abstract class OsmServerReader
extends OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmServerReader.class.getName());
    private OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            string = this.api.getBaseUrl() + string;
            InputStream inputStream = this.getInputStreamRaw(string, progressMonitor);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            URL uRL = null;
            try {
                uRL = new URL(string.replace(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new OsmTransferException(malformedURLException);
            }
            try {
                this.activeConnection = (HttpURLConnection)uRL.openConnection();
            }
            catch (Exception exception) {
                throw new OsmTransferException(I18n.tr("Failed to open connection to API {0}.", uRL.toExternalForm()), exception);
            }
            if (this.cancel) {
                this.activeConnection.disconnect();
                InputStream inputStream = null;
                return inputStream;
            }
            if (this.doAuthenticate) {
                this.addAuth(this.activeConnection);
            }
            if (this.cancel) {
                throw new OsmTransferCancelledException();
            }
            if (Main.pref.getBoolean("osm-server.use-compression", true)) {
                this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            this.activeConnection.setConnectTimeout(15000);
            try {
                System.out.println("GET " + uRL);
                this.activeConnection.connect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection."), exception);
            }
            try {
                if (this.activeConnection.getResponseCode() == 401) {
                    throw new OsmApiException(401, null, null);
                }
                if (this.activeConnection.getResponseCode() == 407) {
                    throw new OsmTransferCancelledException();
                }
                if (this.activeConnection.getResponseCode() != 200) {
                    String string2 = this.activeConnection.getHeaderField("Error");
                    InputStream inputStream = null;
                    inputStream = this.activeConnection.getErrorStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (inputStream != null) {
                        String string3;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((string3 = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string3);
                            stringBuilder.append("\n");
                        }
                    }
                    throw new OsmApiException(this.activeConnection.getResponseCode(), string2, stringBuilder.toString());
                }
                String string4 = this.activeConnection.getContentEncoding();
                InputStream inputStream = new ProgressInputStream(this.activeConnection, progressMonitor);
                if (string4 != null && string4.equalsIgnoreCase("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                } else if (string4 != null && string4.equalsIgnoreCase("deflate")) {
                    inputStream = new InflaterInputStream(inputStream, new Inflater(true));
                }
                ProgressInputStream progressInputStream = inputStream;
                return progressInputStream;
            }
            catch (Exception exception) {
                if (exception instanceof OsmTransferException) {
                    throw (OsmTransferException)exception;
                }
                throw new OsmTransferException(exception);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean bl) {
        this.doAuthenticate = bl;
    }
}

