/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void uncaughtException(Thread thread, Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    public static void handleException(Throwable throwable) {
        throwable.printStackTrace();
        if (Main.parent != null) {
            if (throwable instanceof OutOfMemoryError) {
                JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                return;
            }
            PluginHandler.disablePluginAfterException(throwable);
            Object[] objectArray = new String[]{I18n.tr("Do nothing"), I18n.tr("Report Bug")};
            int n = JOptionPane.showOptionDialog(Main.parent, "<html>" + I18n.tr("An unexpected exception occurred.<br>This is always a coding error. If you are running the latest<br>version of JOSM, please consider being kind and file a bug report.") + "</html>", I18n.tr("Unexpected Exception"), 0, 0, null, objectArray, objectArray[0]);
            if (n != 1) {
                return;
            }
            try {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                String string = ShowStatusReportAction.getReportHeader() + stringWriter.getBuffer().toString();
                String string2 = string.replaceAll("\r", "");
                if (string2.length() > 7000) {
                    int n2 = (string2 = string2.substring(0, 7000)).lastIndexOf("\n");
                    if (7000 - n2 < 200) {
                        string2 = string2.substring(0, n2 + 1);
                    }
                    string2 = string2 + "...<snip>...\n";
                }
                URL uRL = new URL("http://josm.openstreetmap.de/josmticket?data=" + Base64.encode("keywords=template_report&description=" + URLEncoder.encode("What steps will reproduce the problem?\n 1. \n 2. \n 3. \n\nWhat is the expected result?\n\nWhat happens instead?\n\nPlease provide any additional information below. Attach a screenshot if\npossible.\n\n{{{\n" + string2 + "\n}}}\n", "UTF-8")));
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)new JMultilineLabel(I18n.tr("You have encountered an error in JOSM. Before you file a bug report make sure you have updated to the latest version of JOSM here:")), GBC.eol());
                jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de/#Download"), GBC.eop().insets(8, 0, 0, 0));
                jPanel.add((Component)new JMultilineLabel(I18n.tr("You should also update your plugins. If neither of those help please file a bug report in our bugtracker using this link:")), GBC.eol());
                jPanel.add((Component)new UrlLabel(uRL.toString(), "http://josm.openstreetmap.de/josmticket?..."), GBC.eop().insets(8, 0, 0, 0));
                jPanel.add((Component)new JMultilineLabel(I18n.tr("There the error information provided below should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.")), GBC.eop());
                jPanel.add((Component)new JMultilineLabel(I18n.tr("Alternatively, if that does not work you can manually fill in the information below at this URL:")), GBC.eol());
                jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eop().insets(8, 0, 0, 0));
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), new ClipboardOwner(){

                        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                        }
                    });
                    jPanel.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)")), GBC.eop());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                JTextArea jTextArea = new JTextArea(string, 20, 60);
                jTextArea.setCaretPosition(0);
                jTextArea.setEditable(false);
                jPanel.add((Component)new JScrollPane(jTextArea), GBC.eop());
                for (Component component : jPanel.getComponents()) {
                    if (!(component instanceof JMultilineLabel)) continue;
                    ((JMultilineLabel)component).setMaxWidth(400);
                }
                JOptionPane.showMessageDialog(Main.parent, jPanel, I18n.tr("You have encountered a bug in JOSM"), 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

