/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileLoader
implements TileLoader {
    public static String USER_AGENT = null;
    public static String ACCEPT = "text/html, image/png, image/jpeg, image/gif, */*";
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener tileLoaderListener) {
        this.listener = tileLoaderListener;
    }

    public Runnable createTileLoaderJob(final TileSource tileSource, final int n, final int n2, final int n3) {
        return new Runnable(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile;
                TileCache tileCache;
                TileCache tileCache2 = tileCache = OsmTileLoader.this.listener.getTileCache();
                synchronized (tileCache2) {
                    tile = tileCache.getTile(tileSource, n, n2, n3);
                    if (tile == null || tile.isLoaded() || tile.loading) {
                        return;
                    }
                    tile.loading = true;
                }
                try {
                    this.input = OsmTileLoader.this.loadTileFromOsm(tile).getInputStream();
                    tile.loadImage(this.input);
                    tile.setLoaded(true);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                    this.input.close();
                    this.input = null;
                }
                catch (Exception exception) {
                    tile.setImage(Tile.ERROR_IMAGE);
                    tile.error = true;
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                    if (this.input == null) {
                        System.err.println("failed loading " + n3 + "/" + n + "/" + n2 + " " + exception.getMessage());
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }
        };
    }

    protected HttpURLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL uRL = new URL(tile.getUrl());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.prepareHttpUrlConnection(httpURLConnection);
        httpURLConnection.setReadTimeout(30000);
        return httpURLConnection;
    }

    protected void prepareHttpUrlConnection(HttpURLConnection httpURLConnection) {
        if (USER_AGENT != null) {
            httpURLConnection.setRequestProperty("User-agent", USER_AGENT);
        }
        httpURLConnection.setRequestProperty("Accept", ACCEPT);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

