/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;

public class FullscreenToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;
    private GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();

    public FullscreenToggleAction() {
        super(I18n.tr("Fullscreen View"), null, I18n.tr("Toggle fullscreen view"), Shortcut.registerShortcut("menu:view:fullscreen", I18n.tr("Toggle Fullscreen view"), 122, 5), true);
        this.selected = Main.pref.getBoolean("draw.fullscreen", false);
        this.notifySelectedState();
    }

    public boolean canFullscreen() {
        return Main.platform instanceof PlatformHookUnixoid && this.gd.isFullScreenSupported();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        this.selected = !this.selected;
        Main.pref.put("draw.fullscreen", this.selected);
        this.notifySelectedState();
        if (this.selected) {
            Frame frame = (Frame)Main.parent;
            this.gd.setFullScreenWindow(frame);
        } else {
            this.gd.setFullScreenWindow(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }
}

