/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasteTagsAction
extends JosmAction {
    public PasteTagsAction(JosmAction josmAction) {
        super(I18n.tr("Paste Tags"), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items."), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags")), 86, 2, 1), true);
        josmAction.addListener(this);
        this.putValue("help", HelpUtil.ht("/Action/PasteTags"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getCurrentDataSet().getSelected().isEmpty()) {
            return;
        }
        TagPaster tagPaster = new TagPaster(Main.pasteBuffer.getDirectlyAdded(), this.getCurrentDataSet().getSelected());
        for (Command command : tagPaster.execute()) {
            Main.main.undoRedo.add(command);
        }
    }

    @Override
    public void pasteBufferChanged(PrimitiveDeepCopy primitiveDeepCopy) {
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!this.getCurrentDataSet().getSelected().isEmpty() && !TagCollection.unionOfAllPrimitives(Main.pasteBuffer.getDirectlyAdded()).isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty() && !TagCollection.unionOfAllPrimitives(Main.pasteBuffer.getDirectlyAdded()).isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagPaster {
        private final Collection<PrimitiveData> source;
        private final Collection<OsmPrimitive> target;
        private final List<Command> commands = new ArrayList<Command>();

        public TagPaster(Collection<PrimitiveData> collection, Collection<OsmPrimitive> collection2) {
            this.source = collection;
            this.target = collection2;
        }

        protected boolean isHeteogeneousSource() {
            int n = 0;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.NODE).isEmpty() ? n + 1 : n;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.WAY).isEmpty() ? n + 1 : n;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.RELATION).isEmpty() ? n + 1 : n;
            return n > 1;
        }

        protected <T extends PrimitiveData> Collection<? extends PrimitiveData> getSourcePrimitivesByType(OsmPrimitiveType osmPrimitiveType) {
            return PrimitiveData.getFilteredList(this.source, osmPrimitiveType);
        }

        protected <T extends OsmPrimitive> TagCollection getSourceTagsByType(OsmPrimitiveType osmPrimitiveType) {
            return TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(osmPrimitiveType));
        }

        protected <T extends OsmPrimitive> boolean hasSourceTagsByType(OsmPrimitiveType osmPrimitiveType) {
            return !this.getSourceTagsByType(osmPrimitiveType).isEmpty();
        }

        protected Command buildChangeCommand(Collection<? extends OsmPrimitive> collection, TagCollection tagCollection) {
            ArrayList<Command> arrayList = new ArrayList<Command>();
            for (String string : tagCollection.getKeys()) {
                String string2 = tagCollection.getValues(string).iterator().next();
                string2 = string2.equals("") ? null : string2;
                arrayList.add(new ChangePropertyCommand(collection, string, string2));
            }
            if (!arrayList.isEmpty()) {
                String string;
                String string3 = I18n.trn("Pasting {0} tag", "Pasting {0} tags", tagCollection.getKeys().size(), tagCollection.getKeys().size());
                string = I18n.trn("to {0} primitive", "to {0} primtives", collection.size(), collection.size());
                return new SequenceCommand((String)string3 + " " + string, arrayList);
            }
            return null;
        }

        protected Map<OsmPrimitiveType, Integer> getSourceStatistics() {
            HashMap<OsmPrimitiveType, Integer> hashMap = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                if (this.getSourceTagsByType(osmPrimitiveType).isEmpty()) continue;
                hashMap.put(osmPrimitiveType, this.getSourcePrimitivesByType(osmPrimitiveType).size());
            }
            return hashMap;
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            HashMap<OsmPrimitiveType, Integer> hashMap = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                int n = OsmPrimitive.getFilteredList(this.target, osmPrimitiveType.getOsmClass()).size();
                if (n <= 0) continue;
                hashMap.put(osmPrimitiveType, n);
            }
            return hashMap;
        }

        protected void pasteFromHomogeneousSource() {
            Object object;
            TagCollection tagCollection = null;
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                TagCollection tagCollection2 = this.getSourceTagsByType(osmPrimitiveType);
                if (tagCollection2.isEmpty()) continue;
                tagCollection = tagCollection2;
            }
            if (tagCollection == null) {
                return;
            }
            if (!tagCollection.isApplicableToPrimitive()) {
                object = new PasteTagsConflictResolverDialog(Main.parent);
                ((PasteTagsConflictResolverDialog)object).populate(tagCollection, this.getSourceStatistics(), this.getTargetStatistics());
                ((PasteTagsConflictResolverDialog)object).setVisible(true);
                if (((PasteTagsConflictResolverDialog)object).isCanceled()) {
                    return;
                }
                Command command = this.buildChangeCommand(this.target, ((PasteTagsConflictResolverDialog)object).getResolution());
                this.commands.add(command);
            } else {
                object = this.buildChangeCommand(this.target, tagCollection);
                this.commands.add((Command)object);
            }
        }

        protected <T extends OsmPrimitive> boolean hasTargetPrimitives(Class<T> clazz) {
            return !OsmPrimitive.getFilteredList(this.target, clazz).isEmpty();
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict(Collection<OsmPrimitive> collection) {
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                TagCollection tagCollection;
                if (!this.hasTargetPrimitives(osmPrimitiveType.getOsmClass()) || (tagCollection = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(osmPrimitiveType))).isEmpty() || tagCollection.isApplicableToPrimitive()) continue;
                return false;
            }
            return true;
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict(this.target)) {
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                    if (!this.hasSourceTagsByType(osmPrimitiveType) || !this.hasTargetPrimitives(osmPrimitiveType.getOsmClass())) continue;
                    Command command = this.buildChangeCommand(this.target, this.getSourceTagsByType(osmPrimitiveType));
                    this.commands.add(command);
                }
            } else {
                PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
                pasteTagsConflictResolverDialog.populate(this.getSourceTagsByType(OsmPrimitiveType.NODE), this.getSourceTagsByType(OsmPrimitiveType.WAY), this.getSourceTagsByType(OsmPrimitiveType.RELATION), this.getSourceStatistics(), this.getTargetStatistics());
                pasteTagsConflictResolverDialog.setVisible(true);
                if (pasteTagsConflictResolverDialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
                    if (!this.hasSourceTagsByType(osmPrimitiveType) || !this.hasTargetPrimitives(osmPrimitiveType.getOsmClass())) continue;
                    Command command = this.buildChangeCommand(OsmPrimitive.getFilteredList(this.target, osmPrimitiveType.getOsmClass()), pasteTagsConflictResolverDialog.getResolution(osmPrimitiveType));
                    this.commands.add(command);
                }
            }
        }

        public List<Command> execute() {
            this.commands.clear();
            if (this.isHeteogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.commands;
        }
    }
}

