/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashSet<Node> hashSet;
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        List<Node> list = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list2 = OsmPrimitive.getFilteredList(collection, Way.class);
        if (!this.checkSelection(collection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting."), I18n.tr("Warning"), 2);
            return;
        }
        Way way = null;
        if (!list2.isEmpty()) {
            way = list2.get(0);
        }
        if (way == null && !list.isEmpty()) {
            hashSet = new HashMap();
            for (Node entry : list) {
                block1: for (Way way2 : OsmPrimitive.getFilteredList(entry.getReferrers(), Way.class)) {
                    int n;
                    if (!way2.isUsable() || (n = way2.getNodesCount() - 1) <= 0) continue;
                    boolean bl = way2.isClosed();
                    int n2 = 0;
                    for (Node node : way2.getNodes()) {
                        if ((bl || n2 > 0 && n2 < n) && entry.equals(node)) {
                            Integer n3 = (Integer)hashSet.get(way2);
                            hashSet.put(way2, n3 == null ? 1 : n3 + 1);
                            continue block1;
                        }
                        ++n2;
                    }
                }
            }
            if (hashSet.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", list.size()), I18n.tr("Warning"), 2);
                return;
            }
            for (Map.Entry entry : hashSet.entrySet()) {
                if (!((Integer)entry.getValue()).equals(list.size())) continue;
                if (way != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", list.size()), I18n.tr("Warning"), 2);
                    return;
                }
                way = (Way)entry.getKey();
            }
            if (way == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."), I18n.tr("Warning"), 2);
                return;
            }
        } else if (way != null && !list.isEmpty()) {
            hashSet = new HashSet<Node>(list);
            hashSet.removeAll(way.getNodes());
            if (!hashSet.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected way does not contain the selected node.", "The selected way does not contain all the selected nodes.", list.size()), I18n.tr("Warning"), 2);
                return;
            }
        }
        if ((hashSet = SplitWayAction.buildSplitChunks(way, list)) != null) {
            Iterator iterator = SplitWayAction.splitWay(this.getEditLayer(), way, hashSet);
            Main.main.undoRedo.add(((SplitWayResult)((Object)iterator)).getCommand());
            this.getCurrentDataSet().setSelected(((SplitWayResult)((Object)iterator)).getNewSelection());
        }
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> collection) {
        boolean bl = false;
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Way && !bl) {
                bl = true;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    public static List<List<Node>> buildSplitChunks(Way way, List<Node> list) {
        Object object;
        CheckParameterUtil.ensureParameterNotNull(way, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(list, "splitPoints");
        HashSet<Node> hashSet = new HashSet<Node>(list);
        LinkedList<List<Node>> linkedList = new LinkedList<List<Node>>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        linkedList.add(arrayList);
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = arrayList.isEmpty() || !iterator.hasNext();
            arrayList.add(object);
            if (!hashSet.contains(object) || bl) continue;
            arrayList = new ArrayList();
            arrayList.add(object);
            linkedList.add(arrayList);
        }
        object = (List)linkedList.get(linkedList.size() - 1);
        if (linkedList.size() >= 2 && ((List)linkedList.get(0)).get(0) == object.get(object.size() - 1) && !hashSet.contains(((List)linkedList.get(0)).get(0))) {
            if (linkedList.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
                return null;
            }
            object.remove(object.size() - 1);
            object.addAll((Collection)linkedList.get(0));
            linkedList.remove(linkedList.size() - 1);
            linkedList.set(0, (List<Node>)object);
        }
        if (linkedList.size() < 2) {
            if (((List)linkedList.get(0)).get(0) == ((List)linkedList.get(0)).get(((List)linkedList.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"), I18n.tr("Warning"), 2);
            }
            return null;
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    public static SplitWayResult splitWay(OsmDataLayer osmDataLayer, Way way, List<List<Node>> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>(list.size());
        ArrayList<Way> arrayList2 = new ArrayList<Way>(list.size());
        Iterator<List<Node>> iterator = list.iterator();
        Way way2 = new Way(way);
        way2.setNodes(iterator.next());
        arrayList.add(new ChangeCommand(way, way2));
        arrayList2.add(way);
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        while (iterator.hasNext()) {
            Way way3 = new Way();
            way3.setKeys(way.getKeys());
            arrayList3.add(way3);
            way3.setNodes(iterator.next());
            arrayList.add(new AddCommand(osmDataLayer, way3));
            arrayList2.add(way3);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Relation relation : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!relation.isUsable()) continue;
            Relation relation2 = null;
            String string = relation.get("type");
            if (string == null) {
                string = "";
            }
            int n = 0;
            List<RelationMember> list2 = relation.getMembers();
            for (RelationMember relationMember : list2) {
                if (relationMember.isWay() && relationMember.getMember() == way) {
                    Object object2;
                    Object object4;
                    boolean bl3 = true;
                    if ("restriction".equals(string)) {
                        object4 = relationMember.getRole();
                        if ("from".equals(object4) || "to".equals(object4)) {
                            void var22_29;
                            OsmPrimitive osmPrimitive = null;
                            for (RelationMember relationMember2 : relation.getMembers()) {
                                if (!"via".equals(relationMember2.getRole())) continue;
                                osmPrimitive = relationMember2.getMember();
                            }
                            object2 = new ArrayList();
                            if (osmPrimitive != null) {
                                if (osmPrimitive instanceof Node) {
                                    object2.add((Node)osmPrimitive);
                                } else if (osmPrimitive instanceof Way) {
                                    object2.add(((Way)osmPrimitive).lastNode());
                                    object2.add(((Way)osmPrimitive).firstNode());
                                }
                            }
                            Object var22_28 = null;
                            Object object = object2.iterator();
                            while (object.hasNext()) {
                                Node node = (Node)object.next();
                                if (!way2.isFirstLastNode(node)) continue;
                                Way way3 = way;
                            }
                            if (var22_29 == null) {
                                void var22_31;
                                for (Way way4 : arrayList3) {
                                    Iterator iterator2 = object2.iterator();
                                    while (iterator2.hasNext()) {
                                        Node node = (Node)iterator2.next();
                                        if (!way4.isFirstLastNode(node)) continue;
                                        Way way5 = way4;
                                    }
                                }
                                if (var22_31 != null) {
                                    if (relation2 == null) {
                                        relation2 = new Relation(relation);
                                    }
                                    relation2.addMember(new RelationMember((String)object4, (OsmPrimitive)var22_31));
                                    relation2.removeMembersFor(way);
                                    bl3 = false;
                                }
                            } else {
                                bl3 = false;
                            }
                        } else if (!"via".equals(object4)) {
                            bl2 = true;
                        }
                    } else if (!"route".equals(string) && !"multipolygon".equals(string)) {
                        bl2 = true;
                    }
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                    }
                    if (bl3) {
                        if (relationMember.hasRole() && !"multipolygon".equals(string)) {
                            bl = true;
                        }
                        object4 = null;
                        int n2 = 1;
                        while (n - n2 >= 0 || n + n2 < list2.size()) {
                            if (n - n2 >= 0 && list2.get(n - n2).isWay()) {
                                object2 = list2.get(n - n2).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = false;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = true;
                                break;
                            }
                            if (n + n2 < list2.size() && list2.get(n + n2).isWay()) {
                                object2 = list2.get(n + n2).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = true;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = false;
                                break;
                            }
                            ++n2;
                        }
                        int n3 = n;
                        for (Object object : arrayList3) {
                            RelationMember relationMember3 = new RelationMember(relationMember.getRole(), (OsmPrimitive)object);
                            ++n3;
                            if (object4 != null && ((Boolean)object4).booleanValue()) {
                                relation2.addMember(n, relationMember3);
                                continue;
                            }
                            relation2.addMember(n3, relationMember3);
                        }
                        n = n3;
                    }
                }
                ++n;
            }
            if (relation2 == null) continue;
            arrayList.add(new ChangeCommand(osmDataLayer, relation, relation2));
        }
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        } else if (bl2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        }
        return new SplitWayResult(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", way.getDisplayName(DefaultNameFormatter.getInstance()), list.size()), arrayList), arrayList2, way, arrayList3);
    }

    public static SplitWayResult split(OsmDataLayer osmDataLayer, Way way, List<Node> list) {
        List<List<Node>> list2 = SplitWayAction.buildSplitChunks(way, list);
        if (list2 == null) {
            return null;
        }
        return SplitWayAction.splitWay(osmDataLayer, way, list2);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(collection));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;
        private Way originalWay;
        private List<Way> newWays;

        public SplitWayResult(Command command, List<? extends PrimitiveId> list, Way way, List<Way> list2) {
            this.command = command;
            this.newSelection = list;
            this.originalWay = way;
            this.newWays = list2;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }

        public Way getOriginalWay() {
            return this.originalWay;
        }

        public List<Way> getNewWays() {
            return this.newWays;
        }
    }
}

