/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadPrimitiveTask
extends PleaseWaitRunnable {
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private PrimitiveId primitiveId;
    private OsmDataLayer layer;
    private OsmServerObjectReader reader;

    public DownloadPrimitiveTask(PrimitiveId primitiveId, OsmDataLayer osmDataLayer) {
        super(I18n.tr("Download object"), false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
        this.primitiveId = primitiveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        DownloadPrimitiveTask downloadPrimitiveTask = this;
        synchronized (downloadPrimitiveTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DownloadPrimitiveTask.this.layer.mergeFrom(DownloadPrimitiveTask.this.ds);
                DownloadPrimitiveTask.this.layer.onPostDownloadFromServer();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            DownloadPrimitiveTask downloadPrimitiveTask = this;
            synchronized (downloadPrimitiveTask) {
                if (this.canceled) {
                    return;
                }
                this.reader = new OsmServerObjectReader(this.primitiveId, true);
            }
            this.ds = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            downloadPrimitiveTask = this;
            synchronized (downloadPrimitiveTask) {
                this.reader = null;
            }
        }
        catch (Exception exception) {
            if (this.canceled) {
                return;
            }
            this.lastException = exception;
        }
    }
}

