/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicUploadDependencyException
extends Exception {
    private Stack<Relation> cycle;

    public CyclicUploadDependencyException(Stack<Relation> stack) {
        this.cycle = stack;
    }

    protected String formatRelation(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer();
        if (relation.getName() != null) {
            stringBuffer.append("'").append(relation.getName()).append("'");
        } else if (!relation.isNew()) {
            stringBuffer.append(relation.getId());
        } else {
            stringBuffer.append("relation@").append(relation.hashCode());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(I18n.tr("Cyclic dependency between relations:"));
        stringBuffer.append("[");
        for (int i = 0; i < this.cycle.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.formatRelation((Relation)this.cycle.get(i)));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public List<Relation> getCyclicUploadDependency() {
        return new ArrayList<Relation>(this.cycle);
    }
}

