/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.RoleCorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrectionTable;
import org.openstreetmap.josm.corrector.TagCorrectionTableModel;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagCorrector<P extends OsmPrimitive> {
    private String[] applicationOptions = new String[]{I18n.tr("Apply selected changes"), I18n.tr("Do not apply changes"), I18n.tr("Cancel")};

    public abstract Collection<Command> execute(P var1, P var2) throws UserCancelException;

    protected Collection<Command> applyCorrections(Map<OsmPrimitive, List<TagCorrection>> map, Map<OsmPrimitive, List<RoleCorrection>> map2, String string) throws UserCancelException {
        if (!map.isEmpty() || !map2.isEmpty()) {
            Object object;
            Object object2;
            List<RoleCorrection> list;
            Object object3;
            ArrayList<Command> arrayList = new ArrayList<Command>();
            HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
            HashMap<OsmPrimitive, Object> hashMap2 = new HashMap<OsmPrimitive, Object>();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
            jMultilineLabel.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel, GBC.eop().anchor(10));
            JMultilineLabel jMultilineLabel2 = new JMultilineLabel(I18n.tr("Please select which property changes you want to apply."));
            jMultilineLabel2.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel2, GBC.eop().anchor(10));
            for (OsmPrimitive object4 : map.keySet()) {
                List<TagCorrection> list2 = map.get(object4);
                if (list2.isEmpty()) continue;
                object3 = new JLabel(I18n.tr("Properties of "));
                jPanel.add((Component)object3, GBC.std());
                list = new JLabel(object4.getDisplayName(DefaultNameFormatter.getInstance()) + ":", ImageProvider.get(OsmPrimitiveType.from(object4)), 2);
                jPanel.add((Component)((Object)list), GBC.eol());
                object2 = new TagCorrectionTable(list2);
                object = new JScrollPane((Component)object2);
                jPanel.add((Component)object, GBC.eop().fill(2));
                hashMap.put(object4, object2);
            }
            for (OsmPrimitive osmPrimitive : map2.keySet()) {
                List<RoleCorrection> list3 = map2.get(osmPrimitive);
                if (list3.isEmpty()) continue;
                object3 = new JLabel(I18n.tr("Roles in relations referring to"));
                jPanel.add((Component)object3, GBC.std());
                list = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 2);
                jPanel.add((Component)((Object)list), GBC.eol());
                object2 = new RoleCorrectionTable(list3);
                object = new JScrollPane((Component)object2);
                jPanel.add((Component)object, GBC.eop().fill(2));
                hashMap2.put(osmPrimitive, object2);
            }
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Automatic tag correction"), 1, -1, null, this.applicationOptions, this.applicationOptions[0]);
            if (n == 0) {
                for (Map.Entry<OsmPrimitive, List<TagCorrection>> entry : map.entrySet()) {
                    object3 = entry.getValue();
                    list = entry.getKey();
                    object2 = null;
                    if (list instanceof Way) {
                        object2 = new Way((Way)((Object)list));
                    } else if (list instanceof Node) {
                        object2 = new Node((Node)((Object)list));
                    } else if (list instanceof Relation) {
                        object2 = new Relation((Relation)((Object)list));
                    }
                    object = new HashSet();
                    for (int i = 0; i < object3.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)hashMap.get(list)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = (TagCorrection)object3.get(i);
                        if (tagCorrection.isKeyChanged() && !object.contains(tagCorrection.oldKey)) {
                            ((OsmPrimitive)object2).remove(tagCorrection.oldKey);
                        }
                        ((OsmPrimitive)object2).put(tagCorrection.newKey, tagCorrection.newValue);
                        object.add(tagCorrection.newKey);
                    }
                    if (object.isEmpty()) continue;
                    arrayList.add(new ChangeCommand((OsmPrimitive)((Object)list), (OsmPrimitive)object2));
                }
                for (Map.Entry<OsmPrimitive, List<RoleCorrection>> entry : map2.entrySet()) {
                    object3 = entry.getKey();
                    list = entry.getValue();
                    for (int i = 0; i < list.size(); ++i) {
                        object = list.get(i);
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)hashMap2.get(object3)).getCorrectionTableModel()).getApply(i)) continue;
                        arrayList.add(new ChangeRelationMemberRoleCommand(((RoleCorrection)object).relation, ((RoleCorrection)object).position, ((RoleCorrection)object).newRole));
                    }
                }
            } else if (n != 1) {
                throw new UserCancelException();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

