/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatasetCollection
extends AbstractCollection<OsmPrimitive> {
    private final Collection<OsmPrimitive> primitives;
    private final Predicate<OsmPrimitive> predicate;

    public DatasetCollection(Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        this.primitives = collection;
        this.predicate = predicate;
    }

    @Override
    public Iterator<OsmPrimitive> iterator() {
        return new FilterIterator(this.primitives.iterator());
    }

    @Override
    public int size() {
        int n = 0;
        Iterator<OsmPrimitive> iterator = this.iterator();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterIterator
    implements Iterator<OsmPrimitive> {
        private final Iterator<OsmPrimitive> iterator;
        private OsmPrimitive current;

        public FilterIterator(Iterator<OsmPrimitive> iterator) {
            this.iterator = iterator;
        }

        private void findNext() {
            if (this.current == null) {
                while (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    if (!DatasetCollection.this.predicate.evaluate(this.current)) continue;
                    return;
                }
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.current != null;
        }

        @Override
        public OsmPrimitive next() {
            this.findNext();
            OsmPrimitive osmPrimitive = this.current;
            this.current = null;
            return osmPrimitive;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

