/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryDataSet
implements MapView.LayerChangeListener {
    private static HistoryDataSet historyDataSet;
    private HashMap<PrimitiveId, ArrayList<HistoryOsmPrimitive>> data = new HashMap();
    private CopyOnWriteArrayList<HistoryDataSetListener> listeners = new CopyOnWriteArrayList();

    public static HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
            MapView.addLayerChangeListener(historyDataSet);
        }
        return historyDataSet;
    }

    public void addHistoryDataSetListener(HistoryDataSetListener historyDataSetListener) {
        if (historyDataSetListener != null) {
            this.listeners.addIfAbsent(historyDataSetListener);
        }
    }

    public void removeHistoryDataSetListener(HistoryDataSetListener historyDataSetListener) {
        this.listeners.remove(historyDataSetListener);
    }

    protected void fireHistoryUpdated(PrimitiveId primitiveId) {
        for (HistoryDataSetListener historyDataSetListener : this.listeners) {
            historyDataSetListener.historyUpdated(this, primitiveId);
        }
    }

    protected void fireCacheCleared() {
        for (HistoryDataSetListener historyDataSetListener : this.listeners) {
            historyDataSetListener.historyDataSetCleared(this);
        }
    }

    public HistoryOsmPrimitive get(long l, OsmPrimitiveType osmPrimitiveType, long l2) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        if (l2 <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "version", l2));
        }
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(l, osmPrimitiveType);
        ArrayList<HistoryOsmPrimitive> arrayList = this.data.get(simplePrimitiveId);
        if (arrayList == null) {
            return null;
        }
        for (HistoryOsmPrimitive historyOsmPrimitive : arrayList) {
            if (!historyOsmPrimitive.matches(l, l2)) continue;
            return historyOsmPrimitive;
        }
        return null;
    }

    public void put(HistoryOsmPrimitive historyOsmPrimitive) {
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(historyOsmPrimitive.getId(), historyOsmPrimitive.getType());
        if (this.data.get(simplePrimitiveId) == null) {
            this.data.put(simplePrimitiveId, new ArrayList());
        }
        this.data.get(simplePrimitiveId).add(historyOsmPrimitive);
        this.fireHistoryUpdated(simplePrimitiveId);
    }

    public History getHistory(long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(l, osmPrimitiveType);
        return this.getHistory(simplePrimitiveId);
    }

    public History getHistory(PrimitiveId primitiveId) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, "pid");
        ArrayList<HistoryOsmPrimitive> arrayList = this.data.get(primitiveId);
        if (arrayList == null) {
            return null;
        }
        return new History(primitiveId.getUniqueId(), primitiveId.getType(), arrayList);
    }

    public void mergeInto(HistoryDataSet historyDataSet) {
        if (historyDataSet == null) {
            return;
        }
        for (PrimitiveId primitiveId : historyDataSet.data.keySet()) {
            this.data.put(primitiveId, historyDataSet.data.get(primitiveId));
        }
        this.fireHistoryUpdated(null);
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        if (Main.map.mapView.getNumLayers() == 0) {
            this.data.clear();
            this.fireCacheCleared();
        }
    }
}

