/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.ListOfUsedTags;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.widgets.AutoCompleteComboBox;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final ListOfUsedTags listOfUsedTags = new ListOfUsedTags();
    private DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    public JComboBox taggingPresets = new JComboBox();
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final JPanel presets = new JPanel(new GridBagLayout());
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Please select the objects you want to change properties for.") + "</p></html>");

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.listOfUsedTags, DatasetEventManager.FireMode.IMMEDIATELY);
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.listOfUsedTags.rebuildNecessary();
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.listOfUsedTags);
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
    }

    void propertyEdit(int n) {
        String string;
        String string2;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        this.objKey = string2 = this.propertyData.getValueAt(n, 0).toString();
        String string3 = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", string2) + ")</html>";
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string3), "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        AutoCompleteComboBox autoCompleteComboBox = new AutoCompleteComboBox();
        autoCompleteComboBox.setPossibleItems(this.listOfUsedTags.getUsedKeys());
        autoCompleteComboBox.setEditable(true);
        autoCompleteComboBox.setSelectedItem(string2);
        jPanel2.add((Component)new JLabel(I18n.tr("Key")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompleteComboBox, GBC.eol().fill(2));
        final AutoCompleteComboBox autoCompleteComboBox2 = new AutoCompleteComboBox();
        autoCompleteComboBox2.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    Map map;
                    String string = null;
                    string = (String)object;
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (map = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(string)) {
                        string = string + "(" + map.get(string) + ")";
                        component.setFont(component.getFont().deriveFont(3));
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        autoCompleteComboBox2.setEditable(true);
        autoCompleteComboBox2.setPossibleItems(this.listOfUsedTags.getUsedValues(string2));
        Map map = (Map)this.propertyData.getValueAt(n, 1);
        String string4 = map.size() != 1 ? I18n.tr("<different>") : (String)map.entrySet().iterator().next().getKey();
        autoCompleteComboBox2.setSelectedItem(string4);
        autoCompleteComboBox2.getEditor().setItem(string4);
        jPanel2.add((Component)new JLabel(I18n.tr("Value")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompleteComboBox2, GBC.eol().fill(2));
        this.addFocusAdapter(n, autoCompleteComboBox, autoCompleteComboBox2);
        final JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2){

            public void selectInitialValue() {
                autoCompleteComboBox2.requestFocusInWindow();
                autoCompleteComboBox2.getEditor().selectAll();
            }
        };
        final JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        autoCompleteComboBox2.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jOptionPane.setValue(0);
            }
        });
        String string5 = autoCompleteComboBox2.getEditor().getItem().toString();
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null || object == JOptionPane.UNINITIALIZED_VALUE || object instanceof Integer && (Integer)object != 0) {
            autoCompleteComboBox2.getEditor().setItem(string5);
            return;
        }
        String string6 = autoCompleteComboBox2.getEditor().getItem().toString().trim();
        if (string6.equals("")) {
            string6 = null;
        }
        if ((string = autoCompleteComboBox.getEditor().getItem().toString().trim()).equals("")) {
            string = string2;
            string6 = null;
        }
        if (string2.equals(string) && I18n.tr("<different>").equals(string6)) {
            return;
        }
        if (string2.equals(string) || string6 == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string6));
        } else {
            Vector<Command> vector = new Vector<Command>();
            vector.add(new ChangePropertyCommand(collection, string2, null));
            if (string6.equals(I18n.tr("<different>"))) {
                HashMap hashMap = new HashMap();
                for (OsmPrimitive object2 : collection) {
                    String string7 = object2.get(string2);
                    if (string7 == null) continue;
                    if (hashMap.containsKey(string7)) {
                        ((Vector)hashMap.get(string7)).add(object2);
                        continue;
                    }
                    Vector<OsmPrimitive> vector2 = new Vector<OsmPrimitive>();
                    vector2.add(object2);
                    hashMap.put(string7, vector2);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    vector.add(new ChangePropertyCommand((Collection)entry.getValue(), string, (String)entry.getKey()));
                }
            } else {
                vector.add(new ChangePropertyCommand(collection, string, string6));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", collection.size(), collection.size()), vector));
        }
        if (!string2.equals(string)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (this.propertyData.getValueAt(i, 0).toString() != string) continue;
                n = i;
                break;
            }
        }
        this.propertyTable.changeSelection(n, 0, false, false);
    }

    void membershipEdit(int n) {
        Relation relation = (Relation)this.membershipData.getValueAt(n, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, (Collection)this.membershipData.getValueAt(n, 1)).setVisible(true);
    }

    void add() {
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>" + I18n.tr("Please select a key")), "North");
        final AutoCompleteComboBox autoCompleteComboBox = new AutoCompleteComboBox();
        ArrayList<String> arrayList = new ArrayList<String>(this.listOfUsedTags.getUsedKeys());
        for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
            arrayList.remove(this.propertyData.getValueAt(i, 0));
        }
        autoCompleteComboBox.setPossibleItems(arrayList);
        autoCompleteComboBox.setEditable(true);
        jPanel.add((Component)autoCompleteComboBox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)new JLabel(I18n.tr("Please select a value")), "North");
        AutoCompleteComboBox autoCompleteComboBox2 = new AutoCompleteComboBox();
        autoCompleteComboBox2.setEditable(true);
        jPanel2.add((Component)autoCompleteComboBox2, "Center");
        this.addFocusAdapter(-1, autoCompleteComboBox, autoCompleteComboBox2);
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2){

            public void selectInitialValue() {
                autoCompleteComboBox.requestFocusInWindow();
                autoCompleteComboBox.getEditor().selectAll();
            }
        };
        JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        jDialog.setVisible(true);
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return;
        }
        String string = autoCompleteComboBox.getEditor().getItem().toString().trim();
        String string2 = autoCompleteComboBox2.getEditor().getItem().toString().trim();
        if (string2.equals("")) {
            return;
        }
        Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string2));
        this.btnAdd.requestFocusInWindow();
    }

    private void addFocusAdapter(int n, final AutoCompleteComboBox autoCompleteComboBox, final AutoCompleteComboBox autoCompleteComboBox2) {
        JTextComponent jTextComponent = (JTextComponent)autoCompleteComboBox2.getEditor().getEditorComponent();
        jTextComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                String string = autoCompleteComboBox.getEditor().getItem().toString();
                autoCompleteComboBox2.setPossibleItems(PropertiesDialog.this.listOfUsedTags.getUsedValues(string));
                PropertiesDialog.this.objKey = string;
            }
        });
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships"), "propertiesdialog", I18n.tr("Properties for selected objects."), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships")), 80, 4, 1), 150, true);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    } else if (object instanceof Map) {
                        Map map = (Map)object;
                        if (map.size() != 1) {
                            string = I18n.tr("<different>");
                            component.setFont(component.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = map.entrySet().iterator().next();
                            string = (String)entry.getKey();
                        }
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of"), I18n.tr("Role")});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(point);
                if (n > -1) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
                    jPopupMenu.add(new SelectRelationAction(relation, true));
                    jPopupMenu.add(new SelectRelationAction(relation, false));
                    jPopupMenu.show(PropertiesDialog.this.membershipTable, point.x, point.y - 3);
                }
            }
        });
        this.membershipTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setText(((Relation)object).getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return component;
            }
        });
        this.membershipTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    Collection collection = (Collection)object;
                    String string = null;
                    for (RelationMember relationMember : collection) {
                        if (string == null) {
                            string = relationMember.getRole();
                            continue;
                        }
                        if (string.equals(relationMember.getRole())) continue;
                        string = I18n.tr("<different>");
                        break;
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        JPanel jPanel = new JPanel();
        boolean bl = Main.pref.getBoolean("properties.presets.top", true);
        jPanel.setLayout(new GridBagLayout());
        if (bl) {
            jPanel.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        jPanel.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        jPanel.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!bl) {
            jPanel.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        DblClickWatch dblClickWatch = new DblClickWatch();
        this.propertyTable.addMouseListener(dblClickWatch);
        this.membershipTable.addMouseListener(dblClickWatch);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.addMouseListener(dblClickWatch);
        this.add((Component)jScrollPane, "Center");
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setSize(jScrollPane.getSize());
        JPanel jPanel2 = this.getButtonPanel(3);
        AddAction addAction = new AddAction();
        this.btnAdd = new SideButton(addAction);
        this.btnAdd.setFocusable(true);
        jPanel2.add(this.btnAdd);
        this.btnAdd.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "onEnter");
        this.btnAdd.getActionMap().put("onEnter", addAction);
        Shortcut shortcut = Shortcut.registerShortcut("properties:add", I18n.tr("Add Properties"), 66, 6);
        Main.contentPane.getInputMap(2).put(shortcut.getKeyStroke(), "properties:add");
        Main.contentPane.getActionMap().put("properties:add", addAction);
        EditAction editAction = new EditAction();
        this.propertyTable.getSelectionModel().addListSelectionListener(editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(editAction);
        this.btnEdit = new SideButton(editAction);
        jPanel2.add(this.btnEdit);
        DeleteAction deleteAction = new DeleteAction();
        this.btnDel = new SideButton(deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteAction);
        jPanel2.add(this.btnDel);
        this.add((Component)jPanel2, "South");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    private void checkPresets(int n, int n2, int n3, int n4) {
        this.presets.removeAll();
        int n5 = n + n2 + n3 + n4;
        if (n5 == 0) {
            this.presets.setVisible(false);
            return;
        }
        for (Cloneable cloneable : TaggingPresetPreference.taggingPresets) {
            if (cloneable.types != null && n3 > 0 && !cloneable.types.contains("relation") && n > 0 && !cloneable.types.contains("node") && n2 + n4 > 0 && !cloneable.types.contains("way") && n4 > 0 && !cloneable.types.contains("closedway") || !cloneable.isShowable()) continue;
            int n6 = 0;
            for (TaggingPreset.Item item : cloneable.data) {
                Map<String, Integer> map;
                if (!(item instanceof TaggingPreset.Key)) continue;
                String string = ((TaggingPreset.Key)item).value;
                String string2 = ((TaggingPreset.Key)item).key;
                n6 -= 100;
                if (string2 == null || !this.valueCount.containsKey(string2) || (map = this.valueCount.get(string2)).size() != 1 || string == null || !map.containsKey(string) || map.get(string) != n5) continue;
                n6 += 101;
            }
            if (n6 <= 0) continue;
            JLabel jLabel = new JLabel(cloneable.getName());
            class PresetLabelML
            implements MouseListener {
                JLabel label;
                Font bold;
                Font normal;
                TaggingPreset tag;

                PresetLabelML(JLabel jLabel, TaggingPreset taggingPreset) {
                    this.label = jLabel;
                    jLabel.setCursor(new Cursor(12));
                    this.normal = this.label.getFont();
                    this.bold = this.normal.deriveFont(this.normal.getStyle() ^ 1);
                    this.tag = taggingPreset;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.tag.actionPerformed(null);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.label.setFont(this.bold);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.label.setFont(this.normal);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            }
            jLabel.addMouseListener(new PresetLabelML(jLabel, (TaggingPreset)cloneable));
            this.presets.add((Component)jLabel, GBC.eol().fill(2));
        }
        if (this.presets.getComponentCount() > 0) {
            Cloneable cloneable;
            this.presets.setVisible(true);
            int n7 = this.presets.getComponentCount() * this.presets.getComponent(0).getHeight();
            cloneable = new Dimension(this.presets.getWidth(), n7);
            this.presets.setMaximumSize((Dimension)cloneable);
            this.presets.setMinimumSize((Dimension)cloneable);
        } else {
            this.presets.setVisible(false);
        }
    }

    private int findRow(TableModel tableModel, Object object) {
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        int n;
        int n2;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        String string = null;
        Relation relation = null;
        if (this.propertyTable.getSelectedRowCount() == 1) {
            string = (String)this.propertyData.getValueAt(this.propertyTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            relation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.propertyData.setRowCount(0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.valueCount.clear();
        for (OsmPrimitive object2 : collection) {
            if (object2 instanceof Node) {
                ++n3;
            } else if (object2 instanceof Relation) {
                ++n5;
            } else if (((Way)object2).isClosed()) {
                ++n6;
            } else {
                ++n4;
            }
            for (String string2 : object2.keySet()) {
                String string3 = object2.get(string2);
                hashMap.put(string2, hashMap.containsKey(string2) ? (Integer)hashMap.get(string2) + 1 : 1);
                if (this.valueCount.containsKey(string2)) {
                    object.put((Object)string3, (object = this.valueCount.get(string2)).containsKey(string3) ? (Integer)object.get(string3) + 1 : 1);
                    continue;
                }
                object = new TreeMap<String, Integer>();
                ((TreeMap)object).put(string3, 1);
                this.valueCount.put(string2, (Map<String, Integer>)object);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var11_18;
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                var11_18 += ((Integer)entry2.getValue()).intValue();
            }
            if (var11_18 < collection.size()) {
                ((Map)entry.getValue()).put("", collection.size() - var11_18);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.membershipData.setRowCount(0);
        HashMap hashMap2 = new HashMap();
        for (OsmPrimitive osmPrimitive : collection) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isFiltered() || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                object = (Relation)osmPrimitive2;
                for (RelationMember relationMember : ((Relation)object).getMembers()) {
                    if (relationMember.getMember() != osmPrimitive) continue;
                    HashSet<RelationMember> hashSet = (HashSet<RelationMember>)hashMap2.get(object);
                    if (hashSet == null) {
                        hashSet = new HashSet<RelationMember>();
                        hashMap2.put(object, hashSet);
                    }
                    hashSet.add(relationMember);
                }
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.membershipData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.checkPresets(n3, n4, n5, n6);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !collection.isEmpty();
        boolean bl2 = bl && this.propertyData.getRowCount() > 0;
        boolean bl3 = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl2 || bl3);
        this.btnDel.setEnabled(bl2 || bl3);
        this.propertyTable.setVisible(bl);
        this.propertyTable.getTableHeader().setVisible(bl);
        this.selectSth.setVisible(!bl);
        if (string != null && (n2 = this.findRow(this.propertyData, string)) != -1) {
            this.propertyTable.changeSelection(n2, 0, false, false);
        } else if (relation != null && (n = this.findRow(this.membershipData, relation)) != -1) {
            this.membershipTable.changeSelection(n, 0, false, false);
        } else if (bl2) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (bl3) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships"));
        }
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateSelection();
    }

    static class SelectRelationAction
    extends AbstractAction {
        boolean selectionmode;
        Relation relation;

        public SelectRelationAction(Relation relation, boolean bl) {
            this.selectionmode = bl;
            this.relation = relation;
            if (bl) {
                this.putValue("Name", I18n.tr("Select relation"));
                this.putValue("ShortDescription", I18n.tr("Select relation in main selection."));
            } else {
                this.putValue("Name", I18n.tr("Select in relation list"));
                this.putValue("ShortDescription", I18n.tr("Select relation in relation list."));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.selectionmode) {
                Main.map.mapView.getEditLayer().data.setSelected(this.relation);
            } else {
                Main.map.relationListDialog.selectRelation(this.relation);
            }
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the value of the selected key for all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                PropertiesDialog.this.propertyEdit(n);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.membershipEdit(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1 ^ PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
            this.putValue("ShortDescription", I18n.tr("Add a new key/value pair to all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesDialog.this.add();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        protected void deleteProperty(int n) {
            String string = PropertiesDialog.this.propertyData.getValueAt(n, 0).toString();
            String string2 = null;
            int n2 = PropertiesDialog.this.propertyData.getRowCount();
            if (n2 > 1) {
                string2 = (String)PropertiesDialog.this.propertyData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, null));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (string2 != null) {
                PropertiesDialog.this.propertyTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.propertyData, string2), 0, false, false);
            }
        }

        protected void deleteFromRelation(int n) {
            Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
            Relation relation2 = null;
            int n2 = PropertiesDialog.this.membershipTable.getRowCount();
            if (n2 > 1) {
                relation2 = (Relation)PropertiesDialog.this.membershipData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
            extendedDialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("Really delete selection from relation {0}?", relation.getDisplayName(DefaultNameFormatter.getInstance())));
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return;
            }
            Relation relation3 = new Relation(relation);
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                relation3.removeMembersFor(osmPrimitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(relation, relation3));
            PropertiesDialog.this.propertyTable.clearSelection();
            if (relation2 != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, relation2), 0, false, false);
            }
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected key in all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            Shortcut shortcut = Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties"), 81, 6);
            this.putValue("MnemonicKey", KeyEvent.getKeyText(shortcut.getAssignedKey()).charAt(0));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                this.deleteProperty(n);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                this.deleteFromRelation(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0 || PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    public class DblClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.propertyEdit(n);
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.membershipEdit(n);
                }
            } else {
                PropertiesDialog.this.add();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.propertyTable.clearSelection();
            }
        }
    }
}

