/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private TagEditorPanel pnlTagEditor;
    private ChangesetCommentModel changesetCommentModel;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.pnlTagEditor = new TagEditorPanel();
        this.add((Component)this.pnlTagEditor, "Center");
    }

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetCommentModel.addObserver(new ChangesetCommentObserver());
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected String getDefaultCreatedBy() {
        Object object = System.getProperties().get("http.agent");
        return object == null ? "JOSM" : object.toString();
    }

    protected void setUploadComment(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).equals(string2 = this.getUploadComment())) {
            return;
        }
        if (string.equals("")) {
            this.pnlTagEditor.getModel().delete("comment");
            return;
        }
        TagModel tagModel = this.pnlTagEditor.getModel().get("comment");
        if (tagModel == null) {
            tagModel = new TagModel("comment", string);
            this.pnlTagEditor.getModel().add(tagModel);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tagModel, string);
        }
    }

    protected String getUploadComment() {
        TagModel tagModel = this.pnlTagEditor.getModel().get("comment");
        if (tagModel == null) {
            return null;
        }
        return tagModel.getValue();
    }

    protected void initNewChangeset() {
        String string = this.getUploadComment();
        this.pnlTagEditor.getModel().clear();
        if (string != null) {
            this.pnlTagEditor.getModel().add("comment", string);
        }
        this.pnlTagEditor.getModel().add("created_by", this.getDefaultCreatedBy());
    }

    protected void initFromExistingChangeset(Changeset changeset) {
        String string = this.getUploadComment();
        Map<String, String> map = changeset.getKeys();
        if (map.get("comment") == null) {
            map.put("comment", string);
        }
        map.put("created_by", this.getDefaultCreatedBy());
        this.pnlTagEditor.getModel().initFromTags(map);
    }

    public void initFromChangeset(Changeset changeset) {
        if (changeset == null) {
            this.initNewChangeset();
        } else {
            this.initFromExistingChangeset(changeset);
        }
    }

    public Map<String, String> getTags() {
        return this.pnlTagEditor.getModel().getTags();
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(Main.main.getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        String string = this.getUploadComment();
        this.changesetCommentModel.setComment(string);
    }

    class ChangesetCommentObserver
    implements Observer {
        ChangesetCommentObserver() {
        }

        public void update(Observable observable, Object object) {
            if (!(observable instanceof ChangesetCommentModel)) {
                return;
            }
            String string = (String)object;
            String string2 = TagSettingsPanel.this.getUploadComment();
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.equals(string)) {
                TagSettingsPanel.this.setUploadComment((String)object);
            }
        }
    }
}

