/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageLayer
extends Layer
implements PropertyChangeListener {
    List<ImageEntry> data;
    GpxLayer gpxLayer;
    private Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private int currentPhoto = -1;
    boolean useThumbs = false;
    ThumbsLoader thumbsloader;
    boolean thumbsLoaded = false;
    private BufferedImage offscreenBuffer;
    boolean updateOffscreenBuffer = true;
    private static List<LayerMenuAddition> menuAdditions = new LinkedList<LayerMenuAddition>();
    private MouseAdapter mouseAdapter = null;
    private MapFrame.MapModeChangeListener mapModeListener = null;

    public static void create(Collection<File> collection, GpxLayer gpxLayer) {
        Loader loader = new Loader(collection, gpxLayer);
        Main.worker.execute(loader);
    }

    private GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer) {
        super(I18n.tr("Geotagged Images"));
        Collections.sort(list);
        this.data = list;
        this.gpxLayer = gpxLayer;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage");
    }

    public static void registerMenuAddition(LayerMenuAddition layerMenuAddition) {
        menuAdditions.add(layerMenuAddition);
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Correlate to GPX"), ImageProvider.get("dialogs/geoimage/gpx2img"));
        jMenuItem.addActionListener(new CorrelateGpxWithImages(this));
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)));
        arrayList.add(new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)));
        arrayList.add(new JMenuItem(new RenameLayerAction(null, this)));
        arrayList.add(new JSeparator());
        arrayList.add(jMenuItem);
        if (!menuAdditions.isEmpty()) {
            arrayList.add(new JSeparator());
        }
        for (LayerMenuAddition layerMenuAddition : menuAdditions) {
            arrayList.add(layerMenuAddition.getComponent(this));
        }
        arrayList.add(new JSeparator());
        arrayList.add(new JMenuItem(new LayerListPopup.InfoAction(this)));
        return arrayList.toArray(new Component[0]);
    }

    private String infoText() {
        int n = 0;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.getPos() == null) continue;
            ++n;
        }
        return I18n.trn("{0} image loaded.", "{0} images loaded.", this.data.size(), this.data.size()) + " " + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", n, n);
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        GeoImageLayer geoImageLayer = (GeoImageLayer)layer;
        ImageEntry imageEntry = null;
        if (geoImageLayer.currentPhoto >= 0) {
            imageEntry = geoImageLayer.data.get(geoImageLayer.currentPhoto);
        }
        this.data.addAll(geoImageLayer.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry imageEntry2 = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry imageEntry3 = this.data.get(i);
                if (imageEntry3.getFile().equals(imageEntry2.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                imageEntry2 = imageEntry3;
            }
        }
        if (imageEntry != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) != imageEntry) continue;
                this.currentPhoto = i;
                ImageViewerDialog.showImage(this, this.data.get(i));
                break;
            }
        }
        this.setName(geoImageLayer.getName());
    }

    private Dimension scaledDimension(Image image) {
        double d = Main.map.mapView.getDist100Pixel();
        double d2 = 1000.0 / d;
        if (d2 < 22.0) {
            d2 = 22.0;
        }
        if (d2 > 120.0) {
            d2 = 120.0;
        }
        double d3 = d2 / 120.0;
        if (image == null) {
            return null;
        }
        return new Dimension((int)Math.round(d3 * (double)image.getWidth(null)), (int)Math.round(d3 * (double)image.getHeight(null)));
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        Object object2;
        Object object3;
        int n = Main.map.mapView.getWidth();
        int n2 = Main.map.mapView.getHeight();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.useThumbs) {
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != n || this.offscreenBuffer.getHeight() != n2) {
                this.offscreenBuffer = new BufferedImage(n, n2, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                object3 = this.offscreenBuffer.createGraphics();
                ((Graphics)object3).setColor(new Color(0, 0, 0, 0));
                object2 = ((Graphics2D)object3).getComposite();
                ((Graphics2D)object3).setComposite(AlphaComposite.Clear);
                ((Graphics)object3).fillRect(0, 0, n, n2);
                ((Graphics2D)object3).setComposite((Composite)object2);
                for (ImageEntry imageEntry : this.data) {
                    if (imageEntry.getPos() == null) continue;
                    Point point = mapView.getPoint(imageEntry.getPos());
                    if (imageEntry.thumbnail != null) {
                        Dimension dimension = this.scaledDimension(imageEntry.thumbnail);
                        Rectangle rectangle2 = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                        if (!rectangle.intersects(rectangle2)) continue;
                        ((Graphics)object3).drawImage(imageEntry.thumbnail, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                        continue;
                    }
                    this.icon.paintIcon(mapView, (Graphics)object3, point.x - this.icon.getIconWidth() / 2, point.y - this.icon.getIconHeight() / 2);
                }
                this.updateOffscreenBuffer = false;
            }
            graphics2D.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            object3 = this.data.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (((ImageEntry)object2).getPos() == null) continue;
                object = mapView.getPoint(((ImageEntry)object2).getPos());
                this.icon.paintIcon(mapView, graphics2D, ((Point)object).x - this.icon.getIconWidth() / 2, ((Point)object).y - this.icon.getIconHeight() / 2);
            }
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size() && ((ImageEntry)(object3 = this.data.get(this.currentPhoto))).getPos() != null) {
            object2 = mapView.getPoint(((ImageEntry)object3).getPos());
            if (((ImageEntry)object3).thumbnail != null) {
                object = this.scaledDimension(((ImageEntry)object3).thumbnail);
                graphics2D.setColor(new Color(128, 0, 0, 122));
                graphics2D.fillRect(((Point)object2).x - ((Dimension)object).width / 2, ((Point)object2).y - ((Dimension)object).height / 2, ((Dimension)object).width, ((Dimension)object).height);
            } else {
                this.selectedIcon.paintIcon(mapView, graphics2D, ((Point)object2).x - this.selectedIcon.getIconWidth() / 2, ((Point)object2).y - this.selectedIcon.getIconHeight() / 2);
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.getPos());
        }
    }

    private static void extractExif(ImageEntry imageEntry) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(imageEntry.getFile());
            Directory directory = metadata.getDirectory(GpsDirectory.class);
            Rational[] rationalArray = directory.getRationalArray(4);
            int n = rationalArray[0].intValue();
            double d = rationalArray[1].floatValue();
            double d2 = rationalArray[2].floatValue();
            double d3 = (double)n + d / 60.0 + d2 / 3600.0;
            if (directory.getString(3).charAt(0) == 'W') {
                d3 = -d3;
            }
            rationalArray = directory.getRationalArray(2);
            n = rationalArray[0].intValue();
            d = rationalArray[1].floatValue();
            d2 = rationalArray[2].floatValue();
            double d4 = (double)n + d / 60.0 + d2 / 3600.0;
            if (directory.getString(1).charAt(0) == 'S') {
                d4 = -d4;
            }
            imageEntry.setExifCoor(new LatLon(d4, d3));
            imageEntry.setPos(imageEntry.getExifCoor());
        }
        catch (CompoundException compoundException) {
            imageEntry.setExifCoor(null);
            imageEntry.setPos(null);
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && this.data.size() > 0) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void checkPreviousNextButtons() {
        ImageViewerDialog.setNextEnabled(this.currentPhoto < this.data.size() - 1);
        ImageViewerDialog.setPreviousEnabled(this.currentPhoto > 0);
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                ImageViewerDialog.showImage(this, null);
            }
            this.updateOffscreenBuffer = true;
            Main.map.repaint();
        }
    }

    public void removeCurrentPhotoFromDisk() {
        ImageEntry imageEntry = null;
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            imageEntry = this.data.get(this.currentPhoto);
            int n = new ExtendedDialog(Main.parent, I18n.tr("Delete image file from disk"), new String[]{I18n.tr("Cancel"), I18n.tr("Delete")}).setButtonIcons(new String[]{"cancel.png", "dialogs/delete.png"}).setContent(new JLabel(I18n.tr("<html><h3>Delete the file {0} from disk?<p>The image file will be permanently lost!</h3></html>", imageEntry.getFile().getName()), ImageProvider.get("dialogs/geoimage/deletefromdisk"), 2)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
            if (n == 2) {
                this.data.remove(this.currentPhoto);
                if (this.currentPhoto >= this.data.size()) {
                    this.currentPhoto = this.data.size() - 1;
                }
                if (this.currentPhoto >= 0) {
                    ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
                } else {
                    ImageViewerDialog.showImage(this, null);
                }
                if (imageEntry.getFile().delete()) {
                    System.out.println("File " + imageEntry.getFile().toString() + " deleted. ");
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image file could not be deleted."), I18n.tr("Error"), 0);
                }
                this.updateOffscreenBuffer = true;
                Main.map.repaint();
            }
        }
    }

    private void hook_up_mouse_events() {
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (!GeoImageLayer.this.isVisible()) {
                    return;
                }
                for (int i = GeoImageLayer.this.data.size() - 1; i >= 0; --i) {
                    Rectangle rectangle;
                    ImageEntry imageEntry = GeoImageLayer.this.data.get(i);
                    if (imageEntry.getPos() == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.getPos());
                    if (imageEntry.thumbnail != null) {
                        Dimension dimension = GeoImageLayer.this.scaledDimension(imageEntry.thumbnail);
                        rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                    } else {
                        rectangle = new Rectangle(point.x - GeoImageLayer.this.icon.getIconWidth() / 2, point.y - GeoImageLayer.this.icon.getIconHeight() / 2, GeoImageLayer.this.icon.getIconWidth(), GeoImageLayer.this.icon.getIconHeight());
                    }
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    GeoImageLayer.this.currentPhoto = i;
                    ImageViewerDialog.showImage(GeoImageLayer.this, imageEntry);
                    Main.map.repaint();
                    break;
                }
            }
        };
        this.mapModeListener = new MapFrame.MapModeChangeListener(){

            public void mapModeChange(MapMode mapMode, MapMode mapMode2) {
                if (mapMode2 instanceof SelectAction) {
                    Main.map.mapView.addMouseListener(GeoImageLayer.this.mouseAdapter);
                } else {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, Main.map.mapMode);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
                if (layer2 == GeoImageLayer.this) {
                    Main.map.selectSelectTool(false);
                }
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer == GeoImageLayer.this) {
                    if (GeoImageLayer.this.thumbsloader != null) {
                        GeoImageLayer.this.thumbsloader.stop = true;
                    }
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                    MapFrame.removeMapModeChangeListener(GeoImageLayer.this.mapModeListener);
                    GeoImageLayer.this.currentPhoto = -1;
                    GeoImageLayer.this.data.clear();
                    GeoImageLayer.this.data = null;
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("center".equals(propertyChangeEvent.getPropertyName()) || "scale".equals(propertyChangeEvent.getPropertyName())) {
            this.updateOffscreenBuffer = true;
        }
    }

    public void loadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded) {
            this.thumbsLoaded = true;
            this.thumbsloader = new ThumbsLoader(this);
            Thread thread = new Thread(this.thumbsloader);
            thread.setPriority(1);
            thread.start();
        }
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    public List<ImageEntry> getImages() {
        ArrayList<ImageEntry> arrayList = new ArrayList<ImageEntry>();
        for (ImageEntry imageEntry : this.data) {
            arrayList.add(imageEntry.clone());
        }
        return arrayList;
    }

    public static interface LayerMenuAddition {
        public Component getComponent(Layer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean cancelled = false;
        private GeoImageLayer layer;
        private Collection<File> selection;
        private HashSet<String> loadedDirectories = new HashSet();
        private LinkedHashSet<String> errorMessages;
        private GpxLayer gpxLayer;

        protected void rememberError(String string) {
            this.errorMessages.add(string);
        }

        public Loader(Collection<File> collection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF"));
            this.selection = collection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet();
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan"));
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                this.addRecursiveFiles(arrayList, this.selection);
            }
            catch (NullPointerException nullPointerException) {
                this.rememberError(I18n.tr("One of the selected files was null"));
            }
            if (this.cancelled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos..."));
            this.progressMonitor.setTicksCount(arrayList.size());
            this.progressMonitor.subTask(I18n.tr("Read photos..."));
            this.progressMonitor.setTicksCount(arrayList.size());
            ArrayList<ImageEntry> arrayList2 = new ArrayList<ImageEntry>(arrayList.size());
            for (File file : arrayList) {
                if (this.cancelled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", file.getName()));
                this.progressMonitor.worked(1);
                ImageEntry imageEntry = new ImageEntry();
                try {
                    imageEntry.setExifTime(ExifReader.readTime(file));
                }
                catch (ParseException parseException) {
                    imageEntry.setExifTime(null);
                }
                imageEntry.setFile(file);
                GeoImageLayer.extractExif(imageEntry);
                arrayList2.add(imageEntry);
            }
            this.layer = new GeoImageLayer(arrayList2, this.gpxLayer);
            arrayList.clear();
        }

        private void addRecursiveFiles(Collection<File> collection, Collection<File> collection2) {
            boolean bl = false;
            for (File file : collection2) {
                if (this.cancelled) break;
                if (file == null) {
                    bl = true;
                    continue;
                }
                if (file.isDirectory()) {
                    String string = null;
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", file.getAbsolutePath()));
                    }
                    if (string == null || this.loadedDirectories.contains(string)) continue;
                    this.loadedDirectories.add(string);
                    List<File> list = Arrays.asList(file.listFiles(JpegFileFilter.getInstance()));
                    if (list != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", file.getPath()));
                        try {
                            this.addRecursiveFiles(collection, list);
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            this.rememberError(I18n.tr("Found null file in directory {0}\n", file.getPath()));
                        }
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", file.getPath()));
                    continue;
                }
                collection.add(file);
            }
            if (bl) {
                throw new NullPointerException();
            }
        }

        protected String formatErrorMessages() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            if (this.errorMessages.size() == 1) {
                stringBuffer.append((String)this.errorMessages.iterator().next());
            } else {
                stringBuffer.append("<ul>");
                for (String string : this.errorMessages) {
                    stringBuffer.append("<li>").append(string).append("</li>");
                }
                stringBuffer.append("/ul>");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, this.formatErrorMessages(), I18n.tr("Error"), 0);
            }
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
                this.layer.hook_up_mouse_events();
                Main.map.mapView.addPropertyChangeListener(this.layer);
                if (Main.map.getToggleDialog(ImageViewerDialog.class) == null) {
                    System.err.println("JO");
                    ImageViewerDialog.newInstance();
                    Main.map.addToggleDialog(ImageViewerDialog.getInstance());
                }
                if (!this.cancelled && this.layer.data.size() > 0) {
                    boolean bl = true;
                    for (ImageEntry imageEntry : this.layer.data) {
                        if (imageEntry.getPos() == null) continue;
                        bl = false;
                    }
                    if (bl) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }
    }
}

