/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.util.logging.Logger;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OAuthAccessTokenHolder {
    private static final Logger logger = Logger.getLogger(OAuthAccessTokenHolder.class.getName());
    private static OAuthAccessTokenHolder instance;
    private boolean saveToPreferences;
    private String accessTokenKey;
    private String accessTokenSecret;

    public static OAuthAccessTokenHolder getInstance() {
        if (instance == null) {
            instance = new OAuthAccessTokenHolder();
        }
        return instance;
    }

    public boolean isSaveToPreferences() {
        return this.saveToPreferences;
    }

    public void setSaveToPreferences(boolean bl) {
        this.saveToPreferences = bl;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String string) {
        this.accessTokenKey = string;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String string) {
        this.accessTokenSecret = string;
    }

    public OAuthToken getAccessToken() {
        if (!this.containsAccessToken()) {
            return null;
        }
        return new OAuthToken(this.accessTokenKey, this.accessTokenSecret);
    }

    public void setAccessToken(String string, String string2) {
        this.accessTokenKey = string;
        this.accessTokenSecret = string2;
    }

    public void setAccessToken(OAuthToken oAuthToken) {
        if (oAuthToken == null) {
            this.accessTokenKey = null;
            this.accessTokenSecret = null;
        } else {
            this.accessTokenKey = oAuthToken.getKey();
            this.accessTokenSecret = oAuthToken.getSecret();
        }
    }

    public boolean containsAccessToken() {
        return this.accessTokenKey != null && this.accessTokenSecret != null;
    }

    public void init(Preferences preferences, CredentialsManager credentialsManager) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        CheckParameterUtil.ensureParameterNotNull(credentialsManager, "cm");
        OAuthToken oAuthToken = null;
        try {
            oAuthToken = credentialsManager.lookupOAuthAccessToken();
        }
        catch (CredentialsManagerException credentialsManagerException) {
            credentialsManagerException.printStackTrace();
            System.err.println(I18n.tr("Warning: Failed to retrieve OAuth Access Token from credential manager"));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
        }
        this.saveToPreferences = preferences.getBoolean("oauth.access-token.save-to-preferences", true);
        if (oAuthToken != null) {
            this.accessTokenKey = oAuthToken.getKey();
            this.accessTokenSecret = oAuthToken.getSecret();
        }
    }

    public void save(Preferences preferences, CredentialsManager credentialsManager) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(preferences, "preferences");
        CheckParameterUtil.ensureParameterNotNull(credentialsManager, "cm");
        preferences.put("oauth.access-token.save-to-preferences", this.saveToPreferences);
        try {
            if (!this.saveToPreferences) {
                credentialsManager.storeOAuthAccessToken(null);
            } else {
                credentialsManager.storeOAuthAccessToken(new OAuthToken(this.accessTokenKey, this.accessTokenSecret));
            }
        }
        catch (CredentialsManagerException credentialsManagerException) {
            credentialsManagerException.printStackTrace();
            System.err.println(I18n.tr("Warning: Failed to store OAuth Access Token to credentials manager"));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
        }
    }

    public void clear() {
        this.accessTokenKey = null;
        this.accessTokenSecret = null;
    }
}

