/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagEditorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TagEditorPanel.class.getName());
    private TagEditorModel model;
    private TagTable tagTable;
    private AutoCompletionCache acCache;
    private AutoCompletionList acList;

    protected JPanel buildTagTableEditorPanel() {
        JPanel jPanel = new JPanel();
        this.tagTable = new TagTable(this.model);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tagTable), "Center");
        return jPanel;
    }

    protected JPanel buildButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton(this.tagTable.getAddAction());
        jPanel.add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(jButton);
        jButton = new JButton(this.tagTable.getDeleteAction());
        jPanel.add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(jButton);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.buildTagTableEditorPanel();
        JPanel jPanel2 = this.buildButtonsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public TagEditorPanel() {
        this((TagEditorModel)null);
    }

    public TagEditorPanel(TagEditorModel tagEditorModel) {
        this.model = tagEditorModel;
        if (this.model == null) {
            this.model = new TagEditorModel();
        }
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer osmDataLayer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.acCache = AutoCompletionCache.getCacheForLayer(osmDataLayer);
        this.acCache.initFromDataSet();
        this.acList = new AutoCompletionList();
        TagCellEditor tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
        tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
    }

    public void setEnabled(boolean bl) {
        this.tagTable.setEnabled(bl);
        super.setEnabled(bl);
    }
}

