/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionCache {
    private static final Logger logger = Logger.getLogger(AutoCompletionCache.class.getName());
    private static HashMap<OsmDataLayer, AutoCompletionCache> caches = new HashMap();
    private MultiMap<String, String> tagCache = new MultiMap();
    private OsmDataLayer layer;
    private static MultiMap<String, String> presetTagCache;
    private Set<String> roleCache = new HashSet<String>();

    public static AutoCompletionCache getCacheForLayer(OsmDataLayer osmDataLayer) {
        AutoCompletionCache autoCompletionCache = caches.get(osmDataLayer);
        if (autoCompletionCache == null) {
            autoCompletionCache = new AutoCompletionCache(osmDataLayer);
            caches.put(osmDataLayer, autoCompletionCache);
        }
        return autoCompletionCache;
    }

    public AutoCompletionCache(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public AutoCompletionCache() {
        this(null);
    }

    protected void cachePrimitive(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.tagCache.put(string, string2);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.hasRole() || this.roleCache.contains(relationMember.getRole())) continue;
            this.roleCache.add(relationMember.getRole());
        }
    }

    public void initFromDataSet() {
        this.tagCache = new MultiMap();
        if (this.layer == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.layer.data.allNonDeletedPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            this.cachePrimitive(osmPrimitive);
        }
        for (Relation relation : this.layer.data.getRelations()) {
            if (relation.isIncomplete() || relation.isDeleted()) continue;
            this.cacheRelationMemberRoles(relation);
        }
    }

    public static void cachePresets(Collection<TaggingPreset> collection) {
        for (TaggingPreset taggingPreset : collection) {
            for (TaggingPreset.Item item : taggingPreset.data) {
                TaggingPreset.Item item2;
                if (item instanceof TaggingPreset.Check) {
                    item2 = (TaggingPreset.Check)item;
                    if (item2.key == null) continue;
                    presetTagCache.put(item2.key, "no");
                    presetTagCache.put(item2.key, "yes");
                    continue;
                }
                if (item instanceof TaggingPreset.Combo) {
                    item2 = (TaggingPreset.Combo)item;
                    if (((TaggingPreset.Combo)item2).key == null || ((TaggingPreset.Combo)item2).values == null) continue;
                    for (String string : ((TaggingPreset.Combo)item2).values.split(",")) {
                        presetTagCache.put(((TaggingPreset.Combo)item2).key, string);
                    }
                    continue;
                }
                if (item instanceof TaggingPreset.Key) {
                    item2 = (TaggingPreset.Key)item;
                    if (((TaggingPreset.Key)item2).key == null || ((TaggingPreset.Key)item2).value == null) continue;
                    presetTagCache.put(((TaggingPreset.Key)item2).key, ((TaggingPreset.Key)item2).value);
                    continue;
                }
                if (!(item instanceof TaggingPreset.Text)) continue;
                item2 = (TaggingPreset.Text)item;
                if (((TaggingPreset.Text)item2).key == null) continue;
                presetTagCache.putVoid(((TaggingPreset.Text)item2).key);
                if (((TaggingPreset.Text)item2).default_ == null || ((TaggingPreset.Text)item2).default_.equals("")) continue;
                presetTagCache.put(((TaggingPreset.Text)item2).key, ((TaggingPreset.Text)item2).default_);
            }
        }
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.tagCache.keySet());
    }

    protected List<String> getPresetKeys() {
        return new ArrayList<String>(presetTagCache.keySet());
    }

    protected List<String> getDataValues(String string) {
        return new ArrayList<String>(this.tagCache.getValues(string));
    }

    protected static List<String> getPresetValues(String string) {
        return new ArrayList<String>(presetTagCache.getValues(string));
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.roleCache);
    }

    public void populateWithMemberRoles(AutoCompletionList autoCompletionList) {
        autoCompletionList.clear();
        autoCompletionList.add(this.roleCache, AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, String string, boolean bl) {
        if (!bl) {
            autoCompletionList.clear();
        }
        autoCompletionList.add(this.getDataValues(string), AutoCompletionItemPritority.IS_IN_DATASET);
        autoCompletionList.add(AutoCompletionCache.getPresetValues(string), AutoCompletionItemPritority.IS_IN_STANDARD);
    }

    public void populateWithKeys(AutoCompletionList autoCompletionList, boolean bl) {
        if (!bl) {
            autoCompletionList.clear();
        }
        autoCompletionList.add(this.getDataKeys(), AutoCompletionItemPritority.IS_IN_DATASET);
        autoCompletionList.add(this.getPresetKeys(), AutoCompletionItemPritority.IS_IN_STANDARD);
    }

    static {
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer instanceof OsmDataLayer) {
                    caches.remove(layer);
                }
            }
        });
        presetTagCache = new MultiMap();
    }
}

