/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmReader {
    private static final Logger logger = Logger.getLogger(OsmReader.class.getName());
    private DataSet ds = new DataSet();
    private Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    private Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    private Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    private OsmReader() {
        this.externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Long l : this.ways.keySet()) {
            Way way = (Way)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.WAY));
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (long l2 : this.ways.get(l)) {
                Node node = (Node)this.externalIdMap.get(new SimplePrimitiveId(l2, OsmPrimitiveType.NODE));
                if (node == null) {
                    if (l2 <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", l, l2));
                    }
                    node = (Node)this.ds.getPrimitiveById(l2, OsmPrimitiveType.NODE);
                    if (node == null) {
                        node = new Node(l2);
                        this.ds.addPrimitive(node);
                    }
                }
                if (node.isDeleted()) {
                    logger.warning(I18n.tr("Deleted node {0} is part of way {1}", l2, way.getId()));
                    continue;
                }
                arrayList.add(node);
            }
            way.setNodes(arrayList);
            if (way.hasIncompleteNodes() && logger.isLoggable(Level.FINE)) {
                logger.fine(I18n.tr("Way {0} with {1} nodes has incomplete nodes because at least one node was missing in the loaded data.", l, way.getNodesCount()));
            }
            this.ds.addPrimitive(way);
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive osmPrimitive : this.externalIdMap.values()) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.ds.addPrimitive(osmPrimitive);
        }
    }

    private void processRelationsAfterParsing() throws IllegalDataException {
        Relation relation;
        for (Long l : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive(relation);
        }
        for (Long l : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMemberData relationMemberData : this.relations.get(l)) {
                OsmPrimitive osmPrimitive = null;
                osmPrimitive = this.externalIdMap.get(new SimplePrimitiveId(relationMemberData.id, relationMemberData.type));
                if (osmPrimitive == null) {
                    if (relationMemberData.id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", l, relationMemberData.id));
                    }
                    osmPrimitive = this.ds.getPrimitiveById(relationMemberData.id, relationMemberData.type);
                    if (osmPrimitive == null) {
                        switch (relationMemberData.type) {
                            case NODE: {
                                osmPrimitive = new Node(relationMemberData.id);
                                break;
                            }
                            case WAY: {
                                osmPrimitive = new Way(relationMemberData.id);
                                break;
                            }
                            case RELATION: {
                                osmPrimitive = new Relation(relationMemberData.id);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(osmPrimitive);
                        this.externalIdMap.put(new SimplePrimitiveId(relationMemberData.id, relationMemberData.type), osmPrimitive);
                    }
                }
                if (osmPrimitive.isDeleted()) {
                    logger.warning(I18n.tr("Deleted member {0} is used by relation {1}", osmPrimitive.getId(), relation.getId()));
                    continue;
                }
                arrayList.add(new RelationMember(relationMemberData.role, osmPrimitive));
            }
            relation.setMembers(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        OsmReader osmReader = new OsmReader();
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data..."));
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader2 = osmReader;
            osmReader2.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader2.new Parser());
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set..."));
            osmReader.ds.beginUpdate();
            try {
                osmReader.processNodesAfterParsing();
                osmReader.processWaysAfterParsing();
                osmReader.processRelationsAfterParsing();
            }
            finally {
                osmReader.ds.endUpdate();
            }
            progressMonitor.worked(1);
            DataSet dataSet = osmReader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException illegalDataException) {
            throw illegalDataException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalDataException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private OsmPrimitive currentPrimitive;
        private long currentExternalId;
        private String generator;
        private Storage<String> internedStrings = new Storage();

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        private String intern(String string) {
            String string2 = this.internedStrings.get(string);
            if (string2 == null) {
                this.internedStrings.put(string);
                return string;
            }
            return string2;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("osm")) {
                String string4;
                if (attributes == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                }
                if ((string4 = attributes.getValue("version")) == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                }
                if (!string4.equals("0.5") && !string4.equals("0.6")) {
                    this.throwException(I18n.tr("Unsupported version: {0}", string4));
                }
                this.generator = attributes.getValue("generator");
                OsmReader.this.ds.setVersion(string4);
            } else if (string3.equals("bounds")) {
                String string5 = attributes.getValue("minlon");
                String string6 = attributes.getValue("minlat");
                String string7 = attributes.getValue("maxlon");
                String string8 = attributes.getValue("maxlat");
                String string9 = attributes.getValue("origin");
                if (string5 != null && string7 != null && string6 != null && string8 != null) {
                    if (string9 == null) {
                        string9 = this.generator;
                    }
                    Bounds bounds = new Bounds(new LatLon(Double.parseDouble(string6), Double.parseDouble(string5)), new LatLon(Double.parseDouble(string8), Double.parseDouble(string7)));
                    DataSource dataSource = new DataSource(bounds, string9);
                    ((OsmReader)OsmReader.this).ds.dataSources.add(dataSource);
                } else {
                    this.throwException(I18n.tr("Missing manadatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", string5, string6, string7, string8, string9));
                }
            } else if (string3.equals("node")) {
                NodeData nodeData = new NodeData();
                nodeData.setCoor(new LatLon(this.getDouble(attributes, "lat"), this.getDouble(attributes, "lon")));
                this.readCommon(attributes, nodeData);
                Node node = new Node(nodeData.getId(), nodeData.getVersion());
                node.load(nodeData);
                OsmReader.this.externalIdMap.put(nodeData.getPrimitiveId(), node);
                this.currentPrimitive = node;
                this.currentExternalId = nodeData.getUniqueId();
            } else if (string3.equals("way")) {
                WayData wayData = new WayData();
                this.readCommon(attributes, wayData);
                Way way = new Way(wayData.getId(), wayData.getVersion());
                way.load(wayData);
                OsmReader.this.externalIdMap.put(wayData.getPrimitiveId(), way);
                OsmReader.this.ways.put(wayData.getUniqueId(), new ArrayList());
                this.currentPrimitive = way;
                this.currentExternalId = wayData.getUniqueId();
            } else if (string3.equals("nd")) {
                long l;
                Collection collection = (Collection)OsmReader.this.ways.get(this.currentExternalId);
                if (collection == null) {
                    this.throwException(I18n.tr("Found XML element <nd> not as direct child of element <way>."));
                }
                if (attributes.getValue("ref") == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", this.currentPrimitive.getUniqueId()));
                }
                if ((l = this.getLong(attributes, "ref")) == 0L) {
                    this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", l));
                }
                if (this.currentPrimitive.isDeleted()) {
                    logger.info(I18n.tr("Deleted way {0} contains nodes", this.currentPrimitive.getUniqueId()));
                } else {
                    collection.add(l);
                }
            } else if (string3.equals("relation")) {
                RelationData relationData = new RelationData();
                this.readCommon(attributes, relationData);
                Relation relation = new Relation(relationData.getId(), relationData.getVersion());
                relation.load(relationData);
                OsmReader.this.externalIdMap.put(relationData.getPrimitiveId(), relation);
                OsmReader.this.relations.put(relationData.getUniqueId(), new LinkedList());
                this.currentPrimitive = relation;
                this.currentExternalId = relationData.getUniqueId();
            } else if (string3.equals("member")) {
                Collection collection = (Collection)OsmReader.this.relations.get(this.currentExternalId);
                if (collection == null) {
                    this.throwException(I18n.tr("Found XML element <member> not as direct child of element <relation>."));
                }
                RelationMemberData relationMemberData = new RelationMemberData();
                String string10 = attributes.getValue("ref");
                if (string10 == null) {
                    this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", this.currentPrimitive.getUniqueId()));
                }
                try {
                    relationMemberData.id = Long.parseLong(string10);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(this.currentPrimitive.getUniqueId()), string10));
                }
                string10 = attributes.getValue("type");
                if (string10 == null) {
                    this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(relationMemberData.id), Long.toString(this.currentPrimitive.getUniqueId())));
                }
                try {
                    relationMemberData.type = OsmPrimitiveType.fromApiTypeName(string10);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(relationMemberData.id), Long.toString(this.currentPrimitive.getUniqueId()), string10));
                }
                relationMemberData.role = string10 = attributes.getValue("role");
                if (relationMemberData.id == 0L) {
                    this.throwException(I18n.tr("Incomplete <member> specification with ref=0"));
                }
                if (this.currentPrimitive.isDeleted()) {
                    logger.info(I18n.tr("Deleted relation {0} contains members", this.currentPrimitive.getUniqueId()));
                } else {
                    collection.add(relationMemberData);
                }
            } else if (string3.equals("tag")) {
                String string11 = attributes.getValue("k");
                String string12 = attributes.getValue("v");
                this.currentPrimitive.put(this.intern(string11), this.intern(string12));
            } else {
                System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", string3));
            }
        }

        private double getDouble(Attributes attributes, String string) {
            return Double.parseDouble(attributes.getValue(string));
        }

        private User createUser(String string, String string2) throws SAXException {
            if (string == null) {
                if (string2 == null) {
                    return null;
                }
                return User.createLocalUser(string2);
            }
            try {
                long l = Long.parseLong(string);
                return User.createOsmUser(l, string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", string));
                return null;
            }
        }

        void readCommon(Attributes attributes, PrimitiveData primitiveData) throws SAXException {
            String string;
            String string2;
            primitiveData.setId(this.getLong(attributes, "id"));
            if (primitiveData.getUniqueId() == 0L) {
                this.throwException(I18n.tr("Illegal object with ID=0."));
            }
            if ((string2 = attributes.getValue("timestamp")) != null && string2.length() != 0) {
                primitiveData.setTimestamp(DateUtils.fromString(string2));
            }
            String string3 = attributes.getValue("user");
            String string4 = attributes.getValue("uid");
            primitiveData.setUser(this.createUser(string4, string3));
            String string5 = attributes.getValue("visible");
            if (string5 != null) {
                primitiveData.setVisible(Boolean.parseBoolean(string5));
            }
            String string6 = attributes.getValue("version");
            int n = 0;
            if (string6 != null) {
                try {
                    n = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
                }
                if (OsmReader.this.ds.getVersion().equals("0.6")) {
                    if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                        this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
                    } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.6"));
                        n = 0;
                    }
                } else if (OsmReader.this.ds.getVersion().equals("0.5")) {
                    if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
                        n = 1;
                    } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.5"));
                        n = 0;
                    }
                } else {
                    this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", OsmReader.this.ds.getVersion()));
                }
            } else if (primitiveData.getUniqueId() > 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.6")) {
                this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(primitiveData.getUniqueId())));
            } else if (primitiveData.getUniqueId() > 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.5")) {
                System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
                n = 1;
            } else if (primitiveData.getUniqueId() <= 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.5")) {
                n = 0;
            }
            primitiveData.setVersion(n);
            String string7 = attributes.getValue("action");
            if (string7 != null) {
                if (string7.equals("delete")) {
                    primitiveData.setDeleted(true);
                    primitiveData.setModified(true);
                } else if (string7.equals("modify")) {
                    primitiveData.setModified(true);
                }
            }
            if ((string = attributes.getValue("changeset")) == null) {
                primitiveData.setChangesetId(0);
            } else {
                try {
                    primitiveData.setChangesetId(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (primitiveData.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                        primitiveData.setChangesetId(0);
                    }
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
                }
                if (primitiveData.getChangesetId() <= 0) {
                    if (primitiveData.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                        primitiveData.setChangesetId(0);
                    } else {
                        this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
                    }
                }
            }
        }

        private long getLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing required attribute ''{0}''.", string));
            }
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", string, string2));
                return 0L;
            }
        }
    }

    private static class RelationMemberData {
        public OsmPrimitiveType type;
        public long id;
        public String role;

        private RelationMemberData() {
        }
    }
}

