/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final Logger log = Logger.getLogger(OsmFileCacheTileLoader.class.getName());
    private static final String ETAG_FILE_EXT = ".etag";
    private static final Charset ETAG_CHARSET = Charset.forName("UTF-8");
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String cacheDirBase;
    protected long maxCacheFileAge = 604800000L;
    protected long recheckAfter = 86400000L;

    public OsmFileCacheTileLoader(TileLoaderListener tileLoaderListener, File file) throws SecurityException {
        super(tileLoaderListener);
        String string = null;
        String string2 = System.getProperty("user.name");
        try {
            string = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException securityException) {
            log.log(Level.WARNING, "Failed to access system property ''java.io.tmpdir'' for security reasons. Exception was: " + securityException.toString());
            throw securityException;
        }
        try {
            if (file == null) {
                if (string == null) {
                    throw new IOException("No temp directory set");
                }
                String string3 = "JMapViewerTiles";
                if (string2 != null && string2.length() > 0) {
                    string3 = string3 + "_" + string2;
                }
                file = new File(string, string3);
            }
            log.finest("Tile cache directory: " + file);
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException();
            }
            this.cacheDirBase = file.getAbsolutePath();
        }
        catch (Exception exception) {
            this.cacheDirBase = "tiles";
        }
    }

    public OsmFileCacheTileLoader(TileLoaderListener tileLoaderListener) throws SecurityException {
        this(tileLoaderListener, null);
    }

    public Runnable createTileLoaderJob(TileSource tileSource, int n, int n2, int n3) {
        return new FileLoadJob(tileSource, n, n2, n3);
    }

    public long getMaxFileAge() {
        return this.maxCacheFileAge;
    }

    public void setCacheMaxFileAge(long l) {
        this.maxCacheFileAge = l;
    }

    public String getCacheDirBase() {
        return this.cacheDirBase;
    }

    public void setTileCacheDir(String string) {
        File file = new File(string);
        file.mkdirs();
        this.cacheDirBase = file.getAbsolutePath();
    }

    protected class FileLoadJob
    implements Runnable {
        InputStream input = null;
        int tilex;
        int tiley;
        int zoom;
        Tile tile;
        TileSource source;
        File tileCacheDir;
        File tileFile = null;
        long fileAge = 0L;
        boolean fileTilePainted = false;

        public FileLoadJob(TileSource tileSource, int n, int n2, int n3) {
            this.source = tileSource;
            this.tilex = n;
            this.tiley = n2;
            this.zoom = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TileCache tileCache = OsmFileCacheTileLoader.this.listener.getTileCache();
            Object object = tileCache;
            synchronized (object) {
                this.tile = tileCache.getTile(this.source, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.isLoaded() || this.tile.loading) {
                    return;
                }
                this.tile.loading = true;
            }
            this.tileCacheDir = new File(OsmFileCacheTileLoader.this.cacheDirBase, this.source.getName());
            if (!this.tileCacheDir.exists()) {
                this.tileCacheDir.mkdirs();
            }
            if (this.loadTileFromFile()) {
                return;
            }
            if (this.fileTilePainted) {
                object = new Runnable(){

                    public void run() {
                        FileLoadJob.this.loadOrUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob((Runnable)object);
            } else {
                this.loadOrUpdateTile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadOrUpdateTile() {
            try {
                Object object;
                HttpURLConnection httpURLConnection = OsmFileCacheTileLoader.this.loadTileFromOsm(this.tile);
                if (this.tileFile != null) {
                    switch (this.source.getTileUpdate()) {
                        case IfModifiedSince: {
                            httpURLConnection.setIfModifiedSince(this.fileAge);
                            break;
                        }
                        case LastModified: {
                            if (this.isOsmTileNewer(this.fileAge)) break;
                            log.finest("LastModified test: local version is up to date: " + this.tile);
                            this.tile.setLoaded(true);
                            this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                            return;
                        }
                    }
                }
                if (this.source.getTileUpdate() == TileSource.TileUpdate.ETag || this.source.getTileUpdate() == TileSource.TileUpdate.IfNoneMatch) {
                    if (this.tileFile != null && (object = this.loadETagfromFile()) != null) {
                        switch (this.source.getTileUpdate()) {
                            case IfNoneMatch: {
                                httpURLConnection.addRequestProperty("If-None-Match", (String)object);
                                break;
                            }
                            case ETag: {
                                if (!this.hasOsmTileETag((String)object)) break;
                                this.tile.setLoaded(true);
                                this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                                return;
                            }
                        }
                    }
                    object = httpURLConnection.getHeaderField("ETag");
                    this.saveETagToFile((String)object);
                }
                if (httpURLConnection.getResponseCode() == 304) {
                    log.finest("ETag test: local version is up to date: " + this.tile);
                    this.tile.setLoaded(true);
                    this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                    return;
                }
                object = this.loadTileInBuffer(httpURLConnection);
                if (object != null) {
                    this.tile.loadImage(new ByteArrayInputStream((byte[])object));
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                    this.saveTileToFile((byte[])object);
                } else {
                    this.tile.setLoaded(true);
                }
            }
            catch (Exception exception) {
                this.tile.setImage(Tile.ERROR_IMAGE);
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, false);
                if (this.input == null) {
                    System.err.println("failed loading " + this.zoom + "/" + this.tilex + "/" + this.tiley + " " + exception.getMessage());
                }
            }
            finally {
                this.tile.loading = false;
                this.tile.setLoaded(true);
            }
        }

        protected boolean loadTileFromFile() {
            FileInputStream fileInputStream = null;
            try {
                boolean bl;
                this.tileFile = this.getTileFile();
                fileInputStream = new FileInputStream(this.tileFile);
                if (fileInputStream.available() == 0) {
                    throw new IOException("File empty");
                }
                this.tile.loadImage(fileInputStream);
                fileInputStream.close();
                this.fileAge = this.tileFile.lastModified();
                boolean bl2 = bl = System.currentTimeMillis() - this.fileAge > OsmFileCacheTileLoader.this.maxCacheFileAge;
                if (!bl) {
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                    this.fileTilePainted = true;
                    return true;
                }
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                this.fileTilePainted = true;
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        this.tileFile.delete();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.tileFile = null;
                this.fileAge = 0L;
            }
            return false;
        }

        protected byte[] loadTileInBuffer(URLConnection uRLConnection) throws IOException {
            this.input = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.input.available());
            byte[] byArray = new byte[2048];
            boolean bl = false;
            do {
                int n;
                if ((n = this.input.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    continue;
                }
                bl = true;
            } while (!bl);
            if (byteArrayOutputStream.size() == 0) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected boolean isOsmTileNewer(long l) throws IOException {
            URL uRL = new URL(this.tile.getUrl());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(httpURLConnection);
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setReadTimeout(30000);
            long l2 = httpURLConnection.getLastModified();
            if (l2 == 0L) {
                return true;
            }
            return l2 > l;
        }

        protected boolean hasOsmTileETag(String string) throws IOException {
            URL uRL = new URL(this.tile.getUrl());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(httpURLConnection);
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setReadTimeout(30000);
            String string2 = httpURLConnection.getHeaderField("ETag");
            if (string2 == null) {
                return true;
            }
            return string2.equals(string);
        }

        protected File getTileFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
        }

        protected void saveTileToFile(byte[] byArray) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Failed to save tile content: " + exception.getLocalizedMessage());
            }
        }

        protected void saveETagToFile(String string) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
                fileOutputStream.write(string.getBytes(ETAG_CHARSET.name()));
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Failed to save ETag: " + exception.getLocalizedMessage());
            }
        }

        protected String loadETagfromFile() {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                return new String(byArray, ETAG_CHARSET.name());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

