/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected Shortcut sc;
    private LayerChangeAdapter layerChangeAdapter;
    private SelectionChangeAdapter selectionChangeAdapter;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut"), 0, 0);
        }
        return this.sc;
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2 == null ? null : ImageProvider.get(string2));
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.contentPane.getInputMap(2).put(this.sc.getKeyStroke(), string);
            Main.contentPane.getActionMap().put(string, this);
        }
        this.putValue("ShortDescription", Main.platform.makeTooltip(string3, this.sc));
        this.putValue("toolbar", string2);
        if (bl) {
            Main.toolbar.register(this);
        }
        this.installAdapters();
    }

    public JosmAction() {
        this.setHelpId();
        this.installAdapters();
    }

    @Override
    public void destroy() {
        if (this.sc != null) {
            Main.contentPane.getInputMap(2).remove(this.sc.getKeyStroke());
            Main.contentPane.getActionMap().remove(this.sc.getKeyStroke());
        }
        MapView.removeLayerChangeListener(this.layerChangeAdapter);
        DataSet.selListeners.remove(this.selectionChangeAdapter);
    }

    public void pasteBufferChanged(PrimitiveDeepCopy primitiveDeepCopy) {
    }

    public void addListener(JosmAction josmAction) {
    }

    private void setHelpId() {
        String string = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        this.putValue("help", string);
    }

    protected OsmDataLayer getEditLayer() {
        return Main.main.getEditLayer();
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    protected void installAdapters() {
        this.layerChangeAdapter = new LayerChangeAdapter();
        this.selectionChangeAdapter = new SelectionChangeAdapter();
        MapView.addLayerChangeListener(this.layerChangeAdapter);
        DataSet.selListeners.add(this.selectionChangeAdapter);
        this.initEnabledState();
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionChangeAdapter
    implements SelectionChangedListener {
        private SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            JosmAction.this.updateEnabledState(collection);
        }
    }

    private class LayerChangeAdapter
    implements MapView.LayerChangeListener {
        private LayerChangeAdapter() {
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            JosmAction.this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            JosmAction.this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            JosmAction.this.updateEnabledState();
        }
    }
}

