/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCommand
extends Command {
    private final OsmPrimitive osm;
    private final OsmPrimitive newOsm;

    public ChangeCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
    }

    public ChangeCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        super(osmDataLayer);
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.osm.cloneFrom(this.newOsm);
        this.osm.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.osm);
    }

    @Override
    public MutableTreeNode description() {
        String string = "";
        switch (OsmPrimitiveType.from(this.osm)) {
            case NODE: {
                string = I18n.marktr("Change node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Change way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Change relation {0}");
            }
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr(string, this.osm.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(this.osm)), 0)));
    }
}

