/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.SimpleNodeElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPaintVisitor
implements PaintVisitor {
    private Graphics2D g;
    private NavigatableComponent nc;
    private boolean zoomLevelDisplay;
    private boolean drawMultipolygon;
    private boolean drawRestriction;
    private boolean leftHandTraffic;
    private ElemStyles.StyleSet styles;
    private double circum;
    private double dist;
    private boolean useStyleCache;
    private static int paintid = 0;
    private EastNorth minEN;
    private EastNorth maxEN;
    private MapPainter painter;
    private MapPaintSettings paintSettings;
    private boolean inactive;
    DataSet data;

    protected boolean isZoomOk(ElemStyle elemStyle) {
        if (!this.zoomLevelDisplay) {
            return true;
        }
        if (elemStyle == null) {
            return this.circum < 1500.0;
        }
        return !(this.circum >= (double)elemStyle.maxScale) && !(this.circum < (double)elemStyle.minScale);
    }

    public ElemStyle getPrimitiveStyle(OsmPrimitive osmPrimitive) {
        if (!this.useStyleCache) {
            return this.styles != null ? this.styles.get(osmPrimitive) : null;
        }
        if (osmPrimitive.mappaintStyle == null && this.styles != null) {
            osmPrimitive.mappaintStyle = this.styles.get(osmPrimitive);
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).isMappaintArea = this.styles.isArea(osmPrimitive);
            }
        }
        if (osmPrimitive.mappaintStyle == null && osmPrimitive instanceof Node) {
            osmPrimitive.mappaintStyle = SimpleNodeElemStyle.INSTANCE;
        }
        if (osmPrimitive.mappaintStyle == null && osmPrimitive instanceof Way) {
            osmPrimitive.mappaintStyle = LineElemStyle.UNTAGGED_WAY;
        }
        return osmPrimitive.mappaintStyle;
    }

    public IconElemStyle getPrimitiveNodeStyle(OsmPrimitive osmPrimitive) {
        if (!this.useStyleCache) {
            return this.styles != null ? this.styles.getIcon(osmPrimitive) : null;
        }
        if (osmPrimitive.mappaintStyle == null && this.styles != null) {
            osmPrimitive.mappaintStyle = this.styles.getIcon(osmPrimitive);
        }
        return (IconElemStyle)osmPrimitive.mappaintStyle;
    }

    public boolean isPrimitiveArea(Way way) {
        if (!this.useStyleCache) {
            return this.styles.isArea(way);
        }
        if (way.mappaintStyle == null && this.styles != null) {
            way.mappaintStyle = this.styles.get(way);
            way.isMappaintArea = this.styles.isArea(way);
        }
        return way.isMappaintArea;
    }

    public void drawNode(Node node) {
        if (node.getEastNorth().east() > this.maxEN.east() || node.getEastNorth().north() > this.maxEN.north() || node.getEastNorth().east() < this.minEN.east() || node.getEastNorth().north() < this.minEN.north()) {
            return;
        }
        ElemStyle elemStyle = this.getPrimitiveStyle(node);
        if (this.isZoomOk(elemStyle)) {
            elemStyle.paintPrimitive(node, this.paintSettings, this.painter, node.isSelected());
        }
    }

    public void drawWay(Way way, int n) {
        if (way.getNodesCount() < 2) {
            return;
        }
        if (way.hasIncompleteNodes()) {
            return;
        }
        double d = 10000.0;
        double d2 = -10000.0;
        double d3 = 10000.0;
        double d4 = -10000.0;
        for (Node object2 : way.getNodes()) {
            if (object2.getEastNorth().east() > d2) {
                d2 = object2.getEastNorth().east();
            }
            if (object2.getEastNorth().north() > d4) {
                d4 = object2.getEastNorth().north();
            }
            if (object2.getEastNorth().east() < d) {
                d = object2.getEastNorth().east();
            }
            if (!(object2.getEastNorth().north() < d3)) continue;
            d3 = object2.getEastNorth().north();
        }
        if (d > this.maxEN.east() || d3 > this.maxEN.north() || d2 < this.minEN.east() || d4 < this.minEN.north()) {
            return;
        }
        Object object = this.getPrimitiveStyle(way);
        if (!this.isZoomOk((ElemStyle)object)) {
            return;
        }
        if (object == null) {
            object = LineElemStyle.UNTAGGED_WAY;
        }
        if (object instanceof LineElemStyle) {
            ((ElemStyle)object).paintPrimitive(way, this.paintSettings, this.painter, this.data.isSelected(way));
        } else if (object instanceof AreaElemStyle) {
            AreaElemStyle areaElemStyle = (AreaElemStyle)object;
            if ((double)n > this.dist) {
                this.painter.drawArea(this.getPolygon(way), this.data.isSelected(way) ? this.paintSettings.getSelectedColor() : areaElemStyle.color, this.painter.getWayName(way));
                if (!way.isClosed()) {
                    this.putError(way, I18n.tr("Area style way is not closed."), true);
                }
            }
            areaElemStyle.getLineStyle().paintPrimitive(way, this.paintSettings, this.painter, this.data.isSelected(way));
        }
    }

    public void drawSelectedMember(OsmPrimitive osmPrimitive, ElemStyle elemStyle, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Way) {
            if (elemStyle instanceof AreaElemStyle) {
                Way way = (Way)osmPrimitive;
                AreaElemStyle areaElemStyle = (AreaElemStyle)elemStyle;
                areaElemStyle.getLineStyle().paintPrimitive(way, this.paintSettings, this.painter, true);
                if (bl) {
                    this.painter.drawArea(this.getPolygon(way), bl2 ? this.paintSettings.getSelectedColor() : areaElemStyle.color, this.painter.getWayName(way));
                }
            } else {
                elemStyle.paintPrimitive(osmPrimitive, this.paintSettings, this.painter, true);
            }
        } else if (osmPrimitive instanceof Node && this.isZoomOk(elemStyle)) {
            elemStyle.paintPrimitive(osmPrimitive, this.paintSettings, this.painter, true);
        }
        osmPrimitive.mappaintDrawnCode = paintid;
    }

    public void paintUnselectedRelation(Relation relation) {
        if (this.drawMultipolygon && "multipolygon".equals(relation.get("type"))) {
            if (this.drawMultipolygon(relation)) {
                return;
            }
        } else if (this.drawRestriction && "restriction".equals(relation.get("type"))) {
            this.drawRestriction(relation);
        }
        if (this.data.isSelected(relation)) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isWay() || !relationMember.getMember().isDrawable()) continue;
                this.drawSelectedMember(relationMember.getMember(), this.styles != null ? this.getPrimitiveStyle(relationMember.getMember()) : null, true, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation) {
        IconElemStyle iconElemStyle;
        void var6_12;
        Object object;
        Object object2;
        Object object3;
        Way way = null;
        Way way2 = null;
        OsmPrimitive osmPrimitive = null;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            if (primitiveId2.isWay()) {
                object3 = primitiveId2.getWay();
                if (((Way)object3).getNodesCount() < 2) continue;
                if ("from".equals(primitiveId2.getRole())) {
                    if (way != null) {
                        this.putError(relation, I18n.tr("More than one \"from\" way found."), true);
                        continue;
                    }
                    way = object3;
                    continue;
                }
                if ("to".equals(primitiveId2.getRole())) {
                    if (way2 != null) {
                        this.putError(relation, I18n.tr("More than one \"to\" way found."), true);
                        continue;
                    }
                    way2 = object3;
                    continue;
                }
                if ("via".equals(primitiveId2.getRole())) {
                    if (osmPrimitive != null) {
                        this.putError(relation, I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    osmPrimitive = object3;
                    continue;
                }
                this.putError(relation, I18n.tr("Unknown role ''{0}''.", primitiveId2.getRole()), true);
                continue;
            }
            if (primitiveId2.isNode()) {
                object3 = primitiveId2.getNode();
                if ("via".equals(primitiveId2.getRole())) {
                    if (osmPrimitive != null) {
                        this.putError(relation, I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    osmPrimitive = object3;
                    continue;
                }
                this.putError(relation, I18n.tr("Unknown role ''{0}''.", primitiveId2.getRole()), true);
                continue;
            }
            this.putError(relation, I18n.tr("Unknown member type for ''{0}''.", primitiveId2.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
        }
        if (way == null) {
            this.putError(relation, I18n.tr("No \"from\" way found."), true);
            return;
        }
        if (way2 == null) {
            this.putError(relation, I18n.tr("No \"to\" way found."), true);
            return;
        }
        if (osmPrimitive == null) {
            this.putError(relation, I18n.tr("No \"via\" node or way found."), true);
            return;
        }
        if (osmPrimitive instanceof Node) {
            object2 = (Node)osmPrimitive;
            if (!way.isFirstLastNode((Node)object2)) {
                this.putError(relation, I18n.tr("The \"from\" way does not start or end at a \"via\" node."), true);
                return;
            }
            if (!way2.isFirstLastNode((Node)object2)) {
                this.putError(relation, I18n.tr("The \"to\" way does not start or end at a \"via\" node."), true);
            }
        } else {
            Way way3 = osmPrimitive;
            object3 = way3.firstNode();
            object = way3.lastNode();
            Boolean bl = false;
            String string = way3.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl = true;
                    OsmPrimitive osmPrimitive2 = object3;
                    object3 = object;
                    object = osmPrimitive2;
                } else {
                    bl = OsmUtils.getOsmBoolean(string);
                    if (bl == null) {
                        bl = false;
                    }
                }
            }
            if (way.isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl.booleanValue() && way.isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                this.putError(relation, I18n.tr("The \"from\" way does not start or end at the \"via\" way."), true);
                return;
            }
            if (!way2.isFirstLastNode((Node)(object2 == object3 ? object : object3))) {
                this.putError(relation, I18n.tr("The \"to\" way does not start or end at the \"via\" way."), true);
            }
        }
        Object var6_9 = null;
        if (way.firstNode() == osmPrimitive) {
            Node node = way.getNode(1);
        } else {
            Node node = way.getNode(way.getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var6_12);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        if ((iconElemStyle = this.getPrimitiveNodeStyle(relation)) == null) {
            this.putError(relation, I18n.tr("Style for restriction {0} not found.", relation.get("restriction")), true);
            return;
        }
        this.painter.drawRestriction(this.inactive || relation.isDisabled() ? iconElemStyle.getDisabledIcon() : iconElemStyle.icon, (Point)object, d6, d9, d7, d10, d11, this.data.isSelected(relation));
    }

    public boolean drawMultipolygon(Relation relation) {
        boolean bl = false;
        Multipolygon multipolygon = new Multipolygon(this.nc);
        multipolygon.load(relation);
        ElemStyle elemStyle = this.getPrimitiveStyle(relation);
        if (this.styles != null && !(elemStyle instanceof AreaElemStyle)) {
            Way way;
            Iterator<Way> iterator = multipolygon.getOuterWays().iterator();
            while (iterator.hasNext() && (elemStyle = this.styles.getArea(way = iterator.next())) == null) {
            }
            relation.mappaintStyle = elemStyle;
        }
        if (elemStyle instanceof AreaElemStyle) {
            boolean bl2 = this.isZoomOk(elemStyle);
            boolean bl3 = false;
            bl = true;
            if (bl2 && !multipolygon.getOuterWays().isEmpty()) {
                Iterator<Way> iterator = (AreaElemStyle)elemStyle;
                for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                    Polygon polygon = polyData.get();
                    if (!this.isPolygonVisible(polygon)) continue;
                    boolean bl4 = polyData.selected || this.data.isSelected(relation);
                    this.painter.drawArea(polygon, bl4 ? this.paintSettings.getSelectedColor() : ((AreaElemStyle)((Object)iterator)).color, null);
                    bl3 = true;
                }
            }
            if (!bl3) {
                return bl;
            }
            for (Way way : multipolygon.getInnerWays()) {
                ElemStyle elemStyle2 = this.getPrimitiveStyle(way);
                if (elemStyle2 == null) {
                    if (this.data.isSelected(way)) continue;
                    if (bl2 && (way.mappaintDrawnCode != paintid || multipolygon.getOuterWays().isEmpty())) {
                        ((AreaElemStyle)elemStyle).getLineStyle().paintPrimitive(way, this.paintSettings, this.painter, this.data.isSelected(way) || this.data.isSelected(relation));
                    }
                    way.mappaintDrawnCode = paintid;
                    continue;
                }
                if (this.data.isSelected(relation)) {
                    this.drawSelectedMember(way, elemStyle2, !elemStyle.equals(elemStyle2), this.data.isSelected(way));
                }
                if (!elemStyle.equals(elemStyle2)) continue;
                this.putError(relation, I18n.tr("Style for inner way ''{0}'' equals multipolygon.", way.getDisplayName(DefaultNameFormatter.getInstance())), false);
                if (this.data.isSelected(relation)) continue;
                way.mappaintDrawnAreaCode = paintid;
            }
            for (Way way : multipolygon.getOuterWays()) {
                ElemStyle elemStyle3 = this.getPrimitiveStyle(way);
                if (elemStyle3 == null) {
                    if (this.data.isSelected(way)) continue;
                    if (bl2) {
                        ((AreaElemStyle)elemStyle).getLineStyle().paintPrimitive(way, this.paintSettings, this.painter, this.data.isSelected(way) || this.data.isSelected(relation));
                    }
                    way.mappaintDrawnCode = paintid;
                    continue;
                }
                if (elemStyle3 instanceof AreaElemStyle && !elemStyle.equals(elemStyle3)) {
                    this.putError(relation, I18n.tr("Style for outer way ''{0}'' mismatches.", way.getDisplayName(DefaultNameFormatter.getInstance())), true);
                }
                if (this.data.isSelected(relation)) {
                    this.drawSelectedMember(way, elemStyle3, false, false);
                    continue;
                }
                if (!(elemStyle3 instanceof AreaElemStyle)) continue;
                way.mappaintDrawnAreaCode = paintid;
            }
        }
        return bl;
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0) {
            return false;
        }
        if (rectangle.x > this.nc.getWidth()) {
            return false;
        }
        if (rectangle.y > this.nc.getHeight()) {
            return false;
        }
        if (rectangle.x + rectangle.width < 0) {
            return false;
        }
        return rectangle.y + rectangle.height >= 0;
    }

    protected Polygon getPolygon(Way way) {
        Polygon polygon = new Polygon();
        for (Node node : way.getNodes()) {
            Point point = this.nc.getPoint(node);
            polygon.addPoint(point.x, point.y);
        }
        return polygon;
    }

    protected Point2D getCentroid(Polygon polygon) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < polygon.npoints; ++i) {
            int n = i + 1 == polygon.npoints ? 0 : i + 1;
            d3 += (double)(polygon.xpoints[i] * polygon.ypoints[n] - polygon.ypoints[i] * polygon.xpoints[n]);
            d += (double)((polygon.xpoints[i] + polygon.xpoints[n]) * (polygon.xpoints[i] * polygon.ypoints[n] - polygon.ypoints[i] * polygon.xpoints[n]));
            d2 += (double)((polygon.ypoints[i] + polygon.ypoints[n]) * (polygon.xpoints[i] * polygon.ypoints[n] - polygon.ypoints[i] * polygon.xpoints[n]));
        }
        return new Point2D.Double(d / (3.0 * d3), d2 / (3.0 * d3));
    }

    protected double getArea(Polygon polygon) {
        double d = 0.0;
        for (int i = 0; i < polygon.npoints; ++i) {
            int n = i + 1 == polygon.npoints ? 0 : i + 1;
            d = d + (double)(polygon.xpoints[i] * polygon.ypoints[n]) - (double)(polygon.ypoints[i] * polygon.xpoints[n]);
        }
        return Math.abs(d / 2.0);
    }

    <T extends OsmPrimitive> Collection<T> selectedLast(final DataSet dataSet, Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                boolean bl = dataSet.isSelected((OsmPrimitive)t);
                boolean bl2 = dataSet.isSelected((OsmPrimitive)t2);
                if (bl && !bl2) {
                    return 1;
                }
                if (!bl && bl2) {
                    return -1;
                }
                return t.compareTo(t2);
            }
        });
        return arrayList;
    }

    @Override
    public void visitAll(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = new BBox(bounds);
        this.data = dataSet;
        ++paintid;
        this.useStyleCache = Main.pref.getBoolean("mappaint.cache", true);
        int n = Main.pref.getInteger("mappaint.fillareas", 10000000);
        LatLon latLon = this.nc.getLatLon(0, 0);
        LatLon latLon2 = this.nc.getLatLon(100, 0);
        this.dist = latLon.greatCircleDistance(latLon2);
        this.zoomLevelDisplay = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        this.circum = this.nc.getDist100Pixel();
        this.styles = MapPaintStyles.getStyles().getStyleSet();
        this.drawMultipolygon = Main.pref.getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.minEN = this.nc.getEastNorth(0, this.nc.getHeight() - 1);
        this.maxEN = this.nc.getEastNorth(this.nc.getWidth() - 1, 0);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.painter = new MapPainter(this.paintSettings, this.g, this.inactive, this.nc, bl, this.dist, this.circum);
        dataSet.clearErrors();
        if ((double)n > this.dist && this.styles != null && this.styles.hasAreas()) {
            Iterator<OsmPrimitive> iterator = new LinkedList();
            for (Relation relation : dataSet.searchRelations(bBox)) {
                if (!relation.isDrawable()) continue;
                this.paintUnselectedRelation(relation);
            }
            for (Way way : this.selectedLast(dataSet, dataSet.searchWays(bBox))) {
                if (!way.isDrawable() || way.mappaintDrawnCode == paintid) continue;
                if (this.isPrimitiveArea(way) && way.mappaintDrawnAreaCode != paintid) {
                    this.drawWay(way, n);
                    continue;
                }
                iterator.add(way);
            }
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Way way = (Way)iterator2.next();
                this.drawWay(way, 0);
            }
        } else {
            this.drawMultipolygon = false;
            for (Relation relation : dataSet.searchRelations(bBox)) {
                if (!relation.isDrawable()) continue;
                this.paintUnselectedRelation(relation);
            }
            for (Way way : dataSet.searchWays(bBox)) {
                if (!way.isDrawable() || dataSet.isSelected(way)) continue;
                this.drawWay(way, 0);
            }
        }
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (!osmPrimitive.isUsable() || osmPrimitive instanceof Node || osmPrimitive.mappaintDrawnCode == paintid) continue;
            osmPrimitive.visit(new AbstractVisitor(){

                public void visit(Way way) {
                    MapPaintVisitor.this.drawWay(way, 0);
                }

                public void visit(Node node) {
                }

                public void visit(Relation relation) {
                    for (RelationMember relationMember : relation.getMembers()) {
                        if (!relationMember.isNode() || !relationMember.getMember().isDrawable()) continue;
                        MapPaintVisitor.this.drawSelectedMember(relationMember.getMember(), MapPaintVisitor.this.styles != null ? MapPaintVisitor.this.getPrimitiveStyle(relationMember.getMember()) : null, true, true);
                    }
                }
            });
        }
        for (Node node : dataSet.searchNodes(bBox)) {
            if (node.isIncomplete() || node.isDeleted() || !dataSet.isSelected(node) && node.isFiltered() || node.mappaintDrawnCode == paintid) continue;
            this.drawNode(node);
        }
        this.painter.drawVirtualNodes(dataSet.searchWays(bBox));
    }

    public void putError(OsmPrimitive osmPrimitive, String string, boolean bl) {
        this.data.addError(osmPrimitive, bl ? I18n.tr("Error: {0}", string) : I18n.tr("Warning: {0}", string));
    }

    @Override
    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    @Override
    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    @Override
    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }
}

