/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertCC9Zones
implements Projection,
ProjectionSubPrefs {
    public static final double[] n = new double[]{0.6691500006885269, 0.682018118346418, 0.6946784863203991, 0.7071272481559119, 0.7193606118567315, 0.7313748510399917, 0.7431663060711892, 0.7547313851789208, 0.7660665655489937};
    public static final double[] c = new double[]{1.215363305807804E7, 1.2050261119223533E7, 1.195716926884592E7, 1.18737533925172E7, 1.1799460698022118E7, 1.17337838820243E7, 1.16762559948139E7, 1.1626445901183508E7, 1.1583954251630554E7};
    public static final double Xs = 1700000.0;
    public static final double[] Ys = new double[]{8293467.503439436, 9049604.665107645, 9814691.693461388, 1.0588107871787189E7, 1.1369285637569271E7, 1.2157704903382052E7, 1.2952888086405803E7, 1.3754395745267643E7, 1.4561822739114787E7};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-12;
    public static final double cMaxLatZonesRadian = Math.toRadians(51.1);
    public static final double cMinLatZonesDegree = 41.0;
    public static final double cMinLatZonesRadian = Math.toRadians(41.0);
    public static final double cMinLonZonesRadian = Math.toRadians(-5.0);
    public static final double cMaxLonZonesRadian = Math.toRadians(10.2);
    public static final double lambda0 = Math.toRadians(3.0);
    public static final double e = Ellipsoid.GRS80.e;
    public static final double e2 = Ellipsoid.GRS80.e2;
    public static final double a = Ellipsoid.GRS80.a;
    public static final double cMaxOverlappingZones = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private static int layoutZone = 0;
    private static String[] lambert9zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, 41, 43), I18n.tr("{0} ({1} to {2} degrees)", 2, 42, 44), I18n.tr("{0} ({1} to {2} degrees)", 3, 43, 45), I18n.tr("{0} ({1} to {2} degrees)", 4, 44, 46), I18n.tr("{0} ({1} to {2} degrees)", 5, 45, 47), I18n.tr("{0} ({1} to {2} degrees)", 6, 46, 48), I18n.tr("{0} ({1} to {2} degrees)", 7, 47, 49), I18n.tr("{0} ({1} to {2} degrees)", 8, 48, 50), I18n.tr("{0} ({1} to {2} degrees)", 9, 49, 51)};

    private double L(double d, double d2) {
        double d3 = Math.sin(d);
        return 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) - d2 / 2.0 * Math.log((1.0 + d2 * d3) / (1.0 - d2 * d3));
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        if (d >= cMinLatZonesRadian && d <= cMaxLatZonesRadian && d2 >= cMinLonZonesRadian && d2 <= cMaxLonZonesRadian) {
            return this.ConicProjection(d, d2, layoutZone);
        }
        return this.ConicProjection(d, d2, 0);
    }

    private EastNorth ConicProjection(double d, double d2, int n) {
        double d3 = c[n] * Math.exp(-LambertCC9Zones.n[n] * this.L(d, e));
        double d4 = LambertCC9Zones.n[n] * (d2 - lambda0);
        double d5 = 1700000.0 + d3 * Math.sin(d4);
        double d6 = Ys[n] + -d3 * Math.cos(d4);
        return new EastNorth(d5, d6);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return this.Geographic(eastNorth, layoutZone);
    }

    private LatLon Geographic(EastNorth eastNorth, int n) {
        double d = Math.sqrt(Math.pow(eastNorth.getX() - 1700000.0, 2.0) + Math.pow(eastNorth.getY() - Ys[n], 2.0));
        double d2 = Math.atan((eastNorth.getX() - 1700000.0) / (Ys[n] - eastNorth.getY()));
        double d3 = lambda0 + d2 / LambertCC9Zones.n[n];
        double d4 = -1.0 / LambertCC9Zones.n[n] * Math.log(Math.abs(d / c[n]));
        double d5 = Ellipsoid.GRS80.latitude(d4, e, 1.0E-12);
        return new LatLon(Math.toDegrees(d5), Math.toDegrees(d3));
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert CC9 Zone (France)");
    }

    public static int north2ZoneNumber(double d) {
        int n = (int)(d / 1000000.0) - 1;
        if (n < 0) {
            return 0;
        }
        if (n > 8) {
            return 8;
        }
        return n;
    }

    @Override
    public String toCode() {
        return "EPSG:" + (3942 + layoutZone);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        double d = 41.0 + (double)(layoutZone + 1);
        return new Bounds(new LatLon(d - 1.0 - 1.5, -4.9), new LatLon(d + 1.0 + 1.5, 10.2));
    }

    public int getLayoutZone() {
        return layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel) {
        JComboBox<String> jComboBox = new JComboBox<String>(lambert9zones);
        jComboBox.setSelectedIndex(layoutZone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Lambert CC Zone")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add((Component)new JLabel(ImageProvider.get("data/projection", "LambertCC9Zones.png")), GBC.eol().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        layoutZone = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(layoutZone + 1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        layoutZone = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((layoutZone = Integer.parseInt(string = iterator.next()) - 1) < 0 || layoutZone > 8)) {
                    layoutZone = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:39") && string.length() == 9) {
            try {
                String string2 = string.substring(5, 4);
                int n = Integer.parseInt(string2) - 3942;
                if (n >= 0 && n <= 8) {
                    return Collections.singleton(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

