/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.text.DecimalFormat;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.PuwgData;
import org.openstreetmap.josm.tools.I18n;

abstract class Puwg2000
implements PuwgData {
    private static final double PuwgFalseEasting = 500000.0;
    private static final double PuwgFalseNorthing = 0.0;
    private static final double PuwgScaleFactor = 0.999923;
    private final String[] Puwg2000Code = new String[]{"EPSG:2176", "EPSG:2177", "EPSG:2178", "EPSG:2179"};
    private final String[] Puwg2000CDName = new String[]{"epsg2176", "epsg2177", "epsg2178", "epsg2179"};
    private static DecimalFormat decFormatter = new DecimalFormat("###0.00");

    Puwg2000() {
    }

    public String toString() {
        return I18n.tr("PUWG 2000 Zone {0} (Poland)", Integer.toString(this.getZone()));
    }

    public String toCode() {
        return this.Puwg2000Code[this.getZoneIndex()];
    }

    public String getCacheDirectoryName() {
        return this.Puwg2000CDName[this.getZoneIndex()];
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(49.0, (double)(3 * this.getZone()) - 1.5), new LatLon(54.84, (double)(3 * this.getZone()) + 1.5));
    }

    public EastNorth latlon2eastNorth(LatLon latLon) {
        return null;
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return null;
    }

    public double getPuwgCentralMeridianDeg() {
        return (double)this.getZone() * 3.0;
    }

    public double getPuwgCentralMeridian() {
        return Math.toRadians((double)this.getZone() * 3.0);
    }

    public double getPuwgFalseNorthing() {
        return 0.0;
    }

    public double getPuwgFalseEasting() {
        return 1000000.0 * (double)this.getZone() + 500000.0;
    }

    public double getPuwgScaleFactor() {
        return 0.999923;
    }

    public abstract int getZone();

    public int getZoneIndex() {
        return this.getZone() - 5;
    }

    public double getDefaultZoomInPPD() {
        return 0.009;
    }

    public String eastToString(EastNorth eastNorth) {
        return Integer.toString(this.getZone()) + decFormatter.format(eastNorth.east());
    }

    public String northToString(EastNorth eastNorth) {
        return decFormatter.format(eastNorth.north());
    }
}

