/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.SimpleNodeElemStyle;

public class IconElemStyle
extends ElemStyle {
    public ImageIcon icon;
    private ImageIcon disabledIcon;
    public boolean annotate;

    public IconElemStyle(IconElemStyle iconElemStyle, long l, long l2) {
        this.icon = iconElemStyle.icon;
        this.annotate = iconElemStyle.annotate;
        this.priority = iconElemStyle.priority;
        this.maxScale = l;
        this.minScale = l2;
        this.rules = iconElemStyle.rules;
    }

    public IconElemStyle() {
        this.init();
    }

    public void init() {
        this.icon = null;
        this.priority = 0;
        this.annotate = true;
    }

    public ImageIcon getDisabledIcon() {
        if (this.disabledIcon != null) {
            return this.disabledIcon;
        }
        if (this.icon == null) {
            return null;
        }
        this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(this.icon.getImage()));
        return this.disabledIcon;
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl) {
        if (mapPainter.isShowIcons()) {
            Node node = (Node)osmPrimitive;
            String string = mapPainter.isShowNames() ? mapPainter.getNodeName(node) : null;
            mapPainter.drawNodeIcon(node, mapPainter.isInactive() || node.isDisabled() ? this.getDisabledIcon() : this.icon, this.annotate, bl, string);
        } else {
            SimpleNodeElemStyle.INSTANCE.paintPrimitive(osmPrimitive, mapPaintSettings, mapPainter, bl);
        }
    }
}

