/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineElemStyle
extends ElemStyle
implements Comparable<LineElemStyle> {
    public static final LineElemStyle UNTAGGED_WAY = new LineElemStyle();
    private int width;
    public int realWidth;
    public Color color;
    private float[] dashed;
    public Color dashedColor;
    public boolean over;
    public WidthMode widthMode;
    public Collection<LineElemStyle> overlays;

    public LineElemStyle(LineElemStyle lineElemStyle, long l, long l2) {
        this.width = lineElemStyle.width;
        this.realWidth = lineElemStyle.realWidth;
        this.color = lineElemStyle.color;
        this.dashed = lineElemStyle.dashed;
        this.dashedColor = lineElemStyle.dashedColor;
        this.over = lineElemStyle.over;
        this.widthMode = lineElemStyle.widthMode;
        this.priority = lineElemStyle.priority;
        this.maxScale = l;
        this.minScale = l2;
        this.rules = lineElemStyle.rules;
    }

    public LineElemStyle(LineElemStyle lineElemStyle, Collection<LineElemStyle> collection) {
        this.width = lineElemStyle.width;
        this.realWidth = lineElemStyle.realWidth;
        this.color = lineElemStyle.color;
        this.dashed = lineElemStyle.dashed;
        this.dashedColor = lineElemStyle.dashedColor;
        this.over = lineElemStyle.over;
        this.widthMode = lineElemStyle.widthMode;
        this.priority = lineElemStyle.priority;
        this.maxScale = lineElemStyle.maxScale;
        this.minScale = lineElemStyle.minScale;
        this.rules = lineElemStyle.rules;
        this.overlays = collection;
        this.code = lineElemStyle.code;
        for (LineElemStyle lineElemStyle2 : collection) {
            this.code = this.code + lineElemStyle2.code;
        }
    }

    public LineElemStyle() {
        this.init();
    }

    public void init() {
        this.width = -1;
        this.realWidth = 0;
        this.dashed = new float[0];
        this.dashedColor = null;
        this.priority = 0;
        this.color = null;
        this.over = true;
        this.widthMode = WidthMode.ABSOLUTE;
        this.overlays = null;
    }

    public int getWidth(int n) {
        int n2 = this.widthMode == WidthMode.ABSOLUTE ? this.width : (this.widthMode == WidthMode.OFFSET ? n + this.width : (this.width < 0 ? 0 : n * this.width / 100));
        return n2 <= 0 ? 1 : n2;
    }

    @Override
    public int compareTo(LineElemStyle lineElemStyle) {
        if (lineElemStyle.priority != this.priority) {
            return lineElemStyle.priority > this.priority ? 1 : -1;
        }
        if (!this.over && lineElemStyle.over) {
            return -1;
        }
        return 0;
    }

    public float[] getDashed() {
        return this.dashed;
    }

    public void setDashed(float[] fArray) {
        if (fArray.length == 0) {
            this.dashed = fArray;
            return;
        }
        boolean bl = false;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] > 0.0f) {
                bl = true;
            }
            if (!(fArray[i] < 0.0f)) continue;
            System.out.println(I18n.tr("Illegal dash pattern, values must be positive"));
        }
        if (bl) {
            this.dashed = fArray;
        } else {
            System.out.println(I18n.tr("Illegal dash pattern, at least one value must be > 0"));
        }
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl) {
        Way way = (Way)osmPrimitive;
        boolean bl2 = bl || !mapPaintSettings.isUseRealWidth() && mapPaintSettings.isShowDirectionArrow() && (!mapPaintSettings.isShowRelevantDirectionsOnly() || way.hasDirectionKeys());
        boolean bl3 = way.reversedDirection();
        boolean bl4 = bl2 && !bl && mapPaintSettings.isShowHeadArrowOnly();
        Color color = this.color;
        int n = this.getWidth();
        if (this.realWidth > 0 && mapPaintSettings.isUseRealWidth() && !bl2) {
            Object object = way.get("width");
            if (object == null) {
                object = way.get("est_width");
            }
            if (object != null) {
                try {
                    this.realWidth = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((n = (int)(100.0f / (float)(mapPainter.getCircum() / (double)this.realWidth))) < this.getWidth()) {
                n = this.getWidth();
            }
        }
        if (way.isHighlighted()) {
            color = mapPaintSettings.getHighlightColor();
        } else if (bl) {
            color = mapPaintSettings.getSelectedColor();
        } else if (way.isDisabled()) {
            color = mapPaintSettings.getInactiveColor();
        }
        if (this.overlays != null) {
            for (LineElemStyle lineElemStyle : this.overlays) {
                if (lineElemStyle.over) continue;
                mapPainter.drawWay(way, lineElemStyle.color != null && bl ? color : lineElemStyle.color, lineElemStyle.getWidth(n), lineElemStyle.getDashed(), lineElemStyle.dashedColor, false, false, false);
            }
        }
        mapPainter.drawWay(way, color, n, this.dashed, this.dashedColor, bl2, bl ? false : bl3, bl4);
        if (this.overlays != null) {
            for (LineElemStyle lineElemStyle : this.overlays) {
                if (!lineElemStyle.over) continue;
                mapPainter.drawWay(way, lineElemStyle.color != null && bl ? color : lineElemStyle.color, lineElemStyle.getWidth(n), lineElemStyle.getDashed(), lineElemStyle.dashedColor, false, false, false);
            }
        }
        if (mapPaintSettings.isShowOrderNumber()) {
            int n2 = 0;
            Node node = null;
            for (Node node2 : way.getNodes()) {
                if (node != null) {
                    mapPainter.drawOrderNumber(node, node2, ++n2);
                }
                node = node2;
            }
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            return MapPaintSettings.INSTANCE.getDefaultSegmentWidth();
        }
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    static {
        LineElemStyle.UNTAGGED_WAY.color = PaintColors.UNTAGGED.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WidthMode {
        ABSOLUTE,
        PERCENT,
        OFFSET;

    }
}

