/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import com.google.gdata.util.common.base.PercentEscaper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oauth.signpost.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth {
    public static final String VERSION_1_0 = "1.0";
    public static final String ENCODING = "UTF-8";
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String HTTP_AUTHORIZATION_HEADER = "Authorization";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String OAUTH_SIGNATURE = "oauth_signature";
    public static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String OAUTH_NONCE = "oauth_nonce";
    public static final String OAUTH_VERSION = "oauth_version";
    public static final String OAUTH_CALLBACK = "oauth_callback";
    public static final String OAUTH_CALLBACK_CONFIRMED = "oauth_callback_confirmed";
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String OUT_OF_BAND = "oob";
    private static final PercentEscaper percentEncoder = new PercentEscaper("-._~", false);

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        return percentEncoder.escape(s);
    }

    public static String percentDecode(String s) {
        try {
            if (s == null) {
                return "";
            }
            return URLDecoder.decode(s, ENCODING);
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static void formEncode(Collection<Parameter> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first = true;
            for (Parameter parameter : parameters) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(OAuth.percentEncode(OAuth.toString(parameter.getKey())).getBytes());
                into.write(61);
                into.write(OAuth.percentEncode(OAuth.toString(parameter.getValue())).getBytes());
            }
        }
    }

    public static String formEncode(Collection<Parameter> parameters) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OAuth.formEncode(parameters, b);
        return new String(b.toByteArray());
    }

    public static List<Parameter> decodeForm(String form) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        if (!OAuth.isEmpty(form)) {
            for (String nvp : form.split("\\&")) {
                String value;
                String name;
                int equals = nvp.indexOf(61);
                if (equals < 0) {
                    name = OAuth.percentDecode(nvp);
                    value = null;
                } else {
                    name = OAuth.percentDecode(nvp.substring(0, equals));
                    value = OAuth.percentDecode(nvp.substring(equals + 1));
                }
                params.add(new Parameter(name, value));
            }
        }
        return params;
    }

    public static List<Parameter> decodeForm(InputStream content) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(content));
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
        }
        return OAuth.decodeForm(sb.toString());
    }

    public static Map<String, String> toMap(Collection<Parameter> from) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (from != null) {
            for (Parameter param : from) {
                String key = OAuth.toString(param.getKey());
                if (map.containsKey(key)) continue;
                map.put(key, OAuth.toString(param.getValue()));
            }
        }
        return map;
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String addQueryParameters(String url, String ... kvPairs) {
        String queryDelim = url.contains("?") ? "&" : "?";
        StringBuilder sb = new StringBuilder(url + queryDelim);
        for (int i = 0; i < kvPairs.length; i += 2) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append(OAuth.percentEncode(kvPairs[i]) + "=" + OAuth.percentEncode(kvPairs[i + 1]));
        }
        return sb.toString();
    }
}

