/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(PurgePrimitivesCommand.class.getName());
    private Collection<OsmPrimitive> toPurge;
    private Set<OsmPrimitive> purgedPrimitives;
    private Set<OsmPrimitive> origVersionsOfTouchedPrimitives;

    protected void init(Collection<OsmPrimitive> collection) {
        this.toPurge = collection;
        this.purgedPrimitives = new HashSet<OsmPrimitive>();
        this.origVersionsOfTouchedPrimitives = new HashSet<OsmPrimitive>();
    }

    public PurgePrimitivesCommand(OsmPrimitive osmPrimitive) {
        this.init(Collections.singleton(osmPrimitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive) {
        super(osmDataLayer);
        this.init(Collections.singleton(osmPrimitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        super(osmDataLayer);
        this.init(collection);
    }

    public Collection<OsmPrimitive> getPurgedPrimitives() {
        return this.purgedPrimitives;
    }

    @Override
    public JLabel getDescription() {
        if (this.purgedPrimitives.size() == 1) {
            return new JLabel(I18n.tr("Purged object ''{0}''", this.purgedPrimitives.iterator().next().getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get("data", "object"), 0);
        }
        return new JLabel(I18n.trn("Purged {0} object", "Purged {0} objects", this.purgedPrimitives.size(), this.purgedPrimitives.size()));
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.purgedPrimitives.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osmPrimitive : this.purgedPrimitives) {
            arrayList.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return new JLabel(I18n.tr("Purged object ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get("data", "object"), 0);
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return arrayList;
    }

    protected void removeReferecesToPrimitive(OsmPrimitive osmPrimitive, Set<OsmPrimitive> set) {
        set.remove(osmPrimitive);
        for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
            OsmPrimitive osmPrimitive3;
            if (this.toPurge.contains(osmPrimitive2)) {
                return;
            }
            if (osmPrimitive2 instanceof Way) {
                osmPrimitive3 = (Way)osmPrimitive2;
                if (!this.origVersionsOfTouchedPrimitives.contains(osmPrimitive3)) {
                    this.origVersionsOfTouchedPrimitives.add(osmPrimitive3);
                }
                ((Way)osmPrimitive3).removeNode((Node)osmPrimitive);
                if (((Way)osmPrimitive3).getNodesCount() >= 2) continue;
                System.out.println(I18n.tr("Warning: Purging way {0} because number of nodes dropped below 2. Current is {1}", osmPrimitive3.getId(), ((Way)osmPrimitive3).getNodesCount()));
                set.add(osmPrimitive3);
                continue;
            }
            if (!(osmPrimitive2 instanceof Relation)) continue;
            osmPrimitive3 = (Relation)osmPrimitive2;
            if (!this.origVersionsOfTouchedPrimitives.contains(osmPrimitive3)) {
                this.origVersionsOfTouchedPrimitives.add(osmPrimitive3);
            }
            System.out.println(I18n.tr("Removing reference from relation {0}", osmPrimitive3.getId()));
            ((Relation)osmPrimitive3).removeMembersFor(osmPrimitive);
        }
    }

    @Override
    public boolean executeCommand() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        hashSet.addAll(this.toPurge);
        while (!hashSet.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)hashSet.iterator().next();
            this.removeReferecesToPrimitive(osmPrimitive, hashSet);
            this.getLayer().data.removePrimitive(osmPrimitive);
            this.purgedPrimitives.add(osmPrimitive);
            ConflictCollection conflictCollection = this.getLayer().getConflicts();
            if (!conflictCollection.hasConflictForMy(osmPrimitive)) continue;
            this.rememberConflict(conflictCollection.getConflictForMy(osmPrimitive));
            conflictCollection.remove(osmPrimitive);
        }
        return super.executeCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.origVersionsOfTouchedPrimitives);
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            logger.warning(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        for (OsmPrimitive osmPrimitive : this.purgedPrimitives) {
            this.getLayer().data.addPrimitive(osmPrimitive);
        }
        this.reconstituteConflicts();
        super.undoCommand();
    }
}

