/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeletePrimitivesCommand
extends ConflictResolveCommand {
    private final List<OsmPrimitive> toUndelete = new ArrayList<OsmPrimitive>();
    private final List<OsmPrimitive> replacedPrimitives = new ArrayList<OsmPrimitive>();

    public UndeletePrimitivesCommand(OsmPrimitive osmPrimitive) {
        this.toUndelete.add(osmPrimitive);
    }

    public UndeletePrimitivesCommand(OsmPrimitive ... osmPrimitiveArray) {
        for (int i = 0; i < osmPrimitiveArray.length; ++i) {
            this.toUndelete.add(osmPrimitiveArray[i]);
        }
    }

    public UndeletePrimitivesCommand(Collection<OsmPrimitive> collection) {
        this.toUndelete.addAll(collection);
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Undelete {0} primitive", "Undelete {0} primitives", this.toUndelete.size(), this.toUndelete.size()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.replacedPrimitives.clear();
        for (OsmPrimitive osmPrimitive : this.toUndelete) {
            OsmPrimitive osmPrimitive2;
            if (this.getLayer().getConflicts().hasConflictForMy(osmPrimitive)) {
                this.rememberConflict(this.getLayer().getConflicts().getConflictForMy(osmPrimitive));
                this.getLayer().getConflicts().remove(osmPrimitive);
            }
            switch (osmPrimitive.getType()) {
                case NODE: {
                    osmPrimitive2 = new Node((Node)osmPrimitive, true);
                    break;
                }
                case WAY: {
                    osmPrimitive2 = new Way((Way)osmPrimitive, true);
                    break;
                }
                case RELATION: {
                    osmPrimitive2 = new Relation((Relation)osmPrimitive, true);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.replacedPrimitives.add(osmPrimitive2);
            this.replacePrimitive(this.getLayer().data, osmPrimitive, osmPrimitive2);
        }
        return true;
    }

    private void replacePrimitive(DataSet dataSet, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        dataSet.addPrimitive(osmPrimitive2);
        for (OsmPrimitive osmPrimitive3 : osmPrimitive.getReferrers()) {
            List<PrimitiveId> list;
            OsmPrimitive osmPrimitive4;
            if (osmPrimitive3 instanceof Way) {
                osmPrimitive4 = (Way)osmPrimitive3;
                list = ((Way)osmPrimitive4).getNodes();
                Collections.replaceAll(list, (Node)osmPrimitive, (Node)osmPrimitive2);
                ((Way)osmPrimitive4).setNodes(list);
                osmPrimitive4.setModified(true);
                continue;
            }
            if (!(osmPrimitive3 instanceof Relation)) continue;
            osmPrimitive4 = (Relation)osmPrimitive3;
            list = ((Relation)osmPrimitive4).getMembers();
            ListIterator<PrimitiveId> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                RelationMember relationMember = (RelationMember)listIterator.next();
                if (relationMember.getMember() != osmPrimitive) continue;
                listIterator.set(new RelationMember(relationMember.getRole(), osmPrimitive2));
            }
            ((Relation)osmPrimitive4).setMembers(list);
            osmPrimitive4.setModified(true);
        }
        dataSet.removePrimitive(osmPrimitive);
    }

    @Override
    public void undoCommand() {
        for (int i = 0; i < this.toUndelete.size(); ++i) {
            this.replacePrimitive(this.getLayer().data, this.replacedPrimitives.get(i), this.toUndelete.get(i));
        }
        super.undoCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }
}

