/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Icon;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;

public class Marker
implements ActionListener {
    public final String text;
    public final Icon symbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private CachedLatLon coor;
    public static LinkedList<MarkerProducers> markerProducers = new LinkedList();

    public final void setCoor(LatLon latLon) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(latLon);
        } else {
            this.coor.setCoor(latLon);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor.setEastNorth(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public Marker(LatLon latLon, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        this.setCoor(latLon);
        this.text = string;
        this.offset = d2;
        this.time = d;
        this.symbol = ImageProvider.getIfAvailable("markers", string2);
        this.parentLayer = markerLayer;
    }

    public boolean containsPoint(Point point) {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void paint(Graphics graphics, MapView mapView, boolean bl, boolean bl2) {
        Point point = mapView.getPoint(this.getEastNorth());
        if (this.symbol != null && bl2) {
            this.symbol.paintIcon(mapView, graphics, point.x - this.symbol.getIconWidth() / 2, point.y - this.symbol.getIconHeight() / 2);
        } else {
            graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
            graphics.drawLine(point.x + 2, point.y - 2, point.x - 2, point.y + 2);
        }
        if (this.text != null && bl2) {
            graphics.drawString(this.text, point.x + 4, point.y + 2);
        }
    }

    public static Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
        for (MarkerProducers markerProducers : Marker.markerProducers) {
            Marker marker = markerProducers.createMarker(wayPoint, file, markerLayer, d, d2);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public AudioMarker audioMarkerFromMarker(String string) {
        AudioMarker audioMarker = AudioMarker.create(this.getCoor(), this.text, string, this.parentLayer, this.time, this.offset);
        return audioMarker;
    }

    static {
        markerProducers.add(new MarkerProducers(){

            public Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
                Object object;
                String string = null;
                try {
                    object = ((Collection)wayPoint.attr.get("meta.links")).iterator();
                    if (object.hasNext()) {
                        GpxLink gpxLink = (GpxLink)object.next();
                        string = gpxLink.uri;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (file != null && string != null && !this.isWellFormedAddress(string)) {
                    string = new File(file.getParentFile(), string).toURI().toString();
                }
                object = "";
                if (wayPoint.attr.containsKey("name")) {
                    object = wayPoint.getString("name");
                } else if (wayPoint.attr.containsKey("desc")) {
                    object = wayPoint.getString("desc");
                }
                if (string == null) {
                    return new Marker(wayPoint.getCoor(), (String)object, wayPoint.getString("symbol"), markerLayer, d, d2);
                }
                if (string.endsWith(".wav")) {
                    return AudioMarker.create(wayPoint.getCoor(), (String)object, string, markerLayer, d, d2);
                }
                if (string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".gif")) {
                    return ImageMarker.create(wayPoint.getCoor(), string, markerLayer, d, d2);
                }
                return WebMarker.create(wayPoint.getCoor(), string, markerLayer, d, d2);
            }

            private boolean isWellFormedAddress(String string) {
                try {
                    new URL(string);
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
        });
    }
}

