/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.ParametrizedCollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionPreference
implements PreferenceSetting {
    private static final StringProperty PROP_PROJECTION = new StringProperty("projection", Mercator.class.getName());
    private static final StringProperty PROP_COORDINATES = new StringProperty("coordinates", null);
    private static final CollectionProperty PROP_SUB_PROJECTION = new CollectionProperty("projection.sub", null);
    private static final ParametrizedCollectionProperty PROP_PROJECTION_SUBPROJECTION = new ParametrizedCollectionProperty(null){

        protected String getKey(String ... stringArray) {
            String string = stringArray[0];
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            return "projection.sub." + string2;
        }
    };
    private static CopyOnWriteArrayList<ProjectionChangedListener> listeners = new CopyOnWriteArrayList();
    private JComboBox projectionCombo = new JComboBox<Projection>(Projection.allProjections);
    private JComboBox coordinatesCombo = new JComboBox<CoordinateFormat>(CoordinateFormat.values());
    private JPanel projSubPrefPanel;
    private JLabel projectionCode = new JLabel();
    private JLabel bounds = new JLabel();
    private JPanel projPanel = new JPanel();
    private static GBC projSubPrefPanelGBC = GBC.eol().fill(1).insets(20, 5, 5, 5);

    public static void addProjectionChangedListener(ProjectionChangedListener projectionChangedListener) {
        listeners.addIfAbsent(projectionChangedListener);
    }

    public static void removeProjectionChangedListener(ProjectionChangedListener projectionChangedListener) {
        listeners.remove(projectionChangedListener);
    }

    private static void fireProjectionChanged() {
        for (ProjectionChangedListener projectionChangedListener : listeners) {
            projectionChangedListener.projectionChanged();
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        this.setupProjectionCombo();
        for (int i = 0; i < this.coordinatesCombo.getItemCount(); ++i) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(i))).name().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(i);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection code")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        JScrollPane jScrollPane = new JScrollPane(this.projPanel);
        preferenceTabbedPane.mapcontent.addTab(I18n.tr("Map Projection"), jScrollPane);
        this.updateMeta(Main.proj);
    }

    private void updateMeta(Projection projection) {
        this.projectionCode.setText(projection.toCode());
        Bounds bounds = projection.getWorldBoundsLatLon();
        CoordinateFormat coordinateFormat = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(bounds.getMin().latToString(coordinateFormat) + "; " + bounds.getMin().lonToString(coordinateFormat) + " : " + bounds.getMax().latToString(coordinateFormat) + "; " + bounds.getMax().lonToString(coordinateFormat));
    }

    @Override
    public boolean ok() {
        Projection projection = (Projection)this.projectionCombo.getSelectedItem();
        String string = projection.getClass().getName();
        Collection<String> collection = null;
        if (projection instanceof ProjectionSubPrefs) {
            collection = ((ProjectionSubPrefs)((Object)projection)).getPreferences(this.projSubPrefPanel);
        }
        PROP_PROJECTION.put(string);
        ProjectionPreference.setProjection(string, collection);
        if (PROP_COORDINATES.put(((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION.get(), PROP_SUB_PROJECTION.get());
    }

    public static void setProjection(String string, Collection<String> collection) {
        Bounds bounds = Main.map != null && Main.map.mapView != null ? Main.map.mapView.getRealBounds() : null;
        Projection projection = Main.proj;
        try {
            Main.proj = (Projection)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", string), I18n.tr("Error"), 0);
            collection = null;
            Main.proj = new Mercator();
            string = Main.proj.getClass().getName();
        }
        PROP_SUB_PROJECTION.put(collection);
        PROP_PROJECTION_SUBPROJECTION.put(collection, string);
        if (Main.proj instanceof ProjectionSubPrefs) {
            ((ProjectionSubPrefs)((Object)Main.proj)).setPreferences(collection);
        }
        ProjectionPreference.fireProjectionChanged();
        if (!(bounds == null || Main.proj.getClass().getName().equals(projection.getClass().getName()) && Main.proj.hashCode() == projection.hashCode())) {
            Main.map.mapView.zoomTo(bounds);
        }
    }

    private void selectedProjectionChanged(Projection projection) {
        if (!(projection instanceof ProjectionSubPrefs)) {
            this.projSubPrefPanel = new JPanel();
        } else {
            ProjectionSubPrefs projectionSubPrefs = (ProjectionSubPrefs)((Object)projection);
            this.projSubPrefPanel = new SBPanel(projection);
            projectionSubPrefs.setupPreferencePanel(this.projSubPrefPanel);
        }
        int n = this.projPanel.getComponentCount();
        if (n < 1) {
            return;
        }
        this.projPanel.remove(n - 1);
        this.projPanel.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(projection);
    }

    private void setupProjectionCombo() {
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            Projection projection = (Projection)this.projectionCombo.getItemAt(i);
            String string = projection.getClass().getName();
            if (projection instanceof ProjectionSubPrefs) {
                ((ProjectionSubPrefs)((Object)projection)).setPreferences(PROP_PROJECTION_SUBPROJECTION.get(string));
            }
            if (!string.equals(PROP_PROJECTION.get())) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(projection);
            break;
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Projection projection = (Projection)jComboBox.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(projection);
            }
        });
    }

    private class SBPanel
    extends JPanel {
        private Projection p;

        public SBPanel(Projection projection) {
            this.p = projection;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            ((ProjectionSubPrefs)((Object)this.p)).setPreferences(((ProjectionSubPrefs)((Object)this.p)).getPreferences(this));
            ProjectionPreference.this.updateMeta(this.p);
        }
    }

    public static interface ProjectionChangedListener {
        public void projectionChanged();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

