/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerLocationReader
extends OsmServerReader {
    String url;

    public OsmServerLocationReader(String string) {
        this.url = string;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream = null;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            inputStream = this.getInputStreamRaw(this.url, progressMonitor.createSubTaskMonitor(9, false));
            if (inputStream == null) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
            dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet3 = null;
                return dataSet3;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                this.activeConnection = null;
            }
            catch (Exception exception) {}
        }
        return dataSet;
    }
}

