/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCollection<T extends OsmPrimitive>
extends AbstractCollection<T> {
    private final Collection<? extends OsmPrimitive> primitives;
    private final Predicate<OsmPrimitive> predicate;
    int size = -1;

    public DatasetCollection(Collection<? extends OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        this.primitives = collection;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator(this.primitives.iterator());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++this.size;
                iterator.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<? extends OsmPrimitive> iterator;
        private OsmPrimitive current;

        public FilterIterator(Iterator<? extends OsmPrimitive> iterator) {
            this.iterator = iterator;
        }

        private void findNext() {
            if (this.current == null) {
                while (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    if (!DatasetCollection.this.predicate.evaluate(this.current)) continue;
                    return;
                }
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.current != null;
        }

        @Override
        public T next() {
            this.findNext();
            OsmPrimitive osmPrimitive = this.current;
            this.current = null;
            return osmPrimitive;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

