/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.CoordinateConflictResolveCommand;
import org.openstreetmap.josm.command.DeletedStateConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMergeModel
extends Observable {
    public static final String RESOLVED_COMPLETELY_PROP = PropertiesMergeModel.class.getName() + ".resolvedCompletely";
    public static final String DELETE_PRIMITIVE_PROP = PropertiesMergeModel.class.getName() + ".deletePrimitive";
    private OsmPrimitive my;
    private LatLon myCoords;
    private LatLon theirCoords;
    private MergeDecisionType coordMergeDecision = MergeDecisionType.UNDECIDED;
    private boolean myDeletedState;
    private boolean theirDeletedState;
    private List<OsmPrimitive> myReferrers;
    private List<OsmPrimitive> theirReferrers;
    private MergeDecisionType deletedMergeDecision = MergeDecisionType.UNDECIDED;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean resolvedCompletely = false;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void fireCompletelyResolved() {
        boolean bl = this.resolvedCompletely;
        this.resolvedCompletely = this.isResolvedCompletely();
        this.support.firePropertyChange(RESOLVED_COMPLETELY_PROP, bl, this.resolvedCompletely);
    }

    public boolean isDecidedCoord() {
        return !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedDeletedState() {
        return !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isCoordMergeDecision(MergeDecisionType mergeDecisionType) {
        return this.coordMergeDecision.equals((Object)mergeDecisionType);
    }

    public boolean isDeletedStateDecision(MergeDecisionType mergeDecisionType) {
        return this.deletedMergeDecision.equals((Object)mergeDecisionType);
    }

    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.my = conflict.getMy();
        OsmPrimitive osmPrimitive = conflict.getTheir();
        if (this.my instanceof Node) {
            this.myCoords = ((Node)this.my).getCoor();
            this.theirCoords = ((Node)osmPrimitive).getCoor();
        } else {
            this.myCoords = null;
            this.theirCoords = null;
        }
        this.myDeletedState = conflict.isMyDeleted() || this.my.isDeleted();
        this.theirDeletedState = osmPrimitive.isDeleted();
        this.myReferrers = this.my.getDataSet() == null ? Collections.emptyList() : this.my.getReferrers();
        this.theirReferrers = osmPrimitive.getDataSet() == null ? Collections.emptyList() : osmPrimitive.getReferrers();
        this.coordMergeDecision = MergeDecisionType.UNDECIDED;
        this.deletedMergeDecision = MergeDecisionType.UNDECIDED;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public LatLon getMyCoords() {
        return this.myCoords;
    }

    public LatLon getTheirCoords() {
        return this.theirCoords;
    }

    public LatLon getMergedCoords() {
        switch (this.coordMergeDecision) {
            case KEEP_MINE: {
                return this.myCoords;
            }
            case KEEP_THEIR: {
                return this.theirCoords;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideCoordsConflict(MergeDecisionType mergeDecisionType) {
        this.coordMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public Boolean getMyDeletedState() {
        return this.myDeletedState;
    }

    public Boolean getTheirDeletedState() {
        return this.theirDeletedState;
    }

    public Boolean getMergedDeletedState() {
        switch (this.deletedMergeDecision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public List<OsmPrimitive> getMyReferrers() {
        return this.myReferrers;
    }

    public List<OsmPrimitive> getTheirReferrers() {
        return this.theirReferrers;
    }

    private boolean getMergedDeletedState(MergeDecisionType mergeDecisionType) {
        switch (mergeDecisionType) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
        }
        return false;
    }

    public void decideDeletedStateConflict(MergeDecisionType mergeDecisionType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)mergeDecisionType, "decision");
        boolean bl = this.getMergedDeletedState(this.deletedMergeDecision);
        boolean bl2 = this.getMergedDeletedState(mergeDecisionType);
        this.deletedMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
        if (bl != bl2) {
            this.support.firePropertyChange(DELETE_PRIMITIVE_PROP, bl, bl2);
        }
    }

    public boolean hasCoordConflict() {
        if (this.myCoords == null && this.theirCoords != null) {
            return true;
        }
        if (this.myCoords != null && this.theirCoords == null) {
            return true;
        }
        if (this.myCoords == null && this.theirCoords == null) {
            return false;
        }
        return !this.myCoords.equalsEpsilon(this.theirCoords);
    }

    public boolean hasDeletedStateConflict() {
        return this.myDeletedState != this.theirDeletedState;
    }

    public boolean isResolvedCompletely() {
        boolean bl = true;
        if (this.hasCoordConflict()) {
            boolean bl2 = bl = bl && !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasDeletedStateConflict()) {
            bl = bl && !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        return bl;
    }

    public List<Command> buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (this.hasCoordConflict() && this.isDecidedCoord()) {
            arrayList.add(new CoordinateConflictResolveCommand(conflict, this.coordMergeDecision));
        }
        if (this.hasDeletedStateConflict() && this.isDecidedDeletedState()) {
            arrayList.add(new DeletedStateConflictResolveCommand(conflict, this.deletedMergeDecision));
        }
        return arrayList;
    }

    public OsmPrimitive getMyPrimitive() {
        return this.my;
    }
}

