/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DuplicateLayerAction;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static LayerListDialog instance;
    private LayerListModel model;
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private LayerList layerList;
    ActivateLayerAction activateLayerAction;

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = this.getButtonPanel(5);
        MoveUpAction moveUpAction = new MoveUpAction();
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.selectionModel);
        jPanel.add(new SideButton(moveUpAction));
        MoveDownAction moveDownAction = new MoveDownAction();
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.selectionModel);
        jPanel.add(new SideButton(moveDownAction));
        this.activateLayerAction = new ActivateLayerAction();
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, this.selectionModel);
        jPanel.add(new SideButton(this.activateLayerAction));
        ShowHideLayerAction showHideLayerAction = new ShowHideLayerAction();
        this.adaptTo((IEnabledStateUpdating)showHideLayerAction, this.selectionModel);
        jPanel.add(new SideButton(showHideLayerAction));
        MergeAction mergeAction = new MergeAction();
        this.adaptTo((IEnabledStateUpdating)mergeAction, this.model);
        this.adaptTo((IEnabledStateUpdating)mergeAction, this.selectionModel);
        jPanel.add(new SideButton(mergeAction));
        DuplicateAction duplicateAction = new DuplicateAction();
        this.adaptTo((IEnabledStateUpdating)duplicateAction, this.model);
        this.adaptTo((IEnabledStateUpdating)duplicateAction, this.selectionModel);
        jPanel.add(new SideButton(duplicateAction));
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
        this.layerList.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "deleteLayer");
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, this.selectionModel);
        jPanel.add(new SideButton((Action)deleteLayerAction, false));
        return jPanel;
    }

    protected LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers"), "layerlist", I18n.tr("Open a list of all loaded layers."), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers")), 76, 4), 100, true);
        this.selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(this.selectionModel);
        this.layerList = new LayerList((ListModel)this.model);
        this.layerList.setSelectionModel(this.selectionModel);
        this.layerList.addMouseListener(new DblClickAdapter());
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.setCellRenderer(new LayerListCellRenderer());
        this.add((Component)new JScrollPane(this.layerList), "Center");
        MapView mapView = mapFrame.mapView;
        this.model.populate();
        this.model.setSelectedLayer(mapView.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            public void makeVisible(int n, Layer layer) {
                LayerListDialog.this.layerList.ensureIndexIsVisible(n);
            }

            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        this.add((Component)this.createButtonPanel(), "South");
    }

    public void showNotify() {
        MapView.addLayerChangeListener(this.activateLayerAction);
        MapView.addLayerChangeListener(this.model);
        this.model.populate();
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener(this.model);
        MapView.removeLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, ListModel listModel) {
        listModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    public void destroy() {
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction();
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction();
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer);
    }

    static class LayerList
    extends JList {
        public LayerList(ListModel listModel) {
            super(listModel);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            Rectangle rectangle = this.getCellBounds(n, n);
            if (rectangle != null && rectangle.contains(mouseEvent.getPoint())) {
                super.processMouseEvent(mouseEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayerListModel
    extends DefaultListModel
    implements MapView.LayerChangeListener,
    PropertyChangeListener {
        private DefaultListSelectionModel selectionModel;
        private CopyOnWriteArrayList<LayerListModelListener> listeners;

        private LayerListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        public void addLayerListModelListener(LayerListModelListener layerListModelListener) {
            if (layerListModelListener != null) {
                this.listeners.addIfAbsent(layerListModelListener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener layerListModelListener) {
            this.listeners.remove(layerListModelListener);
        }

        protected void fireMakeVisible(int n, Layer layer) {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.makeVisible(n, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int n = this.getLayers().indexOf(layer);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.getLayers().get(i));
            }
            return arrayList;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        protected void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int n = this.getSize();
            List<Integer> list = this.getSelectedRows();
            if (list.isEmpty() && n > 0) {
                this.selectionModel.setSelectionInterval(n - 1, n - 1);
            }
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        protected void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireContentsChanged(this, 0, this.getSize());
            int n = this.getLayers().indexOf(layer);
            this.selectionModel.setSelectionInterval(n, n);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getSize() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int n) {
            if (n < 0 || n >= this.getSize()) {
                return null;
            }
            return this.getLayers().get(n);
        }

        public boolean canMoveUp() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n - 1);
                Main.map.mapView.moveLayer(layer2, n);
                Main.map.mapView.moveLayer(layer, n - 1);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n - 1, n - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(list.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            Collections.reverse(list);
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n + 1);
                Main.map.mapView.moveLayer(layer, n + 1);
                Main.map.mapView.moveLayer(layer2, n);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n + 1, n + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int n = this.selectionModel.getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            if (n >= this.getLayers().size()) {
                return;
            }
            Layer layer = this.getLayers().get(n);
            this.fireMakeVisible(n, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer layer) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            if (layer == null) {
                return arrayList;
            }
            for (Layer layer2 : this.getLayers()) {
                if (layer == layer2 || !layer2.isMergable(layer)) continue;
                arrayList.add(layer2);
            }
            return arrayList;
        }

        protected List<Layer> getLayers() {
            if (Main.map == null || Main.map.mapView == null) {
                return Collections.emptyList();
            }
            return Main.map.mapView.getAllLayersAsList();
        }

        protected void ensureActiveSelected() {
            if (this.getLayers().size() == 0) {
                return;
            }
            if (this.getActiveLayer() != null) {
                int n = this.getLayers().indexOf(this.getActiveLayer());
                this.selectionModel.setSelectionInterval(n, n);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            if (Main.map == null || Main.map.mapView == null) {
                return null;
            }
            return Main.map.mapView.getActiveLayer();
        }

        @Override
        public Object getElementAt(int n) {
            return this.getLayers().get(n);
        }

        @Override
        public int getSize() {
            List<Layer> list = this.getLayers();
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        @Override
        public void activeLayerChange(Layer layer, Layer layer2) {
            int n;
            if (layer != null && (n = this.getLayers().indexOf(layer)) >= 0) {
                this.fireContentsChanged(this, n, n);
            }
            if (layer2 != null && (n = this.getLayers().indexOf(layer2)) >= 0) {
                this.fireContentsChanged(this, n, n);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(Layer layer) {
            this.onAddLayer(layer);
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.onRemoveLayer(layer);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Layer) {
                Layer layer = (Layer)propertyChangeEvent.getSource();
                int n = this.getLayers().indexOf(layer);
                if (n < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class MoveDownAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveDownAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row down."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveDown());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveDown();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveUpAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row up."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveUp());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveUp();
        }
    }

    class DblClickAdapter
    extends MouseAdapter {
        DblClickAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = LayerListDialog.this.layerList.locationToIndex(mouseEvent.getPoint());
                if (!LayerListDialog.this.layerList.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                    return;
                }
                Layer layer = LayerListDialog.this.model.getLayer(n);
                layer.toggleVisible();
            }
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        public void launch(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = LayerListDialog.this.layerList.locationToIndex(point);
            if (n < 0) {
                return;
            }
            if (!LayerListDialog.this.layerList.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                return;
            }
            if (!LayerListDialog.this.layerList.isSelectedIndex(n)) {
                LayerListDialog.this.layerList.setSelectedIndex(n);
            }
            Layer layer = LayerListDialog.this.model.getLayer(n);
            LayerListPopup layerListPopup = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers(), layer);
            layerListPopup.show(LayerListDialog.this, point.x, point.y - 3);
        }
    }

    static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        LayerListCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, layer.getName(), n, bl, bl2);
            Icon icon = layer.getIcon();
            if (this.isActiveLayer(layer)) {
                icon = ImageProvider.overlay(icon, "overlay/active", ImageProvider.OverlayPosition.SOUTHWEST);
            }
            if (!layer.isVisible()) {
                icon = ImageProvider.overlay(icon, "overlay/invisiblenew", ImageProvider.OverlayPosition.SOUTHEAST);
            }
            jLabel.setIcon(icon);
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }

    public final class DuplicateAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public DuplicateAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Duplicate"));
            this.updateEnabledState();
        }

        public DuplicateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
            this.putValue("ShortDescription", I18n.tr("Duplicate this layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#DuplicateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                new DuplicateLayerAction().duplicate(this.layer);
            } else {
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new DuplicateLayerAction().duplicate(layer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                    this.setEnabled(DuplicateLayerAction.canDuplicate(LayerListDialog.this.getModel().getSelectedLayers().get(0)));
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(DuplicateLayerAction.canDuplicate(this.layer));
            }
        }
    }

    public final class MergeAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public MergeAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Merge"));
            this.updateEnabledState();
        }

        public MergeAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "mergedown"));
            this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#MergeLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                new MergeLayerAction().merge(this.layer);
            } else {
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new MergeLayerAction().merge(layer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(layer);
                this.setEnabled(!list.isEmpty());
            } else {
                List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(this.layer);
                this.setEnabled(!list.isEmpty());
            }
        }
    }

    public final class ActivateLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    MapView.LayerChangeListener {
        private Layer layer;

        public ActivateLayerAction(Layer layer) {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Activate"));
            this.updateEnabledState();
        }

        public ActivateLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
            this.putValue("ShortDescription", I18n.tr("Activate the selected layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#ActivateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = this.layer != null ? this.layer : LayerListDialog.this.model.getSelectedLayers().get(0);
            Main.map.mapView.setActiveLayer(layer);
            layer.setVisible(true);
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                this.setEnabled(!this.isActiveLayer(layer));
            } else {
                this.setEnabled(!this.isActiveLayer(this.layer));
            }
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ShowHideLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;

        public ShowHideLayerAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public ShowHideLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer."));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#ShowHideLayer"));
            this.putValue("Name", I18n.tr("Show/Hide"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                this.layer.toggleVisible();
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.toggleVisible();
                }
            }
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof ShowHideLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DeleteLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        public DeleteLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layers."));
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#DeleteLayer"));
            this.updateEnabledState();
        }

        protected boolean enforceUploadOrSaveModifiedData(List<Layer> list) {
            SaveLayersDialog saveLayersDialog = new SaveLayersDialog(Main.parent);
            ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
            for (Layer layer : list) {
                OsmDataLayer osmDataLayer;
                if (!(layer instanceof OsmDataLayer) || !(osmDataLayer = (OsmDataLayer)layer).requiresSaveToFile() && !osmDataLayer.requiresUploadToServer() || !osmDataLayer.data.isModified()) continue;
                arrayList.add(osmDataLayer);
            }
            saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeDelete();
            if (!arrayList.isEmpty()) {
                saveLayersDialog.getModel().populate(arrayList);
                saveLayersDialog.setVisible(true);
                switch (saveLayersDialog.getUserAction()) {
                    case CANCEL: {
                        return false;
                    }
                    case PROCEED: {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Layer> list = LayerListDialog.this.getModel().getSelectedLayers();
            if (list.isEmpty()) {
                return;
            }
            if (!this.enforceUploadOrSaveModifiedData(list)) {
                return;
            }
            for (Layer layer : list) {
                Main.main.removeLayer(layer);
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof DeleteLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }
}

