/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.BackupPreference;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener {
    private static final Logger logger = Logger.getLogger(PreferenceTabbedPane.class.getName());
    private static final Collection<PreferenceSettingFactory> settingsFactory = new LinkedList<PreferenceSettingFactory>();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    public final JPanel display = this.createPreferenceTab("display", I18n.tr("Display Settings"), I18n.tr("Various settings that influence the visual representation of the whole program."));
    public final JPanel connection = this.createPreferenceTab("connection", I18n.tr("Connection Settings"), I18n.tr("Connection Settings for the OSM server."), false);
    public final JPanel map = this.createPreferenceTab("map", I18n.tr("Map Settings"), I18n.tr("Settings for the map projection and data interpretation."));
    public final JPanel audio = this.createPreferenceTab("audio", I18n.tr("Audio Settings"), I18n.tr("Settings for the audio player and audio markers."));
    public final JPanel plugins = this.createPreferenceTab("plugin", I18n.tr("Plugins"), I18n.tr("Configure available plugins."), false);
    public final JTabbedPane displaycontent = new JTabbedPane();
    public final JTabbedPane mapcontent = new JTabbedPane();
    List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3) {
        return this.createPreferenceTab(string, string2, string3, false);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(string2), GBC.eol().insets(0, 5, 0, 10).anchor(18));
        JLabel jLabel = new JLabel("<html>" + string3 + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        JComponent jComponent = jPanel;
        if (bl) {
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jComponent = jScrollPane;
        }
        this.addTab(null, ImageProvider.get("preferences", string), jComponent);
        this.setToolTipTextAt(this.getTabCount() - 1, "<html>" + string3 + "</html>");
        return jPanel;
    }

    protected PluginPreference getPluginPreference() {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!(preferenceSetting instanceof PluginPreference)) continue;
            return (PluginPreference)preferenceSetting;
        }
        return null;
    }

    public void savePreferences() {
        if (Main.applet) {
            return;
        }
        PluginPreference pluginPreference = this.getPluginPreference();
        List<PluginInformation> list = pluginPreference.getPluginsScheduledForUpdateOrDownload();
        final PluginDownloadTask pluginDownloadTask = !list.isEmpty() ? new PluginDownloadTask((Component)this, list, I18n.tr("Download plugins")) : null;
        final Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() && !pluginDownloadTask.getDownloadedPlugins().isEmpty()) {
                    bl = true;
                }
                for (PreferenceSetting preferenceSetting : PreferenceTabbedPane.this.settings) {
                    if (!preferenceSetting.ok()) continue;
                    bl = true;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled()) {
                    stringBuffer.append(PluginPreference.buildDownloadSummary(pluginDownloadTask));
                }
                if (bl) {
                    stringBuffer.append(I18n.tr("You have to restart JOSM for some settings to take effect."));
                }
                stringBuffer.append("</html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() || bl) {
                    JOptionPane.showMessageDialog(Main.parent, stringBuffer.toString(), I18n.tr("Warning"), 2);
                }
                Main.parent.repaint();
            }
        };
        if (pluginDownloadTask != null) {
            Main.worker.submit(pluginDownloadTask);
            Main.worker.submit(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(runnable);
                }
            });
        } else {
            runnable.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
    }

    public void buildGui() {
        for (PreferenceSettingFactory object : settingsFactory) {
            PreferenceSetting preferenceSetting = object.createPreferenceSetting();
            if (preferenceSetting == null) continue;
            this.settings.add(object.createPreferenceSetting());
        }
        this.display.add((Component)this.displaycontent, GBC.eol().fill(1));
        this.map.add((Component)this.mapcontent, GBC.eol().fill(1));
        Iterator<Object> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            try {
                PreferenceSetting throwable = (PreferenceSetting)iterator.next();
                throwable.addGui(this);
            }
            catch (SecurityException securityException) {
                iterator.remove();
            }
            catch (Throwable throwable) {
                BugReportExceptionHandler.handleException(throwable);
            }
        }
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (super.indexAtLocation(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y) < 0) {
            return;
        }
        int n = super.getSelectedIndex() + mouseWheelEvent.getWheelRotation();
        n = n < 0 ? 0 : n;
        n = n >= super.getTabCount() ? super.getTabCount() - 1 : n;
        super.setSelectedIndex(n);
    }

    static {
        settingsFactory.add(new DrawingPreference.Factory());
        settingsFactory.add(new ColorPreference.Factory());
        settingsFactory.add(new LafPreference.Factory());
        settingsFactory.add(new LanguagePreference.Factory());
        settingsFactory.add(new ServerAccessPreference.Factory());
        settingsFactory.add(new ProjectionPreference.Factory());
        settingsFactory.add(new MapPaintPreference.Factory());
        settingsFactory.add(new TaggingPresetPreference.Factory());
        settingsFactory.add(new BackupPreference.Factory());
        if (!Main.applet) {
            settingsFactory.add(new PluginPreference.Factory());
        }
        settingsFactory.add(Main.toolbar);
        settingsFactory.add(new AudioPreference.Factory());
        settingsFactory.add(new ShortcutPreference.Factory());
        PluginHandler.getPreferenceSetting(settingsFactory);
        settingsFactory.add(new AdvancedPreference.Factory());
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }
}

