/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerResponse;

public class JosmPreferencesCredentialManager
implements CredentialsManager {
    Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();

    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType) throws CredentialsManagerException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String string = Main.pref.get("osm-server.username", null);
                String string2 = Main.pref.get("osm-server.password", null);
                if (string == null) {
                    return null;
                }
                return new PasswordAuthentication(string, string2 == null ? new char[]{} : string2.toCharArray());
            }
            case PROXY: {
                String string = Main.pref.get("proxy.user", null);
                String string3 = Main.pref.get("proxy.pass", null);
                if (string == null) {
                    return null;
                }
                return new PasswordAuthentication(string, string3 == null ? null : string3.toCharArray());
            }
        }
        return null;
    }

    public void store(Authenticator.RequestorType requestorType, PasswordAuthentication passwordAuthentication) throws CredentialsManagerException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                Main.pref.put("osm-server.username", passwordAuthentication.getUserName());
                if (passwordAuthentication.getPassword() == null) {
                    Main.pref.put("osm-server.password", null);
                    break;
                }
                Main.pref.put("osm-server.password", String.valueOf(passwordAuthentication.getPassword()));
                break;
            }
            case PROXY: {
                Main.pref.put("proxy.user", passwordAuthentication.getUserName());
                if (passwordAuthentication.getPassword() == null) {
                    Main.pref.put("proxy.pass", null);
                    break;
                }
                Main.pref.put("proxy.pass", String.valueOf(passwordAuthentication.getPassword()));
            }
        }
    }

    public CredentialsManagerResponse getCredentials(Authenticator.RequestorType requestorType, boolean bl) throws CredentialsManagerException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication passwordAuthentication = this.lookup(requestorType);
        String string = passwordAuthentication == null || passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName();
        String string2 = passwordAuthentication == null || passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword());
        CredentialsManagerResponse credentialsManagerResponse = new CredentialsManagerResponse();
        if (!bl && this.memoryCredentialsCache.containsKey((Object)requestorType) && (passwordAuthentication == null || passwordAuthentication.getPassword() == null || passwordAuthentication.getPassword().length == 0)) {
            PasswordAuthentication passwordAuthentication2 = this.memoryCredentialsCache.get((Object)requestorType);
            credentialsManagerResponse.setUsername(passwordAuthentication2.getUserName());
            credentialsManagerResponse.setPassword(passwordAuthentication2.getPassword());
            credentialsManagerResponse.setCanceled(false);
        } else if (bl || string.equals("") || string2.equals("")) {
            CredentialDialog credentialDialog = null;
            switch (requestorType) {
                case SERVER: {
                    credentialDialog = CredentialDialog.getOsmApiCredentialDialog(string, string2);
                    break;
                }
                case PROXY: {
                    credentialDialog = CredentialDialog.getHttpProxyCredentialDialog(string, string2);
                }
            }
            credentialDialog.setVisible(true);
            credentialsManagerResponse.setCanceled(credentialDialog.isCanceled());
            if (credentialDialog.isCanceled()) {
                return credentialsManagerResponse;
            }
            credentialsManagerResponse.setUsername(credentialDialog.getUsername());
            credentialsManagerResponse.setPassword(credentialDialog.getPassword());
            if (credentialDialog.isSaveCredentials()) {
                this.store(requestorType, new PasswordAuthentication(credentialsManagerResponse.getUsername(), credentialsManagerResponse.getPassword()));
            } else {
                PasswordAuthentication passwordAuthentication3 = new PasswordAuthentication(credentialDialog.getUsername(), credentialDialog.getPassword());
                this.memoryCredentialsCache.put(requestorType, passwordAuthentication3);
            }
        } else {
            credentialsManagerResponse.setUsername(string);
            credentialsManagerResponse.setPassword(string2.toCharArray());
            credentialsManagerResponse.setCanceled(false);
        }
        return credentialsManagerResponse;
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsManagerException {
        String string = Main.pref.get("oauth.access-token.key", null);
        String string2 = Main.pref.get("oauth.access-token.secret", null);
        if (string == null && string2 == null) {
            return null;
        }
        return new OAuthToken(string, string2);
    }

    public void storeOAuthAccessToken(OAuthToken oAuthToken) throws CredentialsManagerException {
        if (oAuthToken == null) {
            Main.pref.put("oauth.access-token.key", null);
            Main.pref.put("oauth.access-token.secret", null);
        } else {
            Main.pref.put("oauth.access-token.key", oAuthToken.getKey());
            Main.pref.put("oauth.access-token.secret", oAuthToken.getSecret());
        }
    }
}

