/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes = false;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    private List<EastNorth> possibleMoveDirections;
    private EastNorth activeMoveDirection;
    private Cursor oldCursor;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private MoveCommand moveCommand;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = PaintColors.SELECTED.get();
    }

    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.");
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal.");
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        super.exitMode();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment != null) {
            Object object;
            if ((mouseEvent.getModifiers() & 2) != 0) {
                this.mode = Mode.translate;
            } else {
                this.mode = Mode.extrude;
                this.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = (mouseEvent.getModifiers() & 1) != 0;
            }
            this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
            this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
            this.possibleMoveDirections = new ArrayList<EastNorth>();
            this.possibleMoveDirections.add(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()));
            Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
            if (node != null) {
                object = node.getEastNorth();
                this.possibleMoveDirections.add(new EastNorth(this.initialN1en.getX() - ((EastNorth)object).getX(), this.initialN1en.getY() - ((EastNorth)object).getY()));
            }
            if ((object = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
                EastNorth eastNorth = ((Node)object).getEastNorth();
                this.possibleMoveDirections.add(new EastNorth(this.initialN2en.getX() - eastNorth.getX(), this.initialN2en.getY() - eastNorth.getY()));
            }
            this.newN1en = null;
            this.newN2en = null;
            this.moveCommand = null;
            Main.map.mapView.addTemporaryLayer(this);
            this.updateStatusLine();
            Main.map.mapView.repaint();
            this.mouseDownTime = System.currentTimeMillis();
            this.initialMousePos = mouseEvent.getPoint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            Cloneable cloneable;
            EastNorth eastNorth = Main.map.mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            EastNorth eastNorth3 = new EastNorth(eastNorth2.getX() - eastNorth.getX(), eastNorth2.getY() - eastNorth.getY());
            double d = Double.POSITIVE_INFINITY;
            EastNorth eastNorth4 = null;
            this.activeMoveDirection = null;
            for (EastNorth eastNorth5 : this.possibleMoveDirections) {
                double d2;
                cloneable = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, eastNorth5, eastNorth2);
                if (cloneable == null || !(d > (d2 = ((Point2D)cloneable).distance(eastNorth3)))) continue;
                d = d2;
                this.activeMoveDirection = eastNorth5;
                eastNorth4 = cloneable;
            }
            this.newN1en = new EastNorth(this.initialN1en.getX() + eastNorth4.getX(), this.initialN1en.getY() + eastNorth4.getY());
            this.newN2en = new EastNorth(this.initialN2en.getX() + eastNorth4.getX(), this.initialN2en.getY() + eastNorth4.getY());
            double d3 = Main.proj.eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.proj.eastNorth2latlon(this.newN1en));
            Main.map.statusLine.setDist(d3);
            this.updateStatusLine();
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (this.mode != Mode.extrude && this.mode == Mode.translate) {
                if (this.moveCommand == null) {
                    cloneable = new LinkedList();
                    cloneable.add(this.selectedSegment.getFirstNode());
                    cloneable.add(this.selectedSegment.getSecondNode());
                    this.moveCommand = new MoveCommand((Collection<OsmPrimitive>)((Object)cloneable), eastNorth4.getX(), eastNorth4.getY());
                    Main.main.undoRedo.add(this.moveCommand);
                } else {
                    this.moveCommand.undoCommand();
                    this.moveCommand.moveAgain(eastNorth4.getX(), eastNorth4.getY());
                }
            }
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.extrude) {
                if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    Object object;
                    Node node;
                    boolean bl;
                    LinkedList<Command> linkedList = new LinkedList<Command>();
                    Way way = new Way(this.selectedSegment.way);
                    int n = this.selectedSegment.lowerIndex + 1;
                    Node node2 = this.getPreviousNode(this.selectedSegment.lowerIndex);
                    boolean bl2 = bl = node2 != null && ExtrudeAction.pointsColinear(node2.getEastNorth(), this.initialN1en, this.newN1en);
                    if (bl && !this.alwaysCreateNodes) {
                        node = this.selectedSegment.getFirstNode();
                        linkedList.add(new MoveCommand(node, Main.proj.eastNorth2latlon(this.newN1en)));
                    } else {
                        node = new Node(Main.proj.eastNorth2latlon(this.newN1en));
                        way.addNode(n, node);
                        ++n;
                        linkedList.add(new AddCommand(node));
                    }
                    node = this.getNextNode(this.selectedSegment.lowerIndex + 1);
                    boolean bl3 = bl = node != null && ExtrudeAction.pointsColinear(node.getEastNorth(), this.initialN2en, this.newN2en);
                    if (bl && !this.alwaysCreateNodes) {
                        object = this.selectedSegment.getSecondNode();
                        linkedList.add(new MoveCommand((Node)object, Main.proj.eastNorth2latlon(this.newN2en)));
                    } else {
                        object = new Node(Main.proj.eastNorth2latlon(this.newN2en));
                        way.addNode(n, (Node)object);
                        ++n;
                        linkedList.add(new AddCommand((OsmPrimitive)object));
                    }
                    if (way.getNodesCount() == 4) {
                        way.addNode(this.selectedSegment.getFirstNode());
                    }
                    linkedList.add(new ChangeCommand(this.selectedSegment.way, way));
                    object = new SequenceCommand(I18n.tr("Extrude Way"), linkedList);
                    Main.main.undoRedo.add((Command)object);
                }
            } else if (this.mode == Mode.translate) {
                // empty if block
            }
            this.restoreCursor();
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    private static EastNorth calculateSegmentOffset(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        EastNorth eastNorth5 = ExtrudeAction.getLineLineIntersection(eastNorth, eastNorth2, eastNorth4, new EastNorth(eastNorth4.getX() + eastNorth3.getX(), eastNorth4.getY() + eastNorth3.getY()));
        if (eastNorth5 == null) {
            return null;
        }
        return new EastNorth(eastNorth4.getX() - eastNorth5.getX(), eastNorth4.getY() - eastNorth5.getY());
    }

    public static EastNorth getLineLineIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth2.getX() * eastNorth.getY() - eastNorth.getX() * eastNorth2.getY();
        double d4 = eastNorth4.getY() - eastNorth3.getY();
        double d5 = eastNorth3.getX() - eastNorth4.getX();
        double d6 = eastNorth4.getX() * eastNorth3.getY() - eastNorth3.getX() * eastNorth4.getY();
        double d7 = d * d5 - d4 * d2;
        if (d7 == 0.0) {
            return null;
        }
        return new EastNorth((d2 * d6 - d5 * d3) / d7, (d4 * d3 - d * d6) / d7);
    }

    private static boolean pointsColinear(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d;
        double d2 = eastNorth.distance(eastNorth2);
        double d3 = eastNorth.distance(eastNorth3);
        double d4 = eastNorth2.distance(eastNorth3);
        if (d2 < d3) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        if (d2 < d4) {
            d = d2;
            d2 = d4;
            d4 = d;
        }
        return Math.abs(d = d2 - d3 - d4) < 1.0E-15;
    }

    private Node getPreviousNode(int n) {
        if (n > 0) {
            return this.selectedSegment.way.getNode(n - 1);
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNode(this.selectedSegment.way.getNodesCount() - 2);
        }
        return null;
    }

    private Node getNextNode(int n) {
        int n2 = this.selectedSegment.way.getNodesCount();
        if (n < n2 - 1) {
            return this.selectedSegment.way.getNode(n + 1);
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNode(1);
        }
        return null;
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mode != Mode.select && this.newN1en != null) {
            Graphics2D graphics2D2 = graphics2D;
            graphics2D2.setColor(this.selectedColor);
            graphics2D2.setStroke(new BasicStroke(3.0f, 1, 1));
            Point point = mapView.getPoint(this.initialN1en);
            Point point2 = mapView.getPoint(this.initialN2en);
            Point point3 = mapView.getPoint(this.newN1en);
            Point point4 = mapView.getPoint(this.newN2en);
            if (this.mode == Mode.extrude) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(point.x, point.y);
                generalPath.lineTo(point3.x, point3.y);
                generalPath.lineTo(point4.x, point4.y);
                generalPath.lineTo(point2.x, point2.y);
                generalPath.lineTo(point.x, point.y);
                graphics2D2.draw(generalPath);
                graphics2D2.setStroke(new BasicStroke(1.0f));
            } else if (this.mode == Mode.translate) {
                Line2D.Double double_ = new Line2D.Double(point3, point4);
                graphics2D2.draw(double_);
                graphics2D2.setStroke(new BasicStroke(1.0f));
                Line2D.Double double_2 = new Line2D.Double(point, point2);
                graphics2D2.draw(double_2);
                if (this.activeMoveDirection != null) {
                    double d = 1.0 / this.activeMoveDirection.distance(0.0, 0.0);
                    EastNorth eastNorth = new EastNorth(this.activeMoveDirection.getX() * d, this.activeMoveDirection.getY() * d);
                    if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != eastNorth.getX() > -0.0) {
                        eastNorth = new EastNorth(-eastNorth.getX(), -eastNorth.getY());
                    }
                    eastNorth.setLocation(eastNorth.getX(), -eastNorth.getY());
                    Point2D.Double double_3 = new Point2D.Double((point.getX() + point2.getX()) * 0.5, (point.getY() + point2.getY()) * 0.5);
                    Line2D line2D = ExtrudeAction.createSemiInfiniteLine(double_3, eastNorth, graphics2D2);
                    graphics2D2.draw(line2D);
                    if (this.activeMoveDirection == this.possibleMoveDirections.get(0)) {
                        double d2 = 1.0 / graphics2D2.getTransform().getScaleX();
                        double d3 = 8.0 * d2 * eastNorth.getX();
                        double d4 = 8.0 * d2 * eastNorth.getY();
                        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_3).getX() + d3, ((Point2D)double_3).getY() + d4);
                        Point2D.Double double_5 = new Point2D.Double(((Point2D)double_3).getX() - d4, ((Point2D)double_3).getY() + d3);
                        Point2D.Double double_6 = new Point2D.Double(((Point2D)double_4).getX() - d4, ((Point2D)double_4).getY() + d3);
                        GeneralPath generalPath = new GeneralPath();
                        generalPath.moveTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
                        generalPath.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
                        generalPath.lineTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
                        graphics2D2.draw(generalPath);
                    }
                }
            }
        }
    }

    private static Line2D createSemiInfiniteLine(Point2D point2D, Point2D point2D2, Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getDeviceConfiguration().getBounds();
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            Point2D point2D3 = affineTransform.deltaTransform(new Point2D.Double(rectangle.width, 0.0), null);
            Point2D point2D4 = affineTransform.deltaTransform(new Point2D.Double(0.0, rectangle.height), null);
            double d = Math.abs(point2D3.getX()) + Math.abs(point2D3.getY()) + Math.abs(point2D4.getX()) + Math.abs(point2D4.getY());
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * d, point2D.getY() + point2D2.getY() * d));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * 10.0, point2D.getY() + point2D2.getY() * 10.0));
        }
    }

    private static Cursor getCursor(String string, String string2, int n) {
        try {
            return ImageProvider.getCursor(string, string2);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(n);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(cursor);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        extrude,
        translate,
        select;

    }
}

