/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
implements ActionListener {
    public final String text;
    public final Map<String, String> textMap = new HashMap<String, String>();
    public final Icon symbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private CachedLatLon coor;
    public static LinkedList<MarkerProducers> markerProducers = new LinkedList();
    private static final IntegerProperty PROP_LABEL = new IntegerProperty("draw.rawgps.layer.wpt", 0);
    private static final String[] labelAttributes = new String[]{"name", "desc"};

    public final void setCoor(LatLon latLon) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(latLon);
        } else {
            this.coor.setCoor(latLon);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor.setEastNorth(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public Marker(LatLon latLon, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        this.setCoor(latLon);
        this.text = string == null || string.length() == 0 ? null : string;
        this.offset = d2;
        this.time = d;
        this.symbol = ImageProvider.getIfAvailable("markers", string2);
        this.parentLayer = markerLayer;
    }

    public Marker(LatLon latLon, Map<String, String> map, String string, MarkerLayer markerLayer, double d, double d2) {
        this.setCoor(latLon);
        if (map != null) {
            this.textMap.clear();
            this.textMap.putAll(map);
        }
        this.text = null;
        this.offset = d2;
        this.time = d;
        this.symbol = ImageProvider.getIfAvailable("markers", string);
        this.parentLayer = markerLayer;
    }

    public boolean containsPoint(Point point) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void paint(Graphics graphics, MapView mapView, boolean bl, boolean bl2) {
        Point point = mapView.getPoint(this.getEastNorth());
        if (this.symbol != null && bl2) {
            this.symbol.paintIcon(mapView, graphics, point.x - this.symbol.getIconWidth() / 2, point.y - this.symbol.getIconHeight() / 2);
        } else {
            graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
            graphics.drawLine(point.x + 2, point.y - 2, point.x - 2, point.y + 2);
        }
        String string = this.getText();
        if (string != null && bl2) {
            graphics.drawString(string, point.x + 4, point.y + 2);
        }
    }

    public static Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
        for (MarkerProducers markerProducers : Marker.markerProducers) {
            Marker marker = markerProducers.createMarker(wayPoint, file, markerLayer, d, d2);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public AudioMarker audioMarkerFromMarker(String string) {
        AudioMarker audioMarker = AudioMarker.create(this.getCoor(), this.getText(), string, this.parentLayer, this.time, this.offset);
        return audioMarker;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return Marker.getText(this.textMap);
    }

    private static String getText(Map<String, String> map) {
        String string = "";
        if (map != null && !map.isEmpty()) {
            switch (PROP_LABEL.get()) {
                case 1: {
                    if (!map.containsKey("name")) break;
                    string = map.get("name");
                    break;
                }
                case 2: {
                    if (!map.containsKey("desc")) break;
                    string = map.get("desc");
                    break;
                }
                case 0: 
                case 3: {
                    if (map.containsKey("name")) {
                        string = map.get("name");
                        if (!map.containsKey("desc") || PROP_LABEL.get() == 0 && string.equals(map.get("desc"))) break;
                        string = string + " - " + map.get("desc");
                        break;
                    }
                    if (!map.containsKey("desc")) break;
                    string = map.get("desc");
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        return string;
    }

    static {
        markerProducers.add(new MarkerProducers(){

            /*
             * WARNING - void declaration
             */
            public Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
                Object object2;
                String string = null;
                try {
                    object2 = ((Collection)wayPoint.attr.get("meta.links")).iterator();
                    if (object2.hasNext()) {
                        GpxLink object = (GpxLink)object2.next();
                        string = object.uri;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (file != null && string != null && !this.isWellFormedAddress(string)) {
                    string = new File(file.getParentFile(), string).toURI().toString();
                }
                object2 = new HashMap();
                for (String string2 : labelAttributes) {
                    if (!wayPoint.attr.containsKey(string2)) continue;
                    object2.put(string2, wayPoint.getString(string2));
                }
                if (string == null) {
                    void var10_13;
                    String string3 = wayPoint.getString("symbol");
                    if (string3 == null) {
                        String string4 = wayPoint.getString("sym");
                    }
                    return new Marker(wayPoint.getCoor(), (Map<String, String>)object2, (String)var10_13, markerLayer, d, d2);
                }
                if (string.endsWith(".wav")) {
                    return AudioMarker.create(wayPoint.getCoor(), Marker.getText((Map)object2), string, markerLayer, d, d2);
                }
                if (string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".gif")) {
                    return ImageMarker.create(wayPoint.getCoor(), string, markerLayer, d, d2);
                }
                return WebMarker.create(wayPoint.getCoor(), string, markerLayer, d, d2);
            }

            private boolean isWellFormedAddress(String string) {
                try {
                    new URL(string);
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
        });
    }
}

