/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.StyleSourceEditor;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private StyleSourceEditor sources;
    private JCheckBox sortMenu;
    private JCheckBox enableDefault;
    private PreferenceTabbedPane.ValidationListener validationListener = new PreferenceTabbedPane.ValidationListener(){

        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveStylesChanged()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                block15: for (String string : TaggingPresetPreference.this.sources.getActiveStyles()) {
                    boolean bl = false;
                    try {
                        TaggingPreset.readAll(string, false);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        System.err.println(I18n.tr("Warning: Could not read tagging preset source: {0}", string));
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Error"), new String[]{I18n.tr("Yes"), I18n.tr("No"), I18n.tr("Cancel")});
                        extendedDialog.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", string));
                        switch (extendedDialog.showDialog().getValue()) {
                            case 1: {
                                continue block15;
                            }
                            case 2: {
                                arrayList.add(string);
                                continue block15;
                            }
                        }
                        return false;
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    String string2 = null;
                    try {
                        TaggingPreset.readAll(string, true);
                    }
                    catch (IOException iOException) {
                        String string3 = I18n.tr("Could not read tagging preset source {0}", string);
                        System.err.println(string3);
                        JOptionPane.showMessageDialog(Main.parent, string3);
                        return false;
                    }
                    catch (SAXParseException sAXParseException) {
                        string2 = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
                    }
                    catch (SAXException sAXException) {
                        string2 = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", string, sAXException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", string, sAXException.getMessage());
                    }
                    if (string2 == null) continue;
                    System.err.println("Error: " + string2);
                    int n = JOptionPane.showConfirmDialog(Main.parent, new JLabel(string2), I18n.tr("Error"), 1, 0);
                    switch (n) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            arrayList.add(string);
                            continue block15;
                        }
                    }
                    return false;
                }
                for (String string : arrayList) {
                    TaggingPresetPreference.this.sources.removeSource(string);
                }
                return true;
            }
            return true;
        }
    };

    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("taggingpreset.enable-defaults", true));
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)this.enableDefault, GBC.eol().insets(5, 0, 5, 0));
        this.sources = new StyleSourceEditor("taggingpreset.sources", "taggingpreset.icon.sources", "http://josm.openstreetmap.de/presets");
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        preferenceTabbedPane.mapcontent.addTab(I18n.tr("Tagging Presets"), jPanel);
        preferenceTabbedPane.mapcontent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (preferenceTabbedPane.mapcontent.getSelectedComponent() == jPanel) {
                    TaggingPresetPreference.this.sources.initiallyLoadAvailableStyles();
                }
            }
        });
        preferenceTabbedPane.addValidationListener(this.validationListener);
    }

    public boolean ok() {
        boolean bl = Main.pref.put("taggingpreset.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        if (Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null)) {
            bl = true;
        }
        if (this.sources.finish()) {
            bl = true;
        }
        return bl;
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences(false);
        for (TaggingPreset object : taggingPresets) {
            if (object instanceof TaggingPresetSeparator) continue;
            Main.toolbar.register(object);
        }
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            AutoCompletionManager.cachePresets(taggingPresets);
            HashMap hashMap = new HashMap();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : Main.main.menu.presetsMenu;
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    jMenuItem.setText(taggingPreset.getLocaleName());
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(taggingPreset.getLocaleName());
                jMenu.add(jMenuItem);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

