/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data"), "updatedata", I18n.tr("Updates the objects in the active data layer from the server."), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update data"), 85, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateData"));
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public void updateLayer(OsmDataLayer osmDataLayer) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getEditLayer() == null) {
            return;
        }
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (DataSource dataSource : this.getEditLayer().data.dataSources) {
            arrayList.add(new Area(dataSource.bounds.asRect()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            for (int i = n - 1; i > 0; --i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        ArrayList<Area> arrayList2 = new ArrayList<Area>();
        for (Area object : arrayList) {
            if (object.isEmpty()) continue;
            arrayList2.add(object);
        }
        if (arrayList2.isEmpty()) {
            new UpdateSelectionAction().updatePrimitives(this.getEditLayer().data.allPrimitives());
        } else {
            final PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download data"));
            final Future<?> future = new DownloadOsmTaskList().download(false, (Collection<Area>)arrayList2, (ProgressMonitor)pleaseWaitProgressMonitor);
            Main.worker.submit(new Runnable(){

                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    pleaseWaitProgressMonitor.close();
                }
            });
        }
    }
}

